/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeUtils {
    private static final Logger logger = Logger.getLogger(RuntimeUtils.class.getName());
    private static Map<String, String> envvars;

    private RuntimeUtils() {
    }

    public static boolean isWindows() {
        return System.getProperties().getProperty("os.name").indexOf("Windows") != -1;
    }

    public static Map<String, String> getEnvVars() throws IOException {
        HashMap<String, String> envvars = new HashMap<String, String>();
        String listingCmd = "env";
        if (RuntimeUtils.isWindows()) {
            listingCmd = "cmd /c set";
        }
        Process p = Runtime.getRuntime().exec(listingCmd);
        RuntimeUtils.startStreamReaper(listingCmd, p.getErrorStream(), System.err);
        BufferedReader buffreader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = buffreader.readLine();
        while (line != null) {
            int eqpos = line.indexOf(61);
            String key = line.substring(0, eqpos);
            String value = line.substring(eqpos + 1);
            envvars.put(key, value);
            line = buffreader.readLine();
        }
        return envvars;
    }

    public static Procezz startProcess(String[] arguments, File workDir, PrintStream out, PrintStream err) throws IOException {
        return RuntimeUtils.startProcess(arguments, workDir, new PrintStream[]{out, err}, null);
    }

    private static Procezz startProcess(String[] arguments, File workDir, PrintStream[] captStreams, Thread[] reapersHolder) throws IOException {
        String[] args = RuntimeUtils.fixWindowsExecExt(arguments);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Starting " + RuntimeUtils.argsToLine(args) + "...");
        }
        Process p = Runtime.getRuntime().exec(args, null, workDir);
        Thread outReaper = RuntimeUtils.startStreamReaper(args[0], p.getInputStream(), captStreams[0]);
        Thread errReaper = RuntimeUtils.startStreamReaper(args[0], p.getErrorStream(), captStreams[1]);
        if (reapersHolder != null) {
            if (reapersHolder.length != 2) {
                throw new IllegalArgumentException("The reapers' holder must except exactly two elements instead of " + reapersHolder.length);
            }
            reapersHolder[0] = outReaper;
            reapersHolder[1] = errReaper;
        }
        return new Procezz(p, outReaper, errReaper);
    }

    private static String[] fixWindowsExecExt(String[] arguments) throws FileNotFoundException {
        if (RuntimeUtils.isWindows()) {
            File f = new File(arguments[0]);
            if (f.exists()) {
                return arguments;
            }
            String fname = arguments[0] + ".exe";
            f = new File(fname);
            if (f.exists()) {
                arguments[0] = fname;
                return arguments;
            }
            fname = arguments[0] + ".bat";
            f = new File(fname);
            if (f.exists()) {
                String[] args = new String[arguments.length + 2];
                args[0] = "cmd.exe";
                args[1] = "/C";
                args[2] = fname;
                for (int i = 1; i < arguments.length; ++i) {
                    args[i + 2] = arguments[i];
                }
                return args;
            }
        }
        return arguments;
    }

    private static String argsToLine(String[] arguments) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            sb.append(arg).append(" ");
        }
        return sb.toString();
    }

    private static Thread startStreamReaper(String programName, final InputStream inputStream, final PrintStream out) {
        final String streamName = programName + "::" + (out == System.out ? "System.out" : (out == System.err ? "System.err" : out));
        Thread streamReaper = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Stream reaper for " + streamName + " is started.");
                }
                try {
                    byte[] buffer = new byte[4096];
                    int count = inputStream.read(buffer);
                    while (count != -1) {
                        String o = new String(buffer, 0, count);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(o);
                        }
                        if (out != null) {
                            out.print(o);
                        }
                        count = inputStream.read(buffer);
                    }
                }
                catch (Throwable throwable) {
                    System.err.println(throwable);
                }
                finally {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Stream reaper for " + streamName + " is finished.");
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
        };
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting stream reaper for " + streamName + "...");
        }
        streamReaper.start();
        return streamReaper;
    }

    public static String exec(String[] arguments) throws IOException, InterruptedException {
        return RuntimeUtils.exec(arguments, (File)null, 0);
    }

    public static String exec(String[] arguments, int exitCode) throws IOException, InterruptedException {
        return RuntimeUtils.exec(arguments, (File)null, exitCode);
    }

    public static String exec(String[] arguments, File workDir, int exitCode) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(berr);
        Procezz p = RuntimeUtils.startProcess(arguments, workDir, out, err);
        int l_exitCode = p.waitFor();
        if (l_exitCode != exitCode) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Exit code: " + l_exitCode + ", expected: " + exitCode);
            }
            throw new RuntimeException(berr.toString());
        }
        return new String(bout.toByteArray());
    }

    public static String exec(String[] arguments, String input) throws IOException, InterruptedException {
        return RuntimeUtils.exec(arguments, input, 0);
    }

    public static String exec(String[] arguments, final String input, int exitCode) throws IOException, InterruptedException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Starting " + RuntimeUtils.argsToLine(arguments) + ", input=" + input + "...");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        ByteArrayOutputStream berr = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(bout);
        final Procezz p = RuntimeUtils.startProcess(arguments, null, out, err);
        Thread t = new Thread(){

            @Override
            public void run() {
                block2: {
                    BufferedOutputStream appInStream = new BufferedOutputStream(p.getStdInput());
                    try {
                        ((OutputStream)appInStream).write(input.getBytes());
                        ((OutputStream)appInStream).flush();
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable(Level.FINE)) break block2;
                        logger.log(Level.FINE, "-", e);
                    }
                }
            }
        };
        t.start();
        if (p.waitFor() != exitCode) {
            throw new RuntimeException(RuntimeUtils.argsToLine(arguments) + " failed with:\n----------------------" + bout.toString() + "\n" + berr.toString() + "\n----------------------");
        }
        return new String(bout.toByteArray());
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        RuntimeUtils.exec(new String[]{"sqlplus", "-L", "system@mydb", "@C:\\Users\\pkovacs\\zazi@noon\\fs12969.sql"}, "oracle\n");
    }

    public static String getEnvVar(String var) throws IOException {
        try {
            return System.getenv(var);
        }
        catch (Error error) {
            if (envvars == null) {
                envvars = RuntimeUtils.getEnvVars();
            }
            return envvars.get(var);
        }
    }

    public static class Procezz {
        private Process process;
        private Thread outReaper;
        private Thread errReaper;

        public Procezz(Process process, Thread outReaper, Thread errReaper) {
            this.process = process;
            this.outReaper = outReaper;
            this.errReaper = errReaper;
        }

        public int waitFor() throws InterruptedException {
            int exitCode = this.process.waitFor();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("exitCode=" + exitCode);
            }
            this.outReaper.join();
            this.errReaper.join();
            return exitCode;
        }

        public void destroy() {
            this.process.destroy();
        }

        public OutputStream getStdInput() {
            return this.process.getOutputStream();
        }
    }
}

