/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.core.util.BondTable;
import chemaxon.descriptors.DescriptorGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.SimilarityCalculator;
import chemaxon.descriptors.SimilarityCalculatorFactory;
import chemaxon.descriptors.SimilarityException;
import chemaxon.jchem.db.TableTypeConstants;
import chemaxon.marvin.modules.MCES;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.util.BoundingBox;
import chemaxon.util.HitColoringAndAlignmentOptions;
import chemaxon.util.HitDisplayUtil;
import chemaxon.util.MolHandler;
import java.text.ParseException;
import java.util.Arrays;

final class SimilaritySearchDisplay {
    private static final double LABEL_WIDTH = 1.6;
    private static final double LABEL_PADDING_LEFT = 0.1;
    private static final int FONT_SIZE_DIVISOR = 12;
    private static final boolean VERBOSE = false;
    private static final double ASSUMED_DEFAULT_FONT_SIZE = 12.0;
    private static final String ASSUMED_DEFAULT_FONT_FAMILY = "SansSerif";
    private static final double RATIO = 0.5;
    private static final int QUERY_HIT_BOND = 4;
    private static final int QUERY_NON_HIT_BOND = 3;
    private static final int QUERY_HIT_ATOM = 4;
    private static final int QUERY_NON_HIT_ATOM = 3;
    private Standardizer standardizer;

    SimilaritySearchDisplay() {
    }

    private MCES getSearcher() {
        MCES searcher = new MCES();
        searcher.setAtomTypeMatch(true);
        searcher.setBondTypeMatch(true);
        searcher.setHybridizationMatch(false);
        searcher.setChargeMatch(false);
        searcher.setIsotopeMatch(false);
        searcher.setMinComponentSize(2);
        searcher.disableAromatization();
        return searcher;
    }

    private void colorMCS(Molecule qcol, Molecule tcol, HitColoringAndAlignmentOptions opts, float dissim) throws SearchException, SimilarityException, MDGeneratorException {
        Molecule queryMol = qcol;
        int[] standardizerQueryMapOldNew = new int[qcol.getAtomCount()];
        int[] standardizerQueryMapNewOld = new int[qcol.getAtomCount()];
        int idx = 0;
        while (idx < standardizerQueryMapOldNew.length) {
            standardizerQueryMapOldNew[idx] = idx;
            standardizerQueryMapNewOld[idx] = idx++;
        }
        Molecule targetMol = tcol;
        int[] standardizerTargetMapNewOld = new int[tcol.getAtomCount()];
        int idx2 = 0;
        while (idx2 < standardizerTargetMapNewOld.length) {
            standardizerTargetMapNewOld[idx2] = idx2++;
        }
        if (this.standardizer != null) {
            queryMol = queryMol.cloneMolecule();
            targetMol = targetMol.cloneMolecule();
            this.standardizer.setAtomIndexQuery(true);
            this.standardizer.standardize(queryMol);
            standardizerQueryMapOldNew = this.standardizer.getOldToNew();
            standardizerQueryMapNewOld = this.standardizer.getNewToOld();
            this.standardizer.standardize(targetMol);
            standardizerTargetMapNewOld = this.standardizer.getNewToOld();
        }
        boolean colored = false;
        if (dissim == 0.0f) {
            colored = this.colorWithMolSearch(qcol, tcol, opts, queryMol, targetMol, standardizerQueryMapNewOld, standardizerTargetMapNewOld);
        }
        if (!colored && this.getDissimilarityValue(targetMol, queryMol) == 0.0f) {
            colored = this.colorWithMolSearch(tcol, qcol, opts, targetMol, queryMol, standardizerTargetMapNewOld, standardizerQueryMapNewOld);
        }
        if (!colored) {
            MCES searcher = this.getSearcher();
            searcher.setMolecules(queryMol, targetMol);
            searcher.search();
            Molecule mcs = qcol.cloneMolecule();
            int[] am = searcher.getAtomMapping();
            int[] bm = searcher.getBondMapping();
            this.removeNonMCSBondsAtoms(mcs, queryMol, standardizerQueryMapOldNew, bm, am);
            int[] mcsToQueryMap = new int[mcs.getAtomCount()];
            int[] mcsToTargetMap = new int[mcs.getAtomCount()];
            int mcsId = 0;
            for (int i = 0; i < am.length; ++i) {
                if (am[i] < 0) continue;
                mcsToQueryMap[mcsId] = standardizerQueryMapNewOld[i];
                mcsToTargetMap[mcsId] = standardizerTargetMapNewOld[am[i]];
                ++mcsId;
            }
            new MolHandler(qcol).align(tcol, searcher.getAtomMapping());
            HitDisplayUtil.color(mcs, qcol, mcsToQueryMap, opts);
            HitDisplayUtil.color(mcs, tcol, mcsToTargetMap, opts);
        }
        this.colorBonds(qcol);
        this.colorBonds(tcol);
    }

    private void colorBonds(Molecule qcol) {
        MolBond[] bonds = qcol.getBondArray();
        int bondCount = bonds.length;
        for (int bondIndex = 0; bondIndex < bondCount; ++bondIndex) {
            if (bonds[bondIndex].getSetSeq() != 0) continue;
            MolAtom atom1 = bonds[bondIndex].getAtom1();
            MolAtom atom2 = bonds[bondIndex].getAtom2();
            if (atom1.getSetSeq() == 1 && atom2.getSetSeq() == 1) continue;
            bonds[bondIndex].setSetSeq(1);
        }
    }

    private boolean colorWithMolSearch(Molecule qcol, Molecule tcol, HitColoringAndAlignmentOptions opts, Molecule queryMol, Molecule targetMol, int[] queryMap, int[] targetMap) throws SearchException {
        Molecule qm = qcol.cloneMolecule();
        Molecule tm = tcol.cloneMolecule();
        int[] hit = this.getSearchHit(queryMol, targetMol, 2);
        if (hit != null) {
            int[] queryHit = new int[qcol.getAtomCount()];
            int[] targetHit = new int[tcol.getAtomCount()];
            Arrays.fill(queryHit, -1);
            Arrays.fill(targetHit, -1);
            for (int i = hit.length - 1; i >= 0; --i) {
                if (hit[i] < 0) continue;
                queryHit[queryMap[i]] = queryMap[i];
                targetHit[targetMap[hit[i]]] = targetMap[hit[i]];
            }
            new MolHandler(qcol).align(tcol, queryHit);
            HitDisplayUtil.color(qm, qcol, queryHit, opts);
            HitDisplayUtil.color(tm, tcol, targetHit, opts);
            return true;
        }
        return false;
    }

    private int[] getSearchHit(Molecule queryMol, Molecule targetMol, int searchType) throws SearchException {
        MolSearch ms = new MolSearch();
        ms.setSearchOptions(new MolSearchOptions(searchType));
        ms.setQuery(queryMol);
        ms.setTarget(targetMol);
        if (ms.isMatching()) {
            return ms.findFirst();
        }
        return null;
    }

    private void removeNonMCSBondsAtoms(Molecule mcs, MoleculeGraph standardizedQueryMol, int[] standardizerQueryMapOldNew, int[] bm, int[] am) {
        BondTable bondTable = standardizedQueryMol.getBondTable();
        for (int bondIdx = mcs.getBondCount() - 1; bondIdx >= 0; --bondIdx) {
            MolBond bond = mcs.getBond(bondIdx);
            int from = mcs.indexOf(bond.getAtom1());
            from = standardizerQueryMapOldNew[from];
            int to = mcs.indexOf(bond.getAtom2());
            if ((to = standardizerQueryMapOldNew[to]) < 0 || from < 0) {
                mcs.removeBond(bondIdx);
                continue;
            }
            int bondIdxStandardized = bondTable.getBondIndex(from, to);
            if (bondIdxStandardized < 0) {
                mcs.removeBond(bondIdx);
                continue;
            }
            if (bm[bondIdxStandardized] >= 0) continue;
            mcs.removeBond(bondIdx);
        }
        for (int i = mcs.getAtomCount() - 1; i >= 0; --i) {
            if (standardizerQueryMapOldNew[i] >= 0 && am[standardizerQueryMapOldNew[i]] >= 0) continue;
            mcs.removeAtom(i);
        }
    }

    private void println(String message) {
    }

    private float getDissimilarityValue(Molecule q, Molecule t) throws MDGeneratorException, SimilarityException {
        DescriptorGenerator gen = new DescriptorGenerator("CF");
        gen.setParameter("Length", Integer.toString(32 * TableTypeConstants.FP_DEFAULT_LENGTH_IN_INTS[0]));
        gen.setParameter("BondCount", Integer.toString(TableTypeConstants.FP_DEFAULT_PATTERN_LENGTH[0]));
        gen.setParameter("BitCount", Integer.toString(TableTypeConstants.FP_DEFAULT_BITS_PER_PATTERN[0]));
        gen.setStandardizer(this.standardizer);
        gen.generate(q);
        int[] fpQuery = gen.getAsIntArray();
        gen.generate(t);
        int[] fpTarget = gen.getAsIntArray();
        try {
            SimilarityCalculator<int[]> calc = SimilarityCalculatorFactory.create("Tanimoto");
            calc.setQueryFingerprint(fpQuery);
            float dissim2 = calc.getDissimilarity(fpTarget);
            return dissim2;
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid similarity metric!");
        }
    }

    private BoundingBox getBoundingBox(Molecule m) {
        double z_max;
        double y_max;
        double x_max;
        int n = m.getAtomCount();
        MolAtom a = m.getAtom(0);
        DPoint3 cord0 = a.getLocation();
        double x_min = x_max = cord0.x;
        double y_min = y_max = cord0.y;
        double z_min = z_max = cord0.z;
        for (int i = 1; i < n; ++i) {
            DPoint3 pos = m.getAtom(i).getLocation();
            this.println("x " + i + ": " + pos.x);
            this.println("y " + i + ": " + pos.y);
            if (pos.x < x_min) {
                x_min = pos.x;
            } else if (pos.x > x_max) {
                x_max = pos.x;
            }
            if (pos.y < y_min) {
                y_min = pos.y;
            } else if (pos.y > y_max) {
                y_max = pos.y;
            }
            if (pos.z < z_min) {
                z_min = pos.z;
                continue;
            }
            if (!(pos.z > z_max)) continue;
            z_max = pos.z;
        }
        this.println("Bounding box: " + x_min + ", " + x_max + ", " + y_min + ", " + y_max);
        return new BoundingBox(x_min, x_max, y_min, y_max, z_min, z_max);
    }

    private boolean isDegenerateIn2D(BoundingBox box) {
        return box.x_min == box.x_max && box.y_min == box.y_max;
    }

    private boolean isDegenerateIn3D(BoundingBox box) {
        return this.isDegenerateIn2D(box) && box.z_min == box.z_max;
    }

    private void cleanIfNeeded(Molecule m, int dim) {
        if (m.getAtomCount() < 1) {
            throw new IllegalArgumentException("The molecule should contain at least one atom");
        }
        BoundingBox box = this.getBoundingBox(m);
        if (dim == 3 && this.isDegenerateIn3D(box) || this.isDegenerateIn2D(box)) {
            m.clean(dim, "");
        }
    }

    private void cleanIfNeeded(Molecule qcol, Molecule tcol) {
        int dim = 2;
        if (qcol.getDim() == 3 || tcol.getDim() == 3) {
            dim = 3;
        }
        this.cleanIfNeeded(qcol, dim);
        this.cleanIfNeeded(tcol, dim);
    }

    private int getNonHitColor(HitColoringAndAlignmentOptions opts, int dim) {
        if (dim == 2) {
            return opts.nonHitColor.getRGB();
        }
        if (dim == 3) {
            return opts.nonHitColor3D.getRGB();
        }
        throw new IllegalArgumentException("Dimension should be 2 or 3 but it is " + dim);
    }

    private void colorSmallQuery(Molecule target, HitColoringAndAlignmentOptions opts) {
        MDocument md = target.getDocument();
        int HIT_COLOR = opts.hitColor.getRGB();
        int NON_HIT_COLOR = this.getNonHitColor(opts, target.getDim());
        md.setAtomSetRGB(4, HIT_COLOR);
        md.setAtomSetRGB(3, NON_HIT_COLOR);
        md.setBondSetRGB(4, HIT_COLOR);
        md.setBondSetRGB(3, NON_HIT_COLOR);
    }

    private void resizeSmallQueryFonts(Molecule m, double ratio) {
        MDocument mdoc = m.getDocument();
        double newFontSize = ratio * 12.0;
        MFont resizedFont = new MFont(ASSUMED_DEFAULT_FONT_FAMILY, 0, newFontSize);
        int[] set = new int[]{4, 3};
        for (int i = 0; i <= 1; ++i) {
            mdoc.setAtomSetFont(set[i], resizedFont);
        }
    }

    private void resize(Molecule m, double ratio) {
        CTransform3D t = new CTransform3D();
        t.setScale(ratio);
        m.transform(t);
    }

    private void attachValueAsText(HitColoringAndAlignmentOptions options, Molecule mol, float val, String type) {
        BoundingBox box2 = this.getBoundingBox(mol);
        double s = this.getMoleculeFontSize(mol, 0.0) / 12.0;
        MTextBox textBox = new MTextBox();
        double left = options.isQueryDisplay() ? box2.x_max + s : box2.x_min - 2.7 * s;
        double top = box2.y_max + s;
        MDocument doc = mol.getDocument();
        if (options.isDisplayLabelsAndBoxes()) {
            this.drawRectangle(doc, left, top + s, 0.0, left + 1.7000000000000002 * s, top, 0.0);
            this.drawLabel(doc, left + 0.1 * s, left + 1.6 * s, top + s, s, "Score");
        }
        MPoint topLeft = new MPoint(left + 0.1 * s, top + s);
        MPoint bottomRight = new MPoint(left + 1.6 * s, top);
        textBox.setCorners(topLeft, bottomRight);
        textBox.setHorizontalAlignment(options.isQueryDisplay() ? 0 : 2);
        textBox.setVerticalAlignment(0);
        textBox.setAutoSize(true);
        String value = String.format("%.3f", Float.valueOf(val));
        textBox.setText(value);
        doc.addObject(textBox);
        mol.setProperty(type, value);
    }

    private void alignMolecule(Molecule m1, Molecule m2) {
        double m1_fontsize = this.getMoleculeFontSize(m1, 0.0) / 12.0;
        double m2_fontsize = this.getMoleculeFontSize(m2, 0.0) / 12.0;
        BoundingBox box1 = this.getBoundingBox(m1);
        BoundingBox box2 = this.getBoundingBox(m2);
        double s = m1_fontsize + m2_fontsize;
        double r_x = box1.x_max - box2.x_min;
        double r_y = box1.y_min - box2.y_max;
        double r_z = -box2.z_max;
        CTransform3D t2 = new CTransform3D();
        t2.setTranslation(r_x + s, r_y - s, r_z);
        m2.getDocument().transform(t2);
        if (box1.z_max != 0.0) {
            CTransform3D tz = new CTransform3D();
            tz.setTranslation(0.0, 0.0, -box1.z_max);
            m1.getDocument().transform(tz);
        }
    }

    private double getMoleculeFontSize(Molecule m, double fontsize) {
        MDocument mdoc = m.getDocument();
        for (int setIndex = 0; setIndex < mdoc.getAtomSetSize(); ++setIndex) {
            MFont font = mdoc.getAtomSetFont(setIndex);
            fontsize = font != null ? Math.max(fontsize, font.getSizeDouble()) : Math.max(fontsize, 12.0);
        }
        return fontsize;
    }

    private void displayValue(HitColoringAndAlignmentOptions options, Molecule mol, float dissim) {
        if (options.similarityScoreDisplay == 1) {
            return;
        }
        float value = Float.NaN;
        String type = "SIMILARITY";
        if (options.similarityScoreDisplay == 3) {
            value = 1.0f - dissim;
        } else if (options.similarityScoreDisplay == 2) {
            value = dissim;
            type = "DISSIMILARITY";
        } else {
            throw new IllegalArgumentException("Type should be either similarity or dissimilarity");
        }
        this.attachValueAsText(options, mol, value, type);
    }

    private void renumberBondSets(Molecule m) {
        for (int i = 0; i < m.getBondCount(); ++i) {
            MolBond b = m.getBond(i);
            int seq = b.getSetSeq();
            int newSeq = -1;
            if (seq == 0) {
                newSeq = 4;
            } else if (seq == 1) {
                newSeq = 3;
            } else {
                throw new RuntimeException("Unexpected bond set value!");
            }
            b.setSetSeq(newSeq);
        }
    }

    private void renumberAtomSets(Molecule m) {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            int seq = a.getSetSeq();
            int newSeq = -1;
            if (seq == 1) {
                newSeq = 4;
            } else if (seq == 0) {
                newSeq = 3;
            } else {
                throw new RuntimeException("Unexpected atom set value!");
            }
            a.setSetSeq(newSeq);
        }
    }

    Molecule getTargetWithQuery(Molecule q, Molecule t, HitColoringAndAlignmentOptions opts, Standardizer standardizerToUse) throws MDGeneratorException, SearchException, SimilarityException {
        this.standardizer = standardizerToUse;
        float dissim = this.getDissimilarityValue(q, t);
        return this.getTargetWithQuery(q, t, opts, standardizerToUse, dissim);
    }

    Molecule getTargetWithQuery(Molecule q, Molecule t, HitColoringAndAlignmentOptions opts, Standardizer standardizerToUse, float dissim) throws SearchException, SimilarityException, MDGeneratorException {
        HitColoringAndAlignmentOptions localOpts = (HitColoringAndAlignmentOptions)opts.clone();
        this.standardizer = standardizerToUse;
        Molecule qcol = q.cloneMoleculeWithDocument();
        Molecule tcol = t.cloneMoleculeWithDocument();
        this.cleanIfNeeded(qcol, tcol);
        localOpts.coloring = true;
        localOpts.alignmentMode = 1;
        this.colorMCS(qcol, tcol, localOpts, dissim);
        if (localOpts.isDisplayLabelsAndBoxes()) {
            this.drawLabelAndBox(tcol, "Target");
        }
        this.displayValue(localOpts, tcol, dissim);
        if (localOpts.isQueryDisplay()) {
            this.resize(qcol, 0.5);
            if (localOpts.isDisplayLabelsAndBoxes()) {
                this.drawLabelAndBox(qcol, "Query");
            }
            this.alignMolecule(qcol, tcol);
            this.renumberAtomSets(qcol);
            this.renumberBondSets(qcol);
            this.fuseMolecules(tcol, qcol);
            this.colorSmallQuery(tcol, localOpts);
            this.resizeSmallQueryFonts(tcol, 0.5);
        }
        return tcol;
    }

    private void fuseMolecules(Molecule tcol, Molecule qcol) {
        MDocument tdoc = tcol.getDocument();
        MDocument qdoc = qcol.getDocument();
        for (int docIndex = qdoc.getObjectCount() - 1; docIndex > 0; --docIndex) {
            tdoc.addObject(qdoc.getObject(docIndex));
        }
        tcol.fuse(qcol);
    }

    private void drawLabelAndBox(Molecule mol, String label) {
        BoundingBox box = this.getBoundingBox(mol);
        double fontSize = this.getMoleculeFontSize(mol, 0.0) / 12.0;
        MDocument doc = mol.getDocument();
        this.drawRectangle(doc, box.x_min - fontSize, box.y_min - fontSize, box.z_min - fontSize, box.x_max + fontSize, box.y_max + fontSize, box.z_max + fontSize);
        this.drawLabel(doc, box.x_min - fontSize, box.x_max + fontSize, box.y_max + fontSize, fontSize, label);
    }

    private void drawRectangle(MDocument doc, double x_min, double y_min, double z_min, double x_max, double y_max, double z_max) {
        MRectangle mrect = new MRectangle(new MPoint(x_min, y_min, z_min), new MPoint(x_max, y_max, z_max));
        mrect.setThickness(MPolyline.DEFAULT_THICKNESS / 2.0);
        doc.addObject(mrect);
    }

    private void drawLabel(MDocument doc, double left, double right, double top, double fontsize, String label) {
        MTextBox tbox = new MTextBox();
        MPoint topLeft = new MPoint(left, top + fontsize);
        MPoint bottomRight = new MPoint(right, top);
        tbox.setCorners(topLeft, bottomRight);
        tbox.setHorizontalAlignment(1);
        tbox.setVerticalAlignment(0);
        tbox.setAutoSize(true);
        tbox.setText(label);
        doc.addObject(tbox);
    }
}

