/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;

public final class SmilesCompressor {
    private static final int[][] probability1 = new int[][]{{67, 2278}, {99, 2228}, {40, 929}, {41, 929}, {78, 507}, {79, 447}, {61, 422}, {49, 339}, {50, 334}, {51, 297}, {52, 171}, {32, 169}, {9, 150}, {110, 133}, {91, 130}, {93, 130}, {108, 78}, {43, 65}, {45, 45}, {92, 23}, {47, 21}, {64, 20}, {72, 19}, {70, 18}, {66, 17}, {62, 16}};
    private static final int[][] probability2 = new int[][]{{124, 100}, {58, 100}, {44, 100}, {114, 50}, {97, 20}, {111, 20}, {38, 20}, {36, 20}, {59, 20}, {119, 20}};
    private static final int[][] probability3 = new int[][]{{48, 100}, {49, 100}, {50, 100}, {51, 100}, {52, 100}, {53, 100}, {54, 100}, {55, 100}, {56, 100}, {57, 100}, {45, 100}, {46, 100}, {44, 100}, {59, 100}, {41, 100}};
    private static final int[][][] probability = new int[][][]{probability1, probability2, probability3};
    private static Node[] root = new Node[3];
    private static byte[][][] codes = new byte[3][256][];
    private byte[] buffer = new byte[1600];

    private static void calculateCodes(Node node, byte[] prefix, byte newBit, int mode) {
        byte[] code = new byte[prefix.length + 1];
        System.arraycopy(prefix, 0, code, 0, prefix.length);
        code[code.length - 1] = newBit;
        if (node.left != null) {
            SmilesCompressor.calculateCodes(node.left, code, (byte)0, mode);
            SmilesCompressor.calculateCodes(node.right, code, (byte)1, mode);
        } else {
            SmilesCompressor.codes[mode][node.code] = code;
        }
    }

    private static void createTree(int mode) {
        ArrayList<Node> trees = new ArrayList<Node>();
        for (int x = 30; x < 127; x = (int)((byte)(x + 1))) {
            int code = x == 30 ? 9 : x;
            int frequency = code == 31 ? 0 : 1;
            for (int y = 0; y < probability[mode].length; ++y) {
                int[] p = probability[mode][y];
                if (p[0] != code) continue;
                frequency = p[1];
                break;
            }
            trees.add(new Node((byte)code, frequency));
        }
        Collections.sort(trees);
        while (trees.size() > 1) {
            Node smallest = (Node)trees.get(0);
            Node small = (Node)trees.get(1);
            trees.remove(0);
            trees.remove(0);
            trees.add(new Node(smallest, small));
            Collections.sort(trees);
        }
        SmilesCompressor.root[mode] = (Node)trees.get(0);
        SmilesCompressor.calculateCodes(SmilesCompressor.root[mode].left, new byte[0], (byte)0, mode);
        SmilesCompressor.calculateCodes(SmilesCompressor.root[mode].right, new byte[0], (byte)1, mode);
    }

    public byte[] compress(byte[] smiles) {
        int mode = 0;
        if (this.buffer.length < 14 * smiles.length + 8) {
            this.buffer = new byte[14 * smiles.length + 8];
        }
        int p = 0;
        for (int x = 0; x < smiles.length; ++x) {
            byte ch = smiles[x];
            byte[] code = codes[mode][ch];
            if (code == null) {
                throw new IllegalArgumentException("Unexpected byte value for mode " + mode + ": " + ch);
            }
            for (int y = 0; y < code.length; ++y) {
                this.buffer[p++] = code[y];
            }
            if (ch == 32 || ch == 9) {
                mode = 1;
            }
            if (ch == 40 && mode == 1) {
                mode = 2;
            }
            if (ch != 41 || mode != 2) continue;
            mode = 1;
        }
        int excess = 8 - p % 8;
        if (excess == 8) {
            excess = 0;
        }
        byte[] dummy = codes[mode][31];
        int length = dummy.length;
        for (int x = 0; x < excess; ++x) {
            this.buffer[p++] = dummy[x % length];
        }
        int resSize = p / 8;
        byte[] result = new byte[resSize];
        for (int x = 0; x < result.length; ++x) {
            byte sum = 0;
            for (int y = 0; y < 8; ++y) {
                if (x * 8 + y >= p) continue;
                sum = (byte)(sum + this.buffer[x * 8 + y] * (1 << 7 - y));
            }
            result[x] = sum;
        }
        return result;
    }

    public byte[] compress(String smiles) {
        try {
            return this.compress(smiles.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decompress(byte[] csmiles) {
        int mode = 0;
        int max = csmiles.length * 8;
        byte[] bytes = new byte[csmiles.length * 4];
        Node node = root[mode];
        int p = 0;
        for (int x = 0; x < max; ++x) {
            int b = csmiles[x / 8] & 1 << 7 - x % 8;
            node = b == 0 ? node.left : node.right;
            if (node.left != null) continue;
            byte code = node.code;
            if (code == 31) break;
            bytes[p++] = code;
            if (code == 32 || code == 9) {
                mode = 1;
            }
            if (code == 40 && mode == 1) {
                mode = 2;
            }
            if (code == 41 && mode == 2) {
                mode = 1;
            }
            node = root[mode];
        }
        byte[] result = new byte[p];
        System.arraycopy(bytes, 0, result, 0, p);
        return result;
    }

    static {
        SmilesCompressor.createTree(0);
        SmilesCompressor.createTree(1);
        SmilesCompressor.createTree(2);
    }

    private static final class Node
    implements Comparable {
        int totalWeight;
        int frequency;
        byte code;
        Node left = null;
        Node right = null;

        public Node(byte code, int frequency) {
            this.code = code;
            this.frequency = frequency;
            this.totalWeight = frequency;
        }

        public Node(Node left, Node right) {
            this.left = left;
            this.right = right;
            this.totalWeight = left.totalWeight + right.totalWeight;
        }

        public int compareTo(Object other) {
            Node that = (Node)other;
            return this.totalWeight - that.totalWeight;
        }
    }
}

