/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.UnsupportedEncodingException;

public class StringConverter {
    public static String replaceString(String input, String query, String replacement) {
        int pos;
        StringBuffer sb = new StringBuffer();
        int from = 0;
        while ((pos = input.indexOf(query, from)) >= 0) {
            if (pos > from) {
                sb.append(input.substring(from, pos));
            }
            sb.append(replacement);
            from = pos + query.length();
        }
        if (input.length() > from) {
            sb.append(input.substring(from, input.length()));
        }
        return sb.toString();
    }

    public static String convertToUNIXStyle(String input) {
        String value = input;
        value = StringConverter.replaceString(value, "\r\n", "\n");
        value = StringConverter.replaceString(value, "\r", "\n");
        return value;
    }

    public static int skipDelimiters(String string, String delimiters, int pos, int count) {
        boolean inDelimBlock = delimiters.indexOf(string.charAt(0)) != -1;
        int skipped = 0;
        while (pos < string.length()) {
            char ch = string.charAt(pos);
            if (delimiters.indexOf(ch) != -1) {
                inDelimBlock = true;
            } else if (inDelimBlock) {
                inDelimBlock = false;
                if (++skipped >= count) {
                    return pos;
                }
            }
            ++pos;
        }
        return -1;
    }

    public static String megfejt(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("$CxCr$") || !string.startsWith("$CxCr$") || string.length() < 32) {
            return string;
        }
        String result = null;
        try {
            byte[] key = string.substring(6, 26).getBytes("ASCII");
            byte[] code = string.substring(26, string.length() - 6).getBytes("ASCII");
            for (int x = 0; x < code.length; ++x) {
                for (int nn = code[x] - 32 - key[x % key.length]; nn < 0; nn += 96) {
                }
                code[x] = (byte)(nn += 32);
            }
            result = new String(code, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

