/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.marvin.util.SwingUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SupportedPlatform {
    private static final Logger logger = Logger.getLogger(SupportedPlatform.class.getName());
    public static final String CHEMAXON_DISABLE_JAVA_CHECKING_PROPERTY = "chemaxon.disable.java.checking";
    public static final String JVM_DOWNLOAD_LINK = "http://www.oracle.com/technetwork/java/javase/downloads/index.html";
    public static final String JVM_DOWNLOAD_NAME = "ORACLE Java SE download page";
    private static final String JVM_DOWNLOAD_TEXT = "<html><body>SUN compatible JREs are available at the <a href=\"http://www.oracle.com/technetwork/java/javase/downloads/index.html\">ORACLE Java SE download page</a>.</body></html>";
    private static final String SUPPORTED_JAVA_VERSION_INFO = "<html>SUN compatible and MAC OS Java VMs are fully supported.<br>Others may also work well, but ChemAxon does not undertake full support<br>for its products when running under other VMs.</html>";
    private static final String DO_NOT_PERFORM_AGAIN = "Do not perform this check again.";
    private static boolean CHEMAXON_DISABLE_JAVA_CHECKING = false;
    private static String os;
    private static String arch;
    private static String vmname;
    private static String jver;
    private static boolean DEBUG;

    public static boolean isJavaCheckingEnabled() {
        return !CHEMAXON_DISABLE_JAVA_CHECKING;
    }

    public static boolean isJavaCheckingEnabled(Properties settings) {
        return !settings.getProperty(CHEMAXON_DISABLE_JAVA_CHECKING_PROPERTY, "false").equalsIgnoreCase("true");
    }

    public static void checkJava() throws RuntimeException {
        String err;
        if (SupportedPlatform.isJavaCheckingEnabled() && (err = SupportedPlatform.getJavaVersionErrorString()) != null) {
            throw new RuntimeException(err);
        }
    }

    public static boolean isSupportedJava() {
        return SupportedPlatform.getJavaVersionErrorString() == null;
    }

    private static void printPlatformInfo() {
        String os = System.getProperty("os.name");
        System.err.println("os:" + os);
        String arch = System.getProperty("os.arch");
        System.err.println("arch:" + arch);
        String osver = System.getProperty("os.version");
        System.err.println("os version:" + osver);
        String jver = System.getProperty("java.version");
        System.err.println("java version:" + jver);
        String jvendor = System.getProperty("java.vendor");
        System.err.println("java vendor:" + jvendor);
        System.err.println("java.vm.name:" + System.getProperty("java.vm.name"));
        System.err.println("java.vm.vendor:" + System.getProperty("java.vm.vendor"));
        System.err.println("chemaxon.disable.java.checking:" + System.getProperty(CHEMAXON_DISABLE_JAVA_CHECKING_PROPERTY));
        System.err.println("SupportedPlatform.CHEMAXON_DISABLE_JAVA_CHECKING:" + CHEMAXON_DISABLE_JAVA_CHECKING);
    }

    public static String getJavaVersionErrorString() {
        if (vmname.startsWith("Java HotSpot(TM)")) {
            boolean supported;
            if (os.startsWith("Linux")) {
                if (arch.equals("amd64") && jver.equals("1.6.0_06") && vmname.equals("Java HotSpot(TM) 64-Bit Server VM")) {
                    return "Buggy Java version: Java 1.6.0_06 64-bit Server VM for Linux amd64.";
                }
                if (jver.equals("1.6.0_03") && arch.equals("386")) {
                    return "Buggy Java version: Java 1.6.0_03 for Linux x86 32bit.";
                }
            }
            boolean bl = supported = !jver.startsWith("1.0") && !jver.startsWith("1.1") && !jver.startsWith("1.2") && !jver.startsWith("1.3") && !jver.startsWith("1.4.0") && !jver.startsWith("1.4.1") && !jver.startsWith("1.5");
            if (supported) {
                return null;
            }
            return "Deprecated Java version: " + jver + ".";
        }
        return "Unsupported Java VM type: " + vmname + ".";
    }

    public static String getJavaVersionErrorString(Properties settings) {
        return SupportedPlatform.isJavaCheckingEnabled(settings) ? SupportedPlatform.getJavaVersionErrorString() : null;
    }

    public static void showWarningIfNeeded(Container parent, Properties settings) {
        String err = SupportedPlatform.getJavaVersionErrorString(settings);
        if (err != null) {
            JOptionPane.showMessageDialog(parent, new MessageForm(err, SUPPORTED_JAVA_VERSION_INFO, JVM_DOWNLOAD_TEXT, settings), "Warning", 2);
        } else {
            logger.finest("Supported JVM: " + jver);
        }
    }

    static {
        DEBUG = false;
        os = System.getProperty("os.name");
        arch = System.getProperty("os.arch");
        vmname = System.getProperty("java.vm.name");
        jver = System.getProperty("java.version");
        CHEMAXON_DISABLE_JAVA_CHECKING = Boolean.getBoolean(System.getProperty(CHEMAXON_DISABLE_JAVA_CHECKING_PROPERTY));
        DEBUG = Boolean.getBoolean("chemaxon.debug");
        if (DEBUG) {
            SupportedPlatform.printPlatformInfo();
        }
    }

    private static class MessageForm
    extends JPanel
    implements ActionListener {
        private JCheckBox doNotPerformAgain;
        private Properties settings;

        public MessageForm(String message) {
            this(message, null, null, null);
        }

        public MessageForm(String message, String details, String help, Properties settings) {
            this.settings = settings;
            this.initGUI(message, details, help);
        }

        private void initGUI(String message, String details, String help) {
            this.setLayout(new BoxLayout(this, 1));
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 0));
            JLabel label = new JLabel(message);
            labelPanel.add(label);
            labelPanel.add(Box.createHorizontalGlue());
            this.add(labelPanel);
            this.add(Box.createVerticalStrut(10));
            if (details != null) {
                JPanel detailsPanel = new JPanel();
                JEditorPane detailsPane = SwingUtil.createMessagePane(details);
                detailsPanel.add(Box.createHorizontalStrut(10));
                detailsPanel.add(detailsPane);
                detailsPanel.add(Box.createHorizontalGlue());
                this.add(detailsPanel);
                this.add(Box.createVerticalStrut(10));
            }
            if (help != null) {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                JEditorPane pane = SwingUtil.createMessagePane(help);
                panel.add(pane);
                panel.add(Box.createHorizontalGlue());
                this.add(panel);
                this.add(Box.createVerticalStrut(20));
            }
            JPanel checkboxPanel = new JPanel();
            checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 0));
            this.doNotPerformAgain = new JCheckBox(SupportedPlatform.DO_NOT_PERFORM_AGAIN);
            this.doNotPerformAgain.addActionListener(this);
            checkboxPanel.add(this.doNotPerformAgain);
            checkboxPanel.add(Box.createHorizontalGlue());
            this.add(checkboxPanel);
            this.add(Box.createVerticalStrut(10));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.doNotPerformAgain) {
                String value;
                String string = value = this.doNotPerformAgain.isSelected() ? "true" : "false";
                if (this.settings != null) {
                    this.settings.setProperty(SupportedPlatform.CHEMAXON_DISABLE_JAVA_CHECKING_PROPERTY, value);
                } else {
                    try {
                        System.setProperty(SupportedPlatform.CHEMAXON_DISABLE_JAVA_CHECKING_PROPERTY, String.valueOf(this.doNotPerformAgain.isSelected()));
                    }
                    catch (SecurityException e) {
                        logger.throwing("SupportedPlatform", "MessageForm.actionPerformed", e);
                        logger.severe("Could not store 'Do not ask again' status in System property.");
                    }
                }
            }
        }
    }
}

