/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public class SymEigenValues {
    private static final int MAX_ITERATION_STEP_COUNT = 100;
    private int n;
    private double[] d;
    private double[] e;
    private double[][] a;
    private int[] sortedIndexArray;

    private void householder() {
        int l;
        int i;
        for (i = this.n - 1; i >= 1; --i) {
            l = i - 1;
            double scale = 0.0;
            double h = 0.0;
            if (l > 0) {
                int k;
                for (k = 0; k <= l; ++k) {
                    scale += Math.abs(this.a[i][k]);
                }
                if (scale == 0.0) {
                    this.e[i] = this.a[i][l];
                } else {
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = this.a[i];
                        int n = k;
                        dArray[n] = dArray[n] / scale;
                        h += this.a[i][k] * this.a[i][k];
                    }
                    double f = this.a[i][l];
                    double g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    this.e[i] = scale * g;
                    h -= f * g;
                    this.a[i][l] = f - g;
                    f = 0.0;
                    for (int j = 0; j <= l; ++j) {
                        int k2;
                        this.a[j][i] = this.a[i][j] / h;
                        g = 0.0;
                        for (k2 = 0; k2 <= j; ++k2) {
                            g += this.a[j][k2] * this.a[i][k2];
                        }
                        for (k2 = j + 1; k2 <= l; ++k2) {
                            g += this.a[k2][j] * this.a[i][k2];
                        }
                        this.e[j] = g / h;
                        f += this.e[j] * this.a[i][j];
                    }
                    double hh = f / (h + h);
                    for (int j = 0; j <= l; ++j) {
                        f = this.a[i][j];
                        this.e[j] = g = this.e[j] - hh * f;
                        for (int k3 = 0; k3 <= j; ++k3) {
                            double[] dArray = this.a[j];
                            int n = k3;
                            dArray[n] = dArray[n] - (f * this.e[k3] + g * this.a[i][k3]);
                        }
                    }
                }
            } else {
                this.e[i] = this.a[i][l];
            }
            this.d[i] = h;
        }
        this.e[0] = 0.0;
        this.d[0] = 0.0;
        for (i = 0; i < this.n; ++i) {
            int j;
            l = i - 1;
            if (this.d[i] != 0.0) {
                for (j = 0; j <= l; ++j) {
                    int k;
                    double g = 0.0;
                    for (k = 0; k <= l; ++k) {
                        g += this.a[i][k] * this.a[k][j];
                    }
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = this.a[k];
                        int n = j;
                        dArray[n] = dArray[n] - g * this.a[k][i];
                    }
                }
            }
            this.d[i] = this.a[i][i];
            this.a[i][i] = 1.0;
            for (j = 0; j <= l; ++j) {
                this.a[i][j] = 0.0;
                this.a[j][i] = 0.0;
            }
        }
    }

    private void tridiagonalQL() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        for (int l = 0; l < this.n; ++l) {
            int m;
            int iter = 0;
            do {
                for (m = l; m < this.n - 1; ++m) {
                    double dd = Math.abs(this.d[m]) + Math.abs(this.d[m + 1]);
                    if (Math.abs(this.e[m]) + dd == dd) break;
                }
                if (m == l) continue;
                if (iter++ == 100) {
                    throw new RuntimeException("Too many iterations in TQLI");
                }
                double g = (this.d[l + 1] - this.d[l]) / (2.0 * this.e[l]);
                double r = Math.sqrt(g * g + 1.0);
                g = this.d[m] - this.d[l] + this.e[l] / (g + (g >= 0.0 ? Math.abs(r) : -Math.abs(r)));
                double s = 1.0;
                double c = 1.0;
                double p = 0.0;
                for (int i = m - 1; i >= l; --i) {
                    double f = s * this.e[i];
                    double b = c * this.e[i];
                    if (Math.abs(f) >= Math.abs(g)) {
                        c = g / f;
                        r = Math.sqrt(c * c + 1.0);
                        this.e[i + 1] = f * r;
                        s = 1.0 / r;
                        c *= s;
                    } else {
                        s = f / g;
                        r = Math.sqrt(s * s + 1.0);
                        this.e[i + 1] = g * r;
                        c = 1.0 / r;
                        s *= c;
                    }
                    g = this.d[i + 1] - p;
                    r = (this.d[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    this.d[i + 1] = g + p;
                    g = c * r - b;
                    for (int k = 0; k < this.n; ++k) {
                        f = this.a[k][i + 1];
                        this.a[k][i + 1] = s * this.a[k][i] + c * f;
                        this.a[k][i] = c * this.a[k][i] - s * f;
                    }
                }
                int n = l;
                this.d[n] = this.d[n] - p;
                this.e[l] = g;
                this.e[m] = 0.0;
            } while (m != l);
        }
    }

    private void sort() {
        for (int i = 0; i < this.n - 1; ++i) {
            int minPos = i;
            double min = this.d[this.sortedIndexArray[minPos]];
            for (int j = minPos + 1; j < this.n; ++j) {
                if (!(this.d[this.sortedIndexArray[j]] < min)) continue;
                minPos = j;
                min = this.d[this.sortedIndexArray[minPos]];
            }
            if (minPos == i) continue;
            int swap = this.sortedIndexArray[minPos];
            this.sortedIndexArray[minPos] = this.sortedIndexArray[i];
            this.sortedIndexArray[i] = swap;
        }
    }

    public SymEigenValues(double[][] symMatr) throws RuntimeException {
        this.n = symMatr.length;
        this.alloc();
        this.init(symMatr);
        this.calc();
    }

    public SymEigenValues() {
        this.n = 0;
    }

    public void setSymMatr(double[][] symMatr) throws RuntimeException {
        this.n = symMatr.length;
        this.alloc();
        this.init(symMatr);
        this.calc();
    }

    private void calc() {
        this.householder();
        this.tridiagonalQL();
        this.sort();
    }

    private void alloc() {
        if (this.a == null || this.n > this.a.length) {
            this.a = new double[this.n][this.n];
            this.d = new double[this.n];
            this.e = new double[this.n];
            this.sortedIndexArray = new int[this.n];
        }
        for (int i = 0; i < this.n; ++i) {
            this.e[i] = 0.0;
            this.d[i] = 0.0;
            this.sortedIndexArray[i] = i;
        }
    }

    private void init(double[][] m) {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.a[i][j] = m[i][j];
            }
        }
    }

    public int size() {
        return this.n;
    }

    public double[] getEigenVector(int i) {
        double[] evect = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            evect[j] = this.a[j][this.sortedIndexArray[i]];
        }
        return evect;
    }

    public double getRealEigenvalue(int i) {
        return this.d[this.sortedIndexArray[i]];
    }

    public double[] getImaginaryEigenvalues() {
        return this.e;
    }
}

