/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.marvin;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.concurrent.InputProducer;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class MolInputProducer
implements InputProducer {
    private MolImporter[] importers = null;
    private int index = 0;
    private Molecule next = null;

    public MolInputProducer() throws ExecutionException {
        try {
            this.importers = new MolImporter[]{new MolImporter(System.in)};
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    public MolInputProducer(MolImporter importer) {
        this(new MolImporter[]{importer});
    }

    public MolInputProducer(MolImporter[] importers) {
        this.importers = importers;
    }

    @Override
    public boolean hasNext() throws InterruptedException, ExecutionException {
        this.setNext();
        return this.next != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getNext() throws InterruptedException, ExecutionException {
        try {
            this.setNext();
            Molecule molecule = this.next;
            return molecule;
        }
        finally {
            this.next = null;
        }
    }

    private void setNext() throws ExecutionException {
        try {
            while (this.next == null && this.index < this.importers.length) {
                this.next = this.read(this.importers[this.index]);
                if (this.next != null) continue;
                ++this.index;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    protected Molecule read(MolImporter importer) throws IOException {
        return importer.read();
    }

    public void close() throws ExecutionException {
        try {
            for (int i = 0; i < this.importers.length; ++i) {
                this.importers[i].close();
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }
}

