/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class WorkUnitData {
    public static final WorkUnitData VOID = new WorkUnitData(null);
    public static final Object POISONOUS_INPUT = "POISONOUS_INPUT";
    public static final Object UNKNOWN_INPUT = "UNKNOWN_INPUT";
    protected Object input = VOID;
    protected Object result = VOID;
    protected Throwable error;

    public WorkUnitData() {
    }

    public WorkUnitData(Object input) {
        this.input = input;
    }

    protected Object getInput() throws InterruptedException {
        return this.input;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isPoisoned() throws InterruptedException {
        return this.getInput() == POISONOUS_INPUT;
    }

    public boolean isInterrupted() {
        return this.getError() instanceof CancellationException;
    }

    public void setInterrupted() {
        this.setError(new CancellationException());
        Thread.currentThread().interrupt();
    }

    public void setError(Throwable error) {
        if (error == null) {
            throw new NullPointerException();
        }
        if (this.result != VOID) {
            throw new IllegalStateException("Result already set");
        }
        this.error = error;
    }

    public Object getResult() throws InterruptedException, ExecutionException {
        if (this.error == null) {
            if (this.result == VOID) {
                throw new IllegalStateException("Neither result, nor error");
            }
            return this.result;
        }
        throw new ExecutionException(this.error);
    }

    public void setResult(Object result) {
        if (this.result != VOID) {
            throw new IllegalStateException("Result already set");
        }
        if (this.error != null) {
            throw new IllegalStateException("Error already set to " + this.error);
        }
        this.result = result;
    }

    public void setInput(Object input) {
        if (this.input != VOID) {
            throw new IllegalStateException("Input already set");
        }
        this.input = input;
    }
}

