/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors;

import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.processors.InOutQueuedWorkerController;
import chemaxon.util.concurrent.processors.InOutQueuedWorkerFactory;
import chemaxon.util.concurrent.processors.WorkUnitData;
import chemaxon.util.concurrent.processors.WorkUnitDataIterator;
import chemaxon.util.concurrent.util.Timeout;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

class WorkUnitProcessorBase
extends WorkUnitDataIterator
implements ConcurrentProcessor {
    public static final long DEFAULT_CLEANUP_TIMEOUT = 60000L;
    public static final boolean workerWaitsForRoomInOutputQueue = true;
    private static final Logger logger = Logger.getLogger(WorkUnitProcessorBase.class.getName());
    private int customWorkerThreadCount;
    private InputProducer origInputProducer;
    protected InputProducer synchedInputProducer;
    protected InOutQueuedWorkerFactory workerFactory;
    private int maxOutputQueueSize;
    protected LinkedBlockingQueue<WorkUnitData> outputQueue;
    protected Future<String> workerControllerTask;
    public DebugStat stat = new DebugStat();

    public WorkUnitProcessorBase(InOutQueuedWorkerFactory workerFactory) {
        this.workerFactory = workerFactory;
    }

    @Override
    public void setWorkerThreadCount(int workerThreadCount) {
        this.customWorkerThreadCount = workerThreadCount;
    }

    @Override
    public void start() throws ExecutionException {
        this.wrapInputProducer();
        if (this.maxOutputQueueSize == 0) {
            this.maxOutputQueueSize = Runtime.getRuntime().availableProcessors() * 100;
        }
        this.outputQueue = new LinkedBlockingQueue(this.maxOutputQueueSize);
        this.workerFactory.setOutputQueue(this.outputQueue);
        InOutQueuedWorkerController bwc = new InOutQueuedWorkerController(this.customWorkerThreadCount, this.workerFactory, new Timeout(60000L));
        WorkUnitManager es = WorkUnitManager.getInstance();
        this.workerControllerTask = es.submit(bwc);
    }

    private void wrapInputProducer() {
        this.origInputProducer = this.workerFactory.getInputProducer();
        this.synchedInputProducer = new InputProducer(){

            @Override
            public synchronized Object getNext() throws InterruptedException, ExecutionException {
                return WorkUnitProcessorBase.this.origInputProducer.getNext();
            }

            @Override
            public synchronized boolean hasNext() throws InterruptedException, ExecutionException {
                boolean hasNext = WorkUnitProcessorBase.this.origInputProducer.hasNext();
                if (!hasNext) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("InputProducer proxy: Notifying all");
                    }
                    this.notifyAll();
                }
                return hasNext;
            }
        };
        this.workerFactory.setInputProducer(this.synchedInputProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WorkUnitData removeNext() throws InterruptedException, ExecutionException {
        WorkUnitData next = this.outputQueue.take();
        if (this.outputQueue.size() < this.maxOutputQueueSize * 4 / 5) {
            InputProducer inputProducer = this.synchedInputProducer;
            synchronized (inputProducer) {
                this.synchedInputProducer.notify();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            this.stat.stat();
        }
        return next;
    }

    @Override
    public void cleanup() throws InterruptedException, ExecutionException, TimeoutException {
        this.cleanup(Long.MAX_VALUE);
    }

    @Override
    public void cleanup(long joinTimeout) throws InterruptedException, ExecutionException, TimeoutException {
        Timeout timeout = new Timeout(joinTimeout);
        Throwable error = null;
        this.cancel();
        while (this.hasNext()) {
            try {
                this.getNext();
            }
            catch (Throwable throwable) {
                error = this.handleCleanupError(throwable);
            }
        }
        if (error == null) {
            try {
                this.workerControllerTask.get();
            }
            catch (Throwable throwable) {
                error = this.handleCleanupError(throwable);
            }
        }
        if (error != null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Error", error);
            }
            if (error instanceof InterruptedException) {
                throw (InterruptedException)error;
            }
            if (error instanceof ExecutionException) {
                throw (ExecutionException)error;
            }
            if (error instanceof TimeoutException) {
                throw (TimeoutException)error;
            }
            throw new ExecutionException(error);
        }
    }

    private Throwable handleCleanupError(Throwable throwable) {
        Throwable error = null;
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        } else if (!(throwable instanceof CancellationException)) {
            if (throwable instanceof ExecutionException) {
                if (!(throwable.getCause() instanceof CancellationException)) {
                    error = throwable;
                }
            } else {
                error = throwable;
            }
        }
        if (error != null && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Error while \"unblocking\" results", error);
        }
        return error;
    }

    @Override
    public void setMaxOutputQueueSize(int size) {
        if (this.maxOutputQueueSize != 0) {
            throw new IllegalStateException("maxOutputQueueSize already set to " + this.maxOutputQueueSize);
        }
        this.maxOutputQueueSize = size;
    }

    @Override
    public void cancel() {
        this.workerControllerTask.cancel(true);
    }

    @Override
    public boolean isCanceled() {
        return this.workerControllerTask.isCancelled();
    }

    private class DebugStat {
        private int sampleSize = 0;
        private int oqSizeMin = Integer.MAX_VALUE;
        private int oqSizeMax = 0;
        private int oqSizeTotal = 0;

        private DebugStat() {
        }

        public void stat() {
            ++this.sampleSize;
            int oqSize = WorkUnitProcessorBase.this.outputQueue.size();
            this.oqSizeMin = Math.min(this.oqSizeMin, oqSize);
            this.oqSizeMax = Math.max(this.oqSizeMax, oqSize);
            this.oqSizeTotal += oqSize;
            if (this.sampleSize % 10000 == 0) {
                logger.fine("oqSizeMin=" + this.oqSizeMin + ", oqSizeMax=" + this.oqSizeMax + ", oqSizeAvg=" + this.oqSizeTotal / this.sampleSize);
                this.sampleSize = 0;
                this.oqSizeMin = Integer.MAX_VALUE;
                this.oqSizeMax = 0;
                this.sampleSize = 0;
                this.oqSizeTotal = 0;
            }
        }
    }
}

