/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors;

import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.processors.WorkUnitData;
import chemaxon.util.concurrent.worker.Worker;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public abstract class WorkUnitWorker<V>
extends Worker<V> {
    private static final AtomicInteger workerCount = new AtomicInteger();
    protected WorkUnit workUnit;
    protected InputProducer inputProducer;
    protected BlockingQueue<WorkUnitData> outputQueue;
    private int processedCount;

    protected WorkUnitWorker(InputProducer inputProducer, WorkUnit workUnit, BlockingQueue<WorkUnitData> outputQueue) {
        this.workUnit = workUnit;
        this.inputProducer = inputProducer;
        this.outputQueue = outputQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V work() throws Exception {
        String origThreadName = Thread.currentThread().getName();
        try {
            int id = workerCount.getAndIncrement();
            Thread.currentThread().setName(this.getClass().getName() + "#" + id + "[" + this.workUnit.getClass().getName() + "]");
            V v = this.work0();
            return v;
        }
        finally {
            Thread.currentThread().setName(origThreadName);
        }
    }

    protected V work0() throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Starting work...");
        }
        while (!Thread.currentThread().isInterrupted() && !this.isCancelled()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Processed: " + this.processedCount);
            }
            if (!this.processInput()) {
                return null;
            }
            ++this.processedCount;
        }
        return null;
    }

    protected abstract boolean processInput() throws Exception;
}

