/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors.pooledwu;

import chemaxon.util.concurrent.processors.pooledwu.PooledWorkUnitProcessorBase;
import chemaxon.util.concurrent.util.LogUtil;
import chemaxon.util.concurrent.util.Timeout;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputOrderedPooledWorkUnitProcessor
extends PooledWorkUnitProcessorBase {
    public static Logger logger = LogUtil.getLogger(InputOrderedPooledWorkUnitProcessor.class);
    private BlockingQueue waitingFuturesQueue;
    private long totalQueueSize;
    private long maxQueueSize;
    private long sampleSize;

    public InputOrderedPooledWorkUnitProcessor() {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        this.waitingFuturesQueue = new LinkedBlockingQueue(cpuCount * 100);
    }

    @Override
    protected void submit(Callable callable) throws InterruptedException {
        this.waitingFuturesQueue.put(WorkUnitManager.getInstance().submit(callable));
    }

    @Override
    protected Object removeNext() throws InterruptedException, ExecutionException {
        Future future = (Future)this.waitingFuturesQueue.take();
        long queueSize = this.getQueueSize();
        this.maxQueueSize = Math.max(queueSize, this.maxQueueSize);
        this.totalQueueSize += queueSize++;
        ++this.sampleSize;
        return future.get();
    }

    @Override
    public void internalCleanup(Timeout timeout) throws InterruptedException, ExecutionException, TimeoutException {
        int cancelCount = 0;
        if (logger.isLoggable(Level.FINE)) {
            long avgQueueSize = this.totalQueueSize / this.sampleSize;
            logger.fine("waitingFuturesQueue: sampleSize=" + this.sampleSize + ", avgQueueSize=" + avgQueueSize + ", maxQueueSize=" + this.maxQueueSize);
        }
        for (Future future : this.waitingFuturesQueue) {
            if (!future.cancel(true)) continue;
            ++cancelCount;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(cancelCount + " task(s) cancelled");
        }
    }

    private int getQueueSize() {
        return this.waitingFuturesQueue.size();
    }

    @Override
    public void setMaxOutputQueueSize(int size) {
        throw new UnsupportedOperationException();
    }
}

