/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors.pooledwu;

import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.util.ConcurrentIteratorAdapter;
import chemaxon.util.concurrent.util.LogUtil;
import chemaxon.util.concurrent.util.Timeout;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitManager;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PooledWorkUnitProcessorBase
extends ConcurrentIteratorAdapter
implements Callable,
ConcurrentProcessor {
    private static final Logger logger = LogUtil.getLogger(PooledWorkUnitProcessorBase.class);
    private int customWorkerThreadCount;
    private AtomicReference myFuture = new AtomicReference();
    private InputProducer callableProducer;
    private Semaphore semaphore;

    public void setWorkUnitFactory(WorkUnitFactory workUnitFactory) {
        throw new UnsupportedOperationException();
    }

    public void setWorkUnitInputProducer(InputProducer inputProducer) {
        this.callableProducer = inputProducer;
    }

    @Override
    public void setWorkerThreadCount(int workerThreadCount) {
        this.customWorkerThreadCount = workerThreadCount;
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    protected ExecutorService getExecutorService(Callable callable) {
        return WorkUnitManager.getInstance();
    }

    protected abstract void submit(Callable var1) throws InterruptedException;

    public Object call() throws Exception {
        try {
            while (this.callableProducer.hasNext() && !Thread.currentThread().isInterrupted()) {
                Callable callable = (Callable)this.callableProducer.getNext();
                if (this.semaphore == null) {
                    int concurDegree = this.customWorkerThreadCount;
                    if (concurDegree == 0) {
                        concurDegree = WorkUnitManager.getConcurrDegree(callable);
                    }
                    this.semaphore = new Semaphore(concurDegree);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(callable.getClass().getName() + " will be throttled at concurrency degree " + concurDegree);
                    }
                }
                this.semaphore.acquire();
                this.submit(new SemaphoringCallable(callable));
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ParallelWorkProcessorBase reader thread: interrupt status on leaving: " + Thread.currentThread().isInterrupted());
            }
        }
        catch (InterruptedException interruptedException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cancelled -- no action", interruptedException);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Error while processing callable producer: ", e);
            }
            throw e;
        }
        finally {
            this.submit(this.createPoisonousCallable());
        }
        return null;
    }

    private Callable createPoisonousCallable() {
        return new Callable(){

            public Object call() throws Exception {
                return POISON;
            }
        };
    }

    @Override
    public void start() {
        WorkUnitManager es = WorkUnitManager.getInstance();
        this.myFuture.set(es.submit(this));
    }

    @Override
    public void cleanup() throws InterruptedException, ExecutionException, TimeoutException {
        this.cleanup(Long.MAX_VALUE);
    }

    @Override
    public void cleanup(long joinTimeout) throws InterruptedException, ExecutionException, TimeoutException {
        Throwable error;
        block12: {
            Timeout timeout = new Timeout(joinTimeout);
            error = null;
            try {
                Future f = (Future)this.myFuture.get();
                if (!f.cancel(true)) {
                    f.get(timeout.getRestTimeout(), TimeUnit.MILLISECONDS);
                }
            }
            catch (CancellationException cancellationException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Task cancelled - no action", cancellationException);
                }
            }
            catch (Throwable throwable) {
                error = throwable;
            }
            try {
                this.internalCleanup(timeout);
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(Level.SEVERE)) break block12;
                logger.log(Level.SEVERE, "error", throwable);
            }
        }
        if (error != null) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "error", error);
            }
            if (error instanceof InterruptedException) {
                throw (InterruptedException)error;
            }
            if (error instanceof ExecutionException) {
                throw (ExecutionException)error;
            }
            if (error instanceof TimeoutException) {
                throw (TimeoutException)error;
            }
            throw new RuntimeException(error);
        }
    }

    protected abstract void internalCleanup(Timeout var1) throws InterruptedException, ExecutionException, TimeoutException;

    private class SemaphoringCallable
    implements Callable {
        private Callable coreCallable;

        public SemaphoringCallable(Callable coreCallable) {
            this.coreCallable = coreCallable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            try {
                Object v = this.coreCallable.call();
                return v;
            }
            finally {
                PooledWorkUnitProcessorBase.this.semaphore.release();
            }
        }
    }
}

