/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors.pooledwu;

import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.pooledwu.PooledWorkUnitProcessorBase;
import chemaxon.util.concurrent.util.LogUtil;
import chemaxon.util.concurrent.util.Timeout;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnorderedPooledWorkUnitProcessor
extends PooledWorkUnitProcessorBase {
    Logger logger = LogUtil.getLogger(UnorderedPooledWorkUnitProcessor.class);
    private ExecutorCompletionService ecs;
    private ConcurrentLinkedQueue submittedList;

    @Override
    protected Object removeNext() throws InterruptedException, ExecutionException {
        Future future = this.ecs.take();
        Object obj = future.get();
        this.submittedList.remove(future);
        return obj;
    }

    @Override
    protected void submit(Callable callable) throws InterruptedException {
        if (this.ecs == null) {
            ExecutorService es = this.getExecutorService(callable);
            this.ecs = new ExecutorCompletionService(es);
        }
        Future future = this.ecs.submit(callable);
        this.submittedList.add(future);
    }

    @Override
    public void internalCleanup(Timeout timeout) throws InterruptedException, ExecutionException, TimeoutException {
        int cancelCount = 0;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("cancelTasks BEGIN");
        }
        for (Future future : this.submittedList) {
            if (!future.cancel(true)) continue;
            ++cancelCount;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("cancelTasks: " + cancelCount + " task(s) cancelled");
        }
    }

    @Override
    public void setWorkUnitFactory(WorkUnitFactory workUnitFactory) {
    }

    @Override
    public void setWorkUnitInputProducer(InputProducer inputProducer) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setMaxOutputQueueSize(int size) {
        throw new UnsupportedOperationException();
    }
}

