/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.processors.pooledwu.inputadapt;

import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.pooledwu.inputadapt.WorkUnitPool;
import chemaxon.util.concurrent.util.AbstractWorkUnit;
import chemaxon.util.concurrent.util.LogUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PoolingInpAcceptorWorkUnit
extends AbstractWorkUnit {
    private static final Logger logger = LogUtil.getLogger(PoolingInpAcceptorWorkUnit.class);
    private WorkUnitPool workUnitPool;
    private Class workUnitClass;

    public PoolingInpAcceptorWorkUnit(WorkUnitPool pool, Class workUnitClass) {
        if (pool == null) {
            throw new NullPointerException();
        }
        this.workUnitPool = pool;
        this.workUnitClass = workUnitClass;
    }

    @Override
    public Object process(Object input) throws Exception {
        try {
            WorkUnit wu = this.workUnitPool.get();
            wu.setInput(input);
            Object result = wu.call();
            this.workUnitPool.put(wu);
            return result;
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Error", throwable);
            throw new ExecutionException(throwable);
        }
    }

    private static class SimplePoolArrayIterator
    implements Iterator {
        private SimplePool[] buckets;
        private int currentBucketIdx;
        private Iterator currentBucketIterator;

        public SimplePoolArrayIterator(SimplePool[] sca) {
            this.buckets = sca;
        }

        @Override
        public boolean hasNext() {
            if (this.currentBucketIterator == null) {
                this.currentBucketIterator = this.buckets[this.currentBucketIdx].iterator();
            }
            if (!this.currentBucketIterator.hasNext()) {
                if (this.currentBucketIdx + 1 > this.buckets.length) {
                    return false;
                }
                ++this.currentBucketIdx;
                this.currentBucketIterator = this.buckets[this.currentBucketIdx].iterator();
                return this.hasNext();
            }
            return true;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.currentBucketIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class RingBucketPool
    implements WorkUnitPool {
        private final int bucketCount = 16;
        private SimplePool[] buckets = new SimplePool[16];
        private int count;

        public RingBucketPool() {
            for (int i = 0; i < 16; ++i) {
                this.buckets[i] = new SimplePool();
            }
        }

        private SimplePool getNextBucket() {
            int rndIdx = Math.abs(this.count++) % 16;
            return this.buckets[rndIdx];
        }

        public void cleanup() {
            for (int i = 0; i < 16; ++i) {
                this.buckets[i].cleanup();
            }
        }

        @Override
        public WorkUnit get() throws Exception {
            return this.getNextBucket().get();
        }

        @Override
        public void setWorkUnitFactory(WorkUnitFactory workUnitFactory) {
            for (int i = 0; i < 16; ++i) {
                this.buckets[i].setWorkUnitFactory(workUnitFactory);
            }
        }

        @Override
        public Iterator iterator() {
            return new SimplePoolArrayIterator(this.buckets);
        }

        @Override
        public void put(WorkUnit wu) throws Exception {
            int idxMinSize = 0;
            int minSize = Integer.MAX_VALUE;
            for (int i = 0; i < 16; ++i) {
                int size = this.buckets[i].size();
                if (size >= minSize) continue;
                minSize = size;
                idxMinSize = i;
            }
            this.buckets[idxMinSize].put(wu);
        }

        @Override
        public int size() {
            int size = 0;
            for (int i = 0; i < 16; ++i) {
                size += this.buckets[i].size();
            }
            return size;
        }
    }

    public static class SimplePool
    implements WorkUnitPool {
        private WorkUnitFactory workUnitFactory;
        private ConcurrentLinkedQueue pool = new ConcurrentLinkedQueue();
        private int createCount;

        public SimplePool() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.getClass().getName() + " instance is being created...");
            }
        }

        public void cleanup() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Simplepool.cleanup: createCount=" + this.createCount + ", pool.size()=" + this.pool.size());
            }
            this.pool.clear();
        }

        @Override
        public WorkUnit get() throws Exception {
            WorkUnit wu = null;
            wu = (WorkUnit)this.pool.poll();
            if (wu == null) {
                wu = this.workUnitFactory.createWorkUnit();
            }
            return wu;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            ConcurrentLinkedQueue concurrentLinkedQueue = this.pool;
            synchronized (concurrentLinkedQueue) {
                return this.pool.size();
            }
        }

        @Override
        public void put(WorkUnit wu) {
            this.pool.add(wu);
        }

        @Override
        public void setWorkUnitFactory(WorkUnitFactory workUnitFactory) {
            this.workUnitFactory = workUnitFactory;
        }

        @Override
        public Iterator iterator() {
            return this.pool.iterator();
        }
    }

    public static class Nopool
    implements WorkUnitPool {
        private WorkUnitFactory workUnitFactory;

        @Override
        public WorkUnit get() throws Exception {
            return this.workUnitFactory.createWorkUnit();
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWorkUnitFactory(WorkUnitFactory workUnitFactory) {
            this.workUnitFactory = workUnitFactory;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void put(WorkUnit wu) throws Exception {
        }
    }
}

