/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkerThreadBalancer {
    private static Logger logger = Logger.getLogger(WorkerThreadBalancer.class.getName());
    protected AtomicInteger activeThreads = new AtomicInteger();
    private int maxQueueLengthPerCpu;
    private int cpuCount;
    private Queue outputQueue;
    private final Lock suspensionLock = new ReentrantLock();
    private final Condition underWorked = this.suspensionLock.newCondition();

    public WorkerThreadBalancer(int maxQueueLengthPerCpu, int cpuCount, Queue outputQueue) {
        this.activeThreads.set(cpuCount);
        this.maxQueueLengthPerCpu = maxQueueLengthPerCpu;
        this.cpuCount = cpuCount;
        this.outputQueue = outputQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend() throws InterruptedException {
        this.suspensionLock.lock();
        try {
            int activeCount = this.activeThreads.decrementAndGet();
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("activeCount=" + activeCount + ", outputQueue.size()=" + this.outputQueue.size() + ": suspending");
                }
                while (activeCount * this.maxQueueLengthPerCpu / 2 > this.outputQueue.size() - this.cpuCount * this.maxQueueLengthPerCpu / 2) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("activeCount=" + activeCount + ", outputQueue.size()=" + this.outputQueue.size() + ": suspending");
                    }
                    activeCount = this.activeThreads.get();
                }
            }
            finally {
                this.activeThreads.getAndIncrement();
            }
        }
        finally {
            this.suspensionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() throws InterruptedException {
        this.suspensionLock.lock();
        try {
            int activeCount = this.activeThreads.get();
            if (activeCount * this.maxQueueLengthPerCpu / 2 - this.maxQueueLengthPerCpu / 5 > this.outputQueue.size() - this.cpuCount * this.maxQueueLengthPerCpu / 2) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("activeCount=" + activeCount + ", outputQueue.size()=" + this.outputQueue.size() + ": signaling");
                }
                this.underWorked.signal();
            }
        }
        finally {
            this.suspensionLock.unlock();
        }
    }

    public static void main(String[] args) throws Exception {
        Logger topLevelLogger = Logger.getLogger("chemaxon");
        topLevelLogger.setLevel(Level.FINE);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINE);
        topLevelLogger.addHandler(handler);
        TestQ testQ = new TestQ();
        WorkerThreadBalancer wtb = new WorkerThreadBalancer(100, 2, testQ);
        testQ.setSize(160);
        wtb.suspend();
        for (int size = 160; size < 200; ++size) {
            testQ.setSize(size);
            wtb.resume();
        }
    }

    private static class TestQ
    implements Queue {
        private int size;

        private TestQ() {
        }

        @Override
        public boolean add(Object arg0) {
            return false;
        }

        public Object element() {
            return null;
        }

        public boolean offer(Object arg0) {
            return false;
        }

        public Object peek() {
            return null;
        }

        public Object poll() {
            return null;
        }

        public Object remove() {
            return null;
        }

        @Override
        public boolean addAll(Collection c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection c) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator iterator() {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection c) {
            return false;
        }

        public void setSize(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return null;
        }
    }
}

