/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.worker;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Worker<V>
implements Runnable,
Future<V> {
    protected static final Logger logger = Logger.getLogger(Worker.class.getName());
    private BlockingQueue<Future<V>> completionQueue;
    private final FutureTask<V> task = new FutureTask<V>(new Callable<V>(){

        @Override
        public V call() throws Exception {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("About to start working...");
            }
            return Worker.this.work();
        }
    }){

        @Override
        protected void done() {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Done! About to join the completion queue...");
            }
            Worker.this.completionQueue.add(Worker.this);
        }
    };

    @Override
    public void run() {
        this.task.run();
    }

    protected abstract V work() throws Exception;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.task.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.task.get(timeout, unit);
    }

    public BlockingQueue<Future<V>> getCompletionQueue() {
        return this.completionQueue;
    }

    public void setCompletionQueue(BlockingQueue<Future<V>> completionQueue) {
        this.completionQueue = completionQueue;
    }
}

