/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.workunitmgmt;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Semaphore semaphore;

    public BlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
        this.semaphore = new Semaphore(maximumPoolSize, true);
    }

    public BlockingThreadPoolExecutor(int poolSize, ThreadFactory threadFactory) {
        this(poolSize, poolSize, 120L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory);
    }

    public BlockingThreadPoolExecutor(int corePoolSize, int maxPoolSize) {
        this(corePoolSize, maxPoolSize, 120L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), Executors.defaultThreadFactory());
    }

    public BlockingThreadPoolExecutor(int poolSize) {
        this(poolSize, poolSize, 120L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), Executors.defaultThreadFactory());
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.execute(command);
    }

    @Override
    protected void afterExecute(Runnable command, Throwable t) {
        this.semaphore.release();
    }
}

