/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.concurrent.workunitmgmt;

import chemaxon.util.concurrent.worker.Worker;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitConfig;
import chemaxon.util.concurrent.workunitmgmt.WorkUnitType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkUnitManager
implements ExecutorService {
    private static final Logger logger = Logger.getLogger(WorkUnitManager.class.getName());
    private static final WorkUnitManager instance;
    private ConcurrentMap<String, WorkUnitType> workUnitTypes = new ConcurrentHashMap<String, WorkUnitType>();
    private WorkUnitType defaultWorkUnitType;
    private ConcurrentMap<Class<?>, WorkUnitType> workUnitTypeAssignments = new ConcurrentHashMap();
    private boolean shutdown;

    private WorkUnitManager() {
    }

    private void addWorkUnitType(WorkUnitType wrapper) {
        this.workUnitTypes.putIfAbsent(wrapper.getName(), wrapper);
    }

    public void declareAsWorkUnitType(Class<?> clazz, String workUnitTypeName) {
        WorkUnitType workUnitClass = (WorkUnitType)this.workUnitTypes.get(workUnitTypeName);
        if (workUnitClass == null) {
            throw new IllegalArgumentException("Unknown work unit class: " + workUnitTypeName);
        }
        this.workUnitTypeAssignments.put(clazz, workUnitClass);
    }

    public void removeWorkUnitTypeDeclaration(Class<Callable<Object>> clazz) {
        this.workUnitTypeAssignments.remove(clazz);
    }

    private ExecutorService getService(Class<?> clazz) {
        WorkUnitType workUnitType = (WorkUnitType)this.workUnitTypeAssignments.get(clazz);
        if (workUnitType == null) {
            return this.defaultWorkUnitType.getExecutorService();
        }
        return workUnitType.getExecutorService();
    }

    public int getConcurrencyDegree(Callable<Object> callable) {
        int condeg = this.getWorkUnitType(callable).getConcurrencyDegree();
        if (condeg == -1) {
            return Runtime.getRuntime().availableProcessors();
        }
        return condeg;
    }

    protected WorkUnitType getWorkUnitType(Callable<Object> callable) {
        WorkUnitType workUnitType = (WorkUnitType)this.workUnitTypeAssignments.get(callable.getClass());
        if (workUnitType == null) {
            return this.defaultWorkUnitType;
        }
        return workUnitType;
    }

    @Override
    public void shutdown() {
        for (WorkUnitType workUnitType : this.workUnitTypes.values()) {
            workUnitType.getExecutorService().shutdown();
        }
    }

    public List shutdownNow() {
        for (WorkUnitType workUnitType : this.workUnitTypes.values()) {
            workUnitType.getExecutorService().shutdownNow();
        }
        return null;
    }

    private void reset() {
        this.shutdownNow();
        this.defaultWorkUnitType = null;
        this.workUnitTypes.clear();
        this.workUnitTypeAssignments.clear();
    }

    public static WorkUnitManager getInstance() {
        return instance;
    }

    public <R> Future<R> submit(Callable<R> callable) {
        ExecutorService es = instance.getService(callable.getClass());
        return es.submit(callable);
    }

    public static int getConcurrDegree(Callable<Object> callable) {
        return instance.getConcurrencyDegree(callable);
    }

    public static int getConcurrDegree(Worker callable) {
        return WorkUnitManager.instance.defaultWorkUnitType.getConcurrencyDegree();
    }

    public static void initExecutors(List<WorkUnitType> workUnitTypes) {
        instance.reset();
        if (workUnitTypes == null) {
            throw new NullPointerException();
        }
        for (WorkUnitType workUnitType : workUnitTypes) {
            if (workUnitType.getName().equalsIgnoreCase("default")) {
                WorkUnitManager.instance.defaultWorkUnitType = workUnitType;
            }
            instance.addWorkUnitType(workUnitType);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("initExecutors: instance.defaultWorkUnitType=" + WorkUnitManager.instance.defaultWorkUnitType);
        }
    }

    public static void initDefault() throws Exception {
        instance.reset();
        List<WorkUnitType> wuTypeList = WorkUnitManager.createDefaultWorkUnitTypeList();
        ConcurrentHashMap<String, WorkUnitConfig> wuTypeAssignemnts = WorkUnitConfig.getWorkUnitConfigs();
        if (wuTypeAssignemnts != null) {
            List<WorkUnitConfig> configedWuTypeList = WorkUnitManager.createConfiguredWorkUnitTypeList(wuTypeAssignemnts);
            WorkUnitManager.overrideDefaultWuTypeList(wuTypeList, configedWuTypeList);
        }
        WorkUnitManager.initExecutors(wuTypeList);
        if (wuTypeAssignemnts != null) {
            WorkUnitManager.declareConfiguredWorkUnitTypes(wuTypeList, wuTypeAssignemnts);
        }
    }

    private static void overrideDefaultWuTypeList(List<WorkUnitType> wuTypeList, List<WorkUnitConfig> configedWuTypeList) {
        for (WorkUnitConfig tpConfig : configedWuTypeList) {
            WorkUnitType wu = new WorkUnitType(tpConfig.getName(), tpConfig.getThreadCount(), WorkUnitManager.createDefaultExecutorService());
        }
    }

    private static List<WorkUnitType> createDefaultWorkUnitTypeList() {
        ArrayList<WorkUnitType> list = new ArrayList<WorkUnitType>();
        WorkUnitType wuType = new WorkUnitType("default", Runtime.getRuntime().availableProcessors(), WorkUnitManager.createDefaultExecutorService());
        list.add(wuType);
        return list;
    }

    private static ExecutorService createDefaultExecutorService() {
        final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        return (ThreadPoolExecutor)Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = null;
                t = logger.isLoggable(Level.FINE) ? new Thread(r){

                    @Override
                    public void interrupt() {
                        logger.log(Level.FINE, "Thread interrupted", new Exception());
                        super.interrupt();
                    }
                } : defaultThreadFactory.newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
    }

    private static List<WorkUnitConfig> createConfiguredWorkUnitTypeList(ConcurrentHashMap<String, WorkUnitConfig> wuTypeAssignments) {
        ArrayList<WorkUnitConfig> list = new ArrayList<WorkUnitConfig>();
        for (WorkUnitConfig tpcfg : wuTypeAssignments.values()) {
            list.add(tpcfg);
        }
        return list;
    }

    private static void declareConfiguredWorkUnitTypes(List<WorkUnitType> wuTypeList, ConcurrentHashMap<String, WorkUnitConfig> wuTypeAssignemnts) throws ClassNotFoundException {
        for (String className : wuTypeAssignemnts.keySet()) {
            String wuTypeName = null;
            WorkUnitConfig value = wuTypeAssignemnts.get(className);
            if (value instanceof WorkUnitConfig) {
                WorkUnitConfig threadPoolConfig = value;
                wuTypeName = threadPoolConfig.getName();
            } else {
                wuTypeName = (String)((Object)value);
            }
            try {
                instance.declareAsWorkUnitType(Class.forName(className), wuTypeName);
            }
            catch (ClassNotFoundException e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Problem loading class " + className, e);
            }
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public List invokeAll(Collection tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> submit(Runnable task) {
        ExecutorService es = instance.getService(task.getClass());
        return es.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable command) {
        ExecutorService es = instance.getService(command.getClass());
        es.execute(command);
    }

    static {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting static initialization block...");
        }
        try {
            instance = new WorkUnitManager();
            WorkUnitManager.initDefault();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

