/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.util.expression.AtomExpression;
import chemaxon.util.expression.StaticContext;
import chemaxon.util.expression.function.SearchMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class AtomConditionExpression
extends AtomExpression {
    public AtomConditionExpression() {
    }

    public AtomConditionExpression(StaticContext staticContext) {
        super(staticContext);
    }

    @Override
    public String getResultType() {
        return "Boolean";
    }

    public void compile(Properties exprtable, String logic, String mapname) throws ParseException {
        ArrayList searchers = new ArrayList();
        ArrayList molconsts = new ArrayList();
        StringBuffer searcherBuffer = new StringBuffer();
        int base = 0;
        Enumeration<?> keys = exprtable.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String expr = exprtable.getProperty(key);
            this.setAtomIndexName(mapname + "(" + key + ")");
            molconsts.clear();
            String searcherString = this.createSearcherString(expr, searchers, molconsts);
            searcherBuffer.append(searcherString);
            String selectorString = this.createSelectorString(expr, molconsts, base += molconsts.size());
            exprtable.put(key, selectorString);
        }
        this.searcherExpression = searcherBuffer.length() > 0 ? new String(searcherBuffer) : "1.0";
        this.selectorExpression = !exprtable.isEmpty() ? AtomConditionExpression.createCondString(exprtable, logic) : "1.0";
        this.searcherJEP.setStaticContext(this.staticContext);
        this.selectorJEP.setStaticContext(this.staticContext);
        this.searcherJEP.compile(this.searcherExpression);
    }

    @Override
    public Object evaluate() throws ParseException {
        this.initEvaluation();
        this.searcherJEP.setDynamicContext(this.dynamicContext);
        this.searcherJEP.evaluate_boolean();
        if (this.dynamicContext == null) {
            throw new ParseException("no dynamic context given");
        }
        this.selectorJEP.setDynamicContext(this.dynamicContext);
        return this.selectorJEP.evaluate();
    }

    @Override
    public boolean evaluate_boolean() throws ParseException {
        return this.evaluate() != PostfixMathCommandI.FALSE;
    }

    public void setMapFunction(SearchMap map) throws ParseException {
        this.selectorJEP.addFunction("map", map);
    }

    public void compileSelector() throws ParseException {
        this.selectorJEP.compile(this.selectorExpression);
    }
}

