/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.expression.ChemExpression;
import chemaxon.util.expression.ChemJEP;
import chemaxon.util.expression.ExpressionSearch;
import chemaxon.util.expression.StaticContext;
import chemaxon.util.expression.function.BitSetUtil;
import chemaxon.util.expression.function.FullSearch;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class AtomExpression
extends ChemExpression {
    protected String searcherExpression = null;
    protected String selectorExpression = null;
    protected ChemJEP searcherJEP = new ChemJEP();
    protected ChemJEP selectorJEP = new ChemJEP();
    private String atomIndexName = "ATOMINDEX";

    public AtomExpression() {
    }

    public AtomExpression(StaticContext staticContext) {
        super(staticContext);
    }

    protected final void setAtomIndexName(String atomIndexName) {
        this.atomIndexName = atomIndexName;
    }

    @Override
    public abstract String getResultType();

    @Override
    public void compile(String expression) throws ParseException {
        ArrayList molconsts;
        ArrayList searchers;
        String searcherString = this.createSearcherString(expression = AtomExpression.removeWhitespace(expression), searchers = new ArrayList(), molconsts = new ArrayList());
        this.searcherExpression = searcherString.length() > 0 ? searcherString : "1.0";
        String selectorString = this.createSelectorString(expression, molconsts);
        selectorString = this.addSelectorContainments(selectorString);
        this.selectorExpression = selectorString.length() > 0 ? selectorString : "1.0";
        this.searcherJEP.setStaticContext(this.staticContext);
        this.selectorJEP.setStaticContext(this.staticContext);
        this.searcherJEP.compile(this.searcherExpression);
        this.selectorJEP.compile(this.selectorExpression);
    }

    protected String createSearcherString(String expression, ArrayList searchers, ArrayList molconsts) throws ParseException {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(expression, " \t\r\n()!&|:,");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!this.staticContext.isConstantName(token)) continue;
            String sid = "SEARCH" + searchers.size();
            FullSearch search = new FullSearch();
            search.setSearcher(new ExpressionSearch(this.staticContext));
            this.searcherJEP.addChemFunction(sid, search);
            this.selectorJEP.addFunction(sid, search);
            searchers.add(search);
            if (searchers.size() > 1) {
                buffer.append("&&");
            }
            buffer.append(sid + "(" + token + ")");
            molconsts.add(token);
        }
        return new String(buffer);
    }

    protected String createSelectorString(String expression, ArrayList molconsts) throws ParseException {
        return this.createSelectorString(expression, molconsts, 0);
    }

    protected String createSelectorString(String expression, ArrayList molconsts, int base) throws ParseException {
        StringBuffer buffer = new StringBuffer(expression);
        if (this.staticContext != null) {
            String[] names = this.staticContext.getSortedPluginNames();
            AtomExpression.transformPluginReferences(buffer, names, this.atomIndexName);
            names = this.staticContext.getMajorMsFunctionNames();
            AtomExpression.transformFunctionReferences(buffer, names, this.atomIndexName);
            expression = new String(buffer);
        }
        buffer = new StringBuffer();
        int start = 0;
        int end = 0;
        char c = ' ';
        int len = expression.length();
        int n = molconsts.size();
        for (int i = 0; i < n; ++i) {
            String molconst = (String)molconsts.get(i);
            end = expression.indexOf(molconst, start);
            buffer.append(expression.substring(start, end));
            buffer.append("SEARCH" + (base + i) + "(" + this.atomIndexName);
            if ((end += molconst.length()) == len) {
                buffer.append(")");
                break;
            }
            c = expression.charAt(end);
            if (c == ':') {
                buffer.append(",");
                start = ++end;
                if (end == len) {
                    throw new ParseException("Unexpected end of expression after ':'");
                }
                c = expression.charAt(end);
                while (c == ',' || Character.isDigit(c)) {
                    buffer.append(c);
                    if (++end >= len) break;
                    c = expression.charAt(end);
                }
            }
            buffer.append(")");
            start = end;
        }
        buffer.append(expression.substring(end, len));
        return new String(buffer);
    }

    protected String addSelectorContainments(String expression) throws ParseException {
        this.selectorJEP.addFunction("CONTAINS", new BitSetUtil());
        StringBuffer buffer = new StringBuffer(expression);
        int i = 0;
        int c = 32;
        while (true) {
            try {
                c = buffer.charAt(i);
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            if (c == 123) {
                buffer.replace(i, i + 1, "CONTAINS(");
                try {
                    while (buffer.charAt(i) != '}') {
                        ++i;
                    }
                    buffer.replace(i, i + 1, "," + this.atomIndexName + ")");
                    i += 10;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ParseException("Unmatched '{'");
                }
            }
            ++i;
        }
        return new String(buffer);
    }

    @Override
    public abstract Object evaluate() throws ParseException;

    @Override
    public abstract boolean evaluate_boolean() throws ParseException;
}

