/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.struc.Molecule;
import chemaxon.util.SearchAttributes;
import chemaxon.util.expression.ChemExpression;
import chemaxon.util.expression.DynamicContext;
import chemaxon.util.expression.StaticContext;
import chemaxon.util.expression.function.SearchMap;

public class ExpressionSearch
extends MolSearch {
    private ChemExpression expression = null;
    private StaticContext staticContext = null;
    private SearchMap map = new SearchMap();

    public ExpressionSearch() {
        this(null, null);
    }

    public ExpressionSearch(StaticContext staticContext) {
        this(null, staticContext);
    }

    public ExpressionSearch(ChemExpression expression) {
        this(expression, null);
    }

    public ExpressionSearch(ChemExpression expression, StaticContext staticContext) {
        this.expression = expression;
        this.staticContext = staticContext;
        this.setSearchAttributes();
    }

    public void setExpression(ChemExpression expression) {
        this.expression = expression;
    }

    public ChemExpression getExpression() {
        return this.expression;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    private boolean isConstant(Object o) {
        return this.staticContext != null ? this.staticContext.isConstant(o) : false;
    }

    private void setInputMolecule(Molecule mol) {
        if (this.expression == null) {
            return;
        }
        DynamicContext context = this.expression.getDynamicContext();
        if (context == null) {
            context = new DynamicContext();
            this.expression.setDynamicContext(context);
        }
        context.setInputMolecule(mol);
    }

    public SearchMap getMap() {
        return this.map;
    }

    public void setSearchAttributes() {
        if (this.staticContext != null) {
            this.setSearchAttributes(this.staticContext.getSearchAttributes());
        }
    }

    public void setSearchAttributes(SearchAttributes attributes) {
        if (attributes != null) {
            this.searchOptions.setStereoSearchType(attributes.isStereoSearch() ? 0 : 1);
            this.searchOptions.setDoubleBondStereoMatchingMode(attributes.getDoubleBondStereoMatchingMode());
            this.searchOptions.setSubgraphSearch(attributes.isSubgraphSearch());
            boolean exact = attributes.isExactAtomMatching();
            if (exact) {
                this.searchOptions.setRadicalMatching(1);
                this.searchOptions.setChargeMatching(1);
                this.searchOptions.setIsotopeMatching(1);
            } else {
                this.searchOptions.setRadicalMatching(0);
                this.searchOptions.setChargeMatching(0);
                this.searchOptions.setIsotopeMatching(0);
            }
            this.searchOptions.setExactQueryAtomMatching(exact);
            this.searchOptions.setStereoSearchType(attributes.isExactStereoMatching() ? 2 : (this.searchOptions.getStereoSearchType() == 2 ? 0 : this.searchOptions.getStereoSearchType()));
            this.searchOptions.setOrderSensitiveSearch(attributes.isOrderSensitiveSearch());
        }
    }

    @Override
    public void setTarget(Molecule target) {
        if (this.getTarget() != target || !this.isConstant(target)) {
            super.setTarget(target);
            this.setInputMolecule(target);
        }
    }

    @Override
    public void setQuery(Molecule query) {
        if (this.getQuery() != query || !this.isConstant(query)) {
            super.setQuery(query);
            this.map.setQuery(query);
        }
    }

    @Override
    public SearchHit findFirstHit() throws SearchException {
        SearchHit hit = super.findFirstHit();
        if (this.expression == null || hit == null) {
            return hit;
        }
        this.map.setHit(hit.getSingleHit());
        try {
            if (this.expression.evaluate_boolean()) {
                return hit;
            }
        }
        catch (ParseException e) {
            throw new SearchException(e.getMessage());
        }
        return this.findNextHit();
    }

    @Override
    public SearchHit findNextHit() throws SearchException {
        SearchHit hit = null;
        try {
            do {
                hit = super.findNextHit();
                if (this.expression == null || hit == null) {
                    return hit;
                }
                this.map.setHit(hit.getSingleHit());
            } while (hit != null && !this.expression.evaluate_boolean());
        }
        catch (ParseException e) {
            throw new SearchException(e.getMessage());
        }
        return hit;
    }

    @Override
    public SearchHit[] findAllHits() throws SearchException {
        SearchHit[] hits = super.findAllHits();
        Object singleHits = null;
        if (hits != null) {
            singleHits = new int[hits.length][];
            for (int i = 0; i < hits.length; ++i) {
                singleHits[i] = hits[i].getSingleHit();
            }
        }
        this.map.setHits((int[][])singleHits);
        return hits;
    }
}

