/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.util.expression.ChemExpression;
import chemaxon.util.expression.ChemJEP;
import chemaxon.util.expression.DynamicContext;
import chemaxon.util.expression.ExpressionSearch;
import chemaxon.util.expression.StaticContext;
import chemaxon.util.expression.function.Search;

public class MolConditionExpression
extends ChemExpression {
    private String expression = null;
    private ChemJEP jep = new ChemJEP();

    public MolConditionExpression() {
    }

    public MolConditionExpression(StaticContext staticContext) {
        super(staticContext);
    }

    @Override
    public String getResultType() {
        return "Boolean";
    }

    @Override
    public void compile(String expression) throws ParseException {
        expression = MolConditionExpression.removeWhitespace(expression);
        String searchexpr = null;
        StringBuffer buffer = new StringBuffer(expression);
        int start = 0;
        int end = 0;
        int s = 0;
        int b = 0;
        int c = 32;
        int k = 0;
        int i = 0;
        while ((start = MolConditionExpression.indexOf(buffer, "search(", start)) != -1) {
            String sid = "SEARCH" + i++;
            Search search = new Search();
            this.jep.addChemFunction(sid, search);
            buffer.replace(start, start + 6, sid);
            k = start + sid.length() + 1;
            b = 1;
            s = -1;
            while (b > 0) {
                try {
                    c = buffer.charAt(k++);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ParseException("malformed expression: " + buffer);
                }
                if (c == 40) {
                    ++b;
                    continue;
                }
                if (c == 41) {
                    --b;
                    continue;
                }
                if (c != 58 || b != 1) continue;
                s = k - 1;
            }
            end = k - 1;
            if (s != -1) {
                searchexpr = buffer.substring(s + 1, end);
                this.createSubExpression(search, searchexpr);
                buffer.delete(s, end);
                end = s;
            } else {
                search.setSearcher(new ExpressionSearch());
            }
            start = end;
        }
        if (this.staticContext != null) {
            String[] names = this.staticContext.getSortedPluginNames();
            MolConditionExpression.transformPluginReferences(buffer, names);
        }
        this.expression = new String(buffer);
        this.jep.setStaticContext(this.staticContext);
        this.jep.compile(this.expression);
    }

    private void createSubExpression(Search search, String searchexpr) throws ParseException {
        if (searchexpr.length() == 0) {
            searchexpr = "1";
        }
        MolConditionExpression subExpression = new MolConditionExpression(this.staticContext);
        subExpression.setDynamicContext(new DynamicContext());
        subExpression.setTop(false);
        subExpression.jep.addFunction("map", search);
        subExpression.compile(searchexpr);
        search.setSearcher(new ExpressionSearch(subExpression, this.staticContext));
    }

    @Override
    public Object evaluate() throws ParseException {
        this.initEvaluation();
        this.jep.setDynamicContext(this.dynamicContext);
        return this.jep.evaluate();
    }

    @Override
    public boolean evaluate_boolean() throws ParseException {
        this.initEvaluation();
        this.jep.setDynamicContext(this.dynamicContext);
        return this.jep.evaluate_boolean();
    }
}

