/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.expression.function.MajorMsFunction;
import java.util.Properties;
import java.util.Stack;

public class AtomProperties
extends MajorMsFunction {
    public static final Double NAN = new Double(Double.NaN);
    public static final String CHARGE = "charge";
    public static final String HCOUNT = "hcount";
    public static final String CONNECTIONS = "connections";
    public static final String VALENCE = "valence";
    public static final String ATNO = "atno";
    public static final String MAP = "map";
    public static final String AROM = "arom";
    public static final String[] PROPS = new String[]{"charge", "hcount", "connections", "valence", "atno", "map", "arom"};
    private String property = null;

    @Override
    public void setParameters(Properties params) throws ParseException {
        super.setParameters(params);
        this.property = params.getProperty("property");
        if (this.property != null && !this.checkProperty(this.property)) {
            throw new ParseException("Atomic property not implemented: " + this.property);
        }
    }

    public void setProperty(String prop) throws ParseException {
        if (!this.checkProperty(prop)) {
            throw new ParseException("Atomic property not implemented: " + prop);
        }
        this.property = prop;
    }

    private boolean checkProperty(String prop) {
        for (int i = 0; i < PROPS.length; ++i) {
            if (!PROPS[i].equalsIgnoreCase(prop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run(Stack s) throws ParseException {
        Molecule mol = this.getInputMolecule();
        String prop = this.property;
        int index = -1;
        MolAtom atom = null;
        boolean valid = true;
        double pH = this.getOriginalpH();
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (p == null) {
                valid = false;
                continue;
            }
            if (p instanceof String) {
                if (this.checkProperty((String)p)) {
                    prop = (String)p;
                    continue;
                }
                try {
                    pH = Double.parseDouble((String)p);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Atomic property not implemented: " + p);
                }
            }
            if (p instanceof Number) {
                try {
                    index = ((Number)p).intValue();
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ParseException("not an integer: " + p);
                }
            }
            if (p instanceof Molecule) {
                mol = (Molecule)p;
                continue;
            }
            if (p instanceof MolAtom) {
                atom = (MolAtom)p;
                continue;
            }
            throw new ParseException("Illegal argument: " + p);
        }
        if (!valid) {
            s.push(NAN);
            return;
        }
        this.setpH(pH);
        try {
            mol = this.calcMajorMs(mol);
        }
        catch (PluginException e) {
            throw new ParseException(e);
        }
        if (atom == null) {
            if ((index = this.getAtomIndex(index)) == -1) {
                s.push(NAN);
                return;
            }
            atom = mol.getAtom(index);
        }
        Double result = null;
        if (CHARGE.equalsIgnoreCase(prop)) {
            result = new Double(atom.getCharge());
        } else if (HCOUNT.equalsIgnoreCase(prop)) {
            result = new Double(atom.getExplicitHcount() + atom.getImplicitHcount());
        } else if (CONNECTIONS.equalsIgnoreCase(prop)) {
            result = new Double(atom.getBondCount() + atom.getImplicitHcount());
        } else if (VALENCE.equalsIgnoreCase(prop)) {
            result = new Double(atom.getValence());
        } else if (ATNO.equalsIgnoreCase(prop)) {
            result = new Double(atom.getAtno());
        } else if (MAP.equalsIgnoreCase(prop)) {
            result = new Double(atom.getAtomMap());
        } else if (AROM.equalsIgnoreCase(prop)) {
            result = atom.hasAromaticBond() ? TRUE : FALSE;
        } else {
            throw new ParseException("Atomic property not implemented: " + prop);
        }
        s.push(result);
    }
}

