/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import java.util.BitSet;
import java.util.Stack;

public class BitSetUtil
extends PostfixMathCommand {
    public BitSetUtil() {
        this.numberOfParameters = -1;
        this.curNumberOfParameters = -1;
    }

    @Override
    public void run(Stack s) throws ParseException {
        if (this.curNumberOfParameters != 2) {
            throw new ParseException("illegal number of parameters: " + this.curNumberOfParameters);
        }
        Object p = s.pop();
        if (!(p instanceof Number)) {
            throw new ParseException("illegal parameter type: " + p + " - " + p.getClass() + " - Number expected");
        }
        int index = ((Number)p).intValue();
        p = s.pop();
        if (!(p instanceof BitSet)) {
            throw new ParseException("illegal parameter type: " + p + " - " + p.getClass() + " - BitSet expected");
        }
        BitSet bitset = (BitSet)p;
        boolean result = this.contains(bitset, index);
        s.push(result ? TRUE : FALSE);
    }

    public boolean contains(BitSet bitset, int index) {
        return bitset.get(index);
    }
}

