/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.util.expression.function.SearchFunction;
import java.util.Stack;

public class FullSearch
extends SearchFunction {
    @Override
    public void run(Stack s) throws ParseException {
        if (this.curNumberOfParameters <= 0) {
            throw new ParseException("illegal number of parameters: " + this.curNumberOfParameters);
        }
        Object p = s.pop();
        if (p instanceof Number) {
            boolean result = false;
            switch (this.curNumberOfParameters) {
                case 1: {
                    int index = ((Number)p).intValue();
                    result = this.getSearchMap().contains(index);
                    break;
                }
                case 2: {
                    int map = ((Number)p).intValue();
                    p = s.pop();
                    if (!(p instanceof Number)) {
                        throw new ParseException("Number required instead of: " + p + p.getClass());
                    }
                    int index = ((Number)p).intValue();
                    result = this.getSearchMap().contains(index, map);
                    break;
                }
                default: {
                    int n = this.curNumberOfParameters - 1;
                    int[] maps = new int[n];
                    do {
                        maps[--n] = ((Number)p).intValue();
                        p = s.pop();
                        if (p instanceof Number) continue;
                        throw new ParseException("Number required instead of: " + p + p.getClass());
                    } while (n > 0);
                    int index = ((Number)p).intValue();
                    result = this.getSearchMap().contains(index, maps);
                    break;
                }
            }
            s.push(result ? TRUE : FALSE);
        } else {
            if (!(p instanceof Molecule)) {
                throw new ParseException("illegal parameter type: " + p + " - " + p.getClass());
            }
            Molecule query = (Molecule)p;
            Molecule target = null;
            if (this.curNumberOfParameters == 2) {
                p = s.pop();
                if (!(p instanceof Molecule)) {
                    throw new ParseException("illegal parameter type: " + p + " - " + p.getClass());
                }
                target = (Molecule)p;
            } else {
                target = this.getInputMolecule();
            }
            try {
                this.findAll(target, query);
                s.push(TRUE);
            }
            catch (SearchException e) {
                throw new ParseException(e);
            }
        }
    }
}

