/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.expression.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.util.expression.function.ChemFunction;
import java.util.Stack;

public class MolUtil
extends ChemFunction {
    public static final String ATOMCOUNT = "atomcount";
    public static final String BONDCOUNT = "bondcount";

    public MolUtil() {
        super(-1);
    }

    @Override
    public void run(Stack s) throws ParseException {
        String type = null;
        Molecule imol = this.getInputMolecule();
        for (int i = 0; i < this.curNumberOfParameters; ++i) {
            Object p = s.pop();
            if (p instanceof Molecule) {
                imol = (Molecule)p;
                continue;
            }
            if (p instanceof String) {
                type = (String)p;
                continue;
            }
            throw new ParseException("invalid plugin parameter type: " + p + " - " + p.getClass());
        }
        if (type == null) {
            throw new ParseException("no data type given");
        }
        Object result = this.getMolResult(type, imol);
        s.push(result);
    }

    public Object getMolResult(String type, Molecule imol) throws ParseException {
        if (type.equals(ATOMCOUNT)) {
            return new Integer(imol.getAtomCount());
        }
        if (type.equals(BONDCOUNT)) {
            return new Integer(imol.getBondCount());
        }
        throw new ParseException("invalid data type: " + type);
    }
}

