/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.hitfinder;

import chemaxon.util.BlockingIntArrayQueue;
import chemaxon.util.concurrent.worker.Worker;
import chemaxon.util.hitfinder.HitFinder;
import chemaxon.util.hitfinder.HitFinderInput;
import chemaxon.util.hitfinder.HitFinderInputProducer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HitFinderWorker<I>
extends Worker<Object> {
    private static final Logger logger = Logger.getLogger(HitFinderWorker.class.getName());
    private static final Logger statLogger = Logger.getLogger(HitFinderWorker.class.getName() + "-stat");
    private static final Level statLoggerLevel = Level.FINER;
    private HitFinderInputProducer<I> inputProducer;
    private HitFinder<I> hitFinder;
    private BlockingIntArrayQueue hitArray;
    private long processedCount;
    private long hitCount;
    private Stats stats = new Stats();

    public HitFinderWorker(HitFinderInputProducer<I> inputProducer, HitFinder<I> hitFinder, BlockingIntArrayQueue hitArray) {
        this.inputProducer = inputProducer;
        this.hitFinder = hitFinder;
        this.hitArray = hitArray;
    }

    @Override
    protected Object work() throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Started");
        }
        HitFinderInput<I> input = this.getNextInput();
        while (input != null && !this.isCancelled()) {
            if (this.isHit(input)) {
                this.hitArray.add(input.cdId);
                ++this.hitCount;
            }
            ++this.processedCount;
            input = this.getNextInput();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Finished (processedCount=" + this.processedCount + ", hitCount=" + this.hitCount + ")");
        }
        if (statLogger.isLoggable(statLoggerLevel)) {
            logger.log(statLoggerLevel, this.stats.toString());
        }
        return null;
    }

    private HitFinderInput<I> getNextInput() throws Exception {
        if (statLogger.isLoggable(statLoggerLevel)) {
            this.stats.getInput.start();
        }
        HitFinderInput<I> input = this.inputProducer.getNextInput();
        if (statLogger.isLoggable(statLoggerLevel)) {
            if (input == null) {
                this.stats.getInput.stop(-1);
            } else {
                this.stats.getInput.stop(input.cdId);
            }
        }
        return input;
    }

    private boolean isHit(HitFinderInput<I> input) throws Exception {
        if (statLogger.isLoggable(statLoggerLevel)) {
            this.stats.hitFinder.start();
        }
        boolean isHit = this.hitFinder.yieldsHit(input.target);
        if (statLogger.isLoggable(statLoggerLevel)) {
            this.stats.hitFinder.stop(input.cdId);
        }
        return isHit;
    }

    private static class Timer {
        long start;

        private Timer() {
        }

        public void start() {
            this.start = System.currentTimeMillis();
        }

        public long stop() {
            long end = System.currentTimeMillis();
            return end - this.start;
        }
    }

    private static class MinMaxMonitor {
        private int minId;
        private long min = Long.MAX_VALUE;
        private int maxId;
        private long max;
        private Timer t = new Timer();

        private MinMaxMonitor() {
        }

        void start() {
            this.t.start();
        }

        void stop(int id) {
            long time = this.t.stop();
            if (time < this.min) {
                this.min = time;
                this.minId = id;
            }
            if (time > this.max) {
                this.max = time;
                this.maxId = id;
            }
        }

        public String toString() {
            return "min=" + this.min + " @" + this.minId + ", max=" + this.max + " @" + this.maxId;
        }
    }

    private static class Stats {
        private MinMaxMonitor getInput = new MinMaxMonitor();
        private MinMaxMonitor hitFinder = new MinMaxMonitor();

        private Stats() {
        }

        public String toString() {
            return "getInput=[" + this.getInput + "], hitFinder=[" + this.hitFinder + "]";
        }
    }
}

