/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.iterator;

import chemaxon.struc.Molecule;
import chemaxon.util.MolFilter;
import chemaxon.util.iterator.MoleculeIterator;

public class FilteredMoleculeIterator
implements MoleculeIterator {
    private MoleculeIterator iterator = null;
    private MolFilter filter = null;
    private Molecule next = null;

    public FilteredMoleculeIterator(MoleculeIterator iterator, MolFilter filter) {
        this.iterator = iterator;
        this.filter = filter != null ? filter : new MolFilter(){

            @Override
            public boolean accept(Molecule mol) {
                return true;
            }
        };
        this.init();
    }

    private void init() {
        this.next();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Molecule next() {
        Molecule ret = this.next;
        if (this.iterator != null && !this.iterator.hasNext()) {
            this.next = null;
        }
        while (this.iterator != null && this.iterator.hasNext() && !this.filter.accept(this.next = this.iterator.next())) {
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double estimateProgress() {
        return this.iterator.estimateProgress();
    }

    @Override
    public Throwable getThrowable() {
        return this.iterator.getThrowable();
    }
}

