/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.iterator;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorFactory {
    public static final int INCLUDE_ALL_BONDS = 0;
    public static final int SKIP_COORDINATE_BONDS = 1;
    public static final int SKIP_COVALENT_BONDS = 2;
    public static final int REPLACE_COORDINATE_BONDS = 4;
    public static final int INCLUDE_ALL_ATOMS = 0;
    public static final int SKIP_EXPLICIT_H = 1;
    public static final int SKIP_MULTICENTER = 2;
    public static final int SKIP_LONE_PAIR = 4;
    public static final int SKIP_PSEUDO_ATOM = 8;
    public static final int INCLUDE_CHEMICAL_ATOMS = 14;
    public static final int INCLUDE_CHEMICAL_ATOMS_ONLY = 14;
    private int bondRelatedBehavior = 0;
    private int atomRelatedBehavior = 0;
    private Molecule molecule = null;
    private boolean skip_multicenter = false;
    private boolean skip_lone_pair = false;
    private boolean skip_explicit_h = false;
    private boolean skip_pseudo_atom = false;
    private boolean skip_coordinate_bond = false;
    private boolean skip_covalent_bond = false;
    private boolean replace_bonds_to_multicenter_with_secondary = false;

    public IteratorFactory(Molecule mol, int atomRelatedBehavior, int bondRelatedBehavior) {
        this.molecule = mol;
        this.bondRelatedBehavior = bondRelatedBehavior;
        this.atomRelatedBehavior = atomRelatedBehavior;
        this.skip_multicenter = (this.atomRelatedBehavior & 2) != 0;
        this.skip_lone_pair = (this.atomRelatedBehavior & 4) != 0;
        this.skip_explicit_h = (this.atomRelatedBehavior & 1) != 0;
        this.skip_pseudo_atom = (this.atomRelatedBehavior & 8) != 0;
        this.skip_coordinate_bond = (this.bondRelatedBehavior & 1) != 0;
        this.skip_covalent_bond = (this.bondRelatedBehavior & 2) != 0;
        this.replace_bonds_to_multicenter_with_secondary = (this.bondRelatedBehavior & 4) != 0;
    }

    public IteratorFactory(Molecule mol) {
        this.molecule = mol;
    }

    public AtomIterator createAtomIterator() {
        return new AtomIterator();
    }

    public BondIterator createBondIterator() {
        return new BondIterator();
    }

    public AtomNeighbourIterator createAtomNeighbourIterator(MolAtom atom) {
        return new AtomNeighbourIterator(atom);
    }

    public BondNeighbourIterator createBondNeighbourIterator(MolAtom atom) {
        return new BondNeighbourIterator(atom);
    }

    public RxnComponentIterator createRxnComponentIterator() {
        return new RxnComponentIterator();
    }

    public RgComponentIterator createRgComponentIterator() {
        return new RgComponentIterator();
    }

    public boolean isExcludedAtom(MolAtom atom) {
        return false;
    }

    public boolean isExcludedBond(MolBond bond) {
        return false;
    }

    public int numberOfAtoms() {
        return this.numberOf(new AtomIterator());
    }

    public int numberOfBonds() {
        return this.numberOf(new BondIterator());
    }

    public int numberOfNeighbours(MolAtom atom) {
        return this.numberOf(new BondNeighbourIterator(atom));
    }

    private int numberOf(Iterator<?> it) {
        int num = 0;
        while (it.hasNext()) {
            it.next();
            ++num;
        }
        return num;
    }

    private boolean isExcludedAtomPrivate(MolAtom atom) {
        if (this.atomRelatedBehavior != 0) {
            if (this.skip_multicenter && atom.getAtno() == 137) {
                return true;
            }
            if (this.skip_pseudo_atom && atom.isPseudo()) {
                return true;
            }
            if (this.skip_lone_pair && atom.getAtno() == 130) {
                return true;
            }
            if (this.skip_explicit_h && atom.getAtno() == 1) {
                return true;
            }
        }
        return this.isExcludedAtom(atom);
    }

    private boolean isExcludedBondPrivate(MolBond bond) {
        if (this.bondRelatedBehavior != 0) {
            if (this.skip_coordinate_bond && bond.isCoordinate()) {
                return true;
            }
            if (this.skip_covalent_bond && !bond.isCoordinate()) {
                return true;
            }
            if (this.replace_bonds_to_multicenter_with_secondary && bond.isCoordinate() && (bond.getAtom1().getAtno() == 137 || bond.getAtom2().getAtno() == 137)) {
                return true;
            }
        }
        return this.isExcludedBond(bond);
    }

    public class RgComponentIterator
    implements Iterator<Molecule> {
        private RgMolecule rgm = null;
        private int current_rgroup = 0;
        private int current_member = 0;
        private int rgroup_count = 0;

        public RgComponentIterator() {
            if (IteratorFactory.this.molecule instanceof RgMolecule) {
                this.rgm = (RgMolecule)IteratorFactory.this.molecule;
                this.rgroup_count = this.rgm.getRgroupCount();
            }
        }

        @Override
        public boolean hasNext() {
            return this.current_rgroup < this.rgroup_count && this.current_member < this.rgm.getRgroupMemberCount(this.current_rgroup);
        }

        public Molecule nextComponent() {
            Molecule component = this.rgm.getRgroupMember(this.current_rgroup, this.current_member);
            ++this.current_member;
            if (this.current_member >= this.rgm.getRgroupMemberCount(this.current_rgroup)) {
                ++this.current_rgroup;
                this.current_member = 0;
            }
            return component;
        }

        @Override
        public Molecule next() {
            if (this.hasNext()) {
                Molecule component = this.rgm.getRgroupMember(this.current_rgroup, this.current_member);
                ++this.current_member;
                if (this.current_member >= this.rgm.getRgroupMemberCount(this.current_rgroup)) {
                    ++this.current_rgroup;
                    this.current_member = 0;
                }
                return component;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class RxnComponentIterator
    implements Iterator<Molecule> {
        int index = 0;
        private int nr = 0;
        private int m = 0;
        private int n = 0;
        private RxnMolecule rxn = null;

        public RxnComponentIterator() {
            if (IteratorFactory.this.molecule instanceof RxnMolecule) {
                this.rxn = (RxnMolecule)IteratorFactory.this.molecule;
                this.nr = this.rxn.getReactantCount();
                int np = this.rxn.getProductCount();
                int na = this.rxn.getAgentCount();
                this.m = this.nr + np;
                this.n = this.m + na;
            }
        }

        public Molecule nextComponent() {
            Molecule component = null;
            component = this.index < this.nr ? this.rxn.getReactant(this.index) : (this.index < this.m ? this.rxn.getProduct(this.index - this.nr) : this.rxn.getAgent(this.index - this.m));
            ++this.index;
            return component;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.n;
        }

        @Override
        public Molecule next() {
            if (this.hasNext()) {
                Molecule component = null;
                component = this.index < this.nr ? this.rxn.getReactant(this.index) : (this.index < this.m ? this.rxn.getProduct(this.index - this.nr) : this.rxn.getAgent(this.index - this.m));
                ++this.index;
                return component;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class BondNeighbourIterator
    extends NeighbourIterator<MolBond> {
        public BondNeighbourIterator(MolAtom atom) {
            super(atom);
        }

        public MolBond nextBond() {
            int index = this.currentBond;
            this.currentBond = this.nextBondIndex(this.currentBond);
            return this.getBond(index);
        }

        @Override
        public MolBond next() {
            if (this.hasNext()) {
                int index = this.currentBond;
                this.currentBond = this.nextBondIndex(this.currentBond);
                return this.getBond(index);
            }
            throw new NoSuchElementException();
        }
    }

    public class BondIterator
    implements Iterator<MolBond> {
        protected int currentBond = 0;
        protected List<MolBond> secondaryBonds = new ArrayList<MolBond>();

        public BondIterator() {
            this.generateSecondaryBonds();
            this.currentBond = this.nextBondIndex(this.currentBond - 1);
        }

        private int getBondCount() {
            return IteratorFactory.this.molecule.getBondCount() + this.secondaryBonds.size();
        }

        protected MolBond getBond(int index) {
            if (index < IteratorFactory.this.molecule.getBondCount()) {
                return IteratorFactory.this.molecule.getBond(index);
            }
            return this.secondaryBonds.get(index - IteratorFactory.this.molecule.getBondCount());
        }

        private void generateSecondaryBonds() {
            if (IteratorFactory.this.replace_bonds_to_multicenter_with_secondary && !IteratorFactory.this.skip_coordinate_bond) {
                for (int i = 0; i < IteratorFactory.this.molecule.getBondCount(); ++i) {
                    MulticenterSgroup sg;
                    MolBond bond = IteratorFactory.this.molecule.getBond(i);
                    if (!bond.isCoordinate()) continue;
                    MolAtom atom1 = bond.getAtom1();
                    MolAtom atom2 = bond.getAtom2();
                    if (atom1.getAtno() != 137 && atom2.getAtno() != 137) continue;
                    if (atom1.getAtno() == 137 && atom2.getAtno() == 137) {
                        MulticenterSgroup sg1 = IteratorFactory.this.molecule.findContainingMulticenterSgroup(atom1);
                        MulticenterSgroup sg2 = IteratorFactory.this.molecule.findContainingMulticenterSgroup(atom2);
                        for (int j = 0; j < sg1.getAtomCount(); ++j) {
                            for (int k = 0; k < sg2.getAtomCount(); ++k) {
                                this.secondaryBonds.add(new MolBond(sg1.getAtom(j), sg2.getAtom(k), 9));
                            }
                        }
                        continue;
                    }
                    if (atom1.getAtno() == 137) {
                        sg = IteratorFactory.this.molecule.findContainingMulticenterSgroup(atom1);
                        for (int j = 0; j < sg.getAtomCount(); ++j) {
                            this.secondaryBonds.add(new MolBond(sg.getAtom(j), atom2, 9));
                        }
                        continue;
                    }
                    if (atom2.getAtno() != 137) continue;
                    sg = IteratorFactory.this.molecule.findContainingMulticenterSgroup(atom2);
                    for (int j = 0; j < sg.getAtomCount(); ++j) {
                        this.secondaryBonds.add(new MolBond(atom1, sg.getAtom(j), 9));
                    }
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.currentBond < this.getBondCount();
        }

        private int nextBondIndex(int index) {
            MolBond bond;
            do {
                if (++index < this.getBondCount()) continue;
                return index;
            } while (IteratorFactory.this.isExcludedBondPrivate(bond = this.getBond(index)) || IteratorFactory.this.isExcludedAtomPrivate(bond.getAtom1()) || IteratorFactory.this.isExcludedAtomPrivate(bond.getAtom2()));
            return index;
        }

        public MolBond nextBond() {
            int index = this.currentBond;
            this.currentBond = this.nextBondIndex(this.currentBond);
            return this.getBond(index);
        }

        @Override
        public MolBond next() {
            if (this.hasNext()) {
                int index = this.currentBond;
                this.currentBond = this.nextBondIndex(this.currentBond);
                return this.getBond(index);
            }
            throw new NoSuchElementException();
        }
    }

    public class AtomNeighbourIterator
    extends NeighbourIterator<MolAtom> {
        public AtomNeighbourIterator(MolAtom atom) {
            super(atom);
        }

        public MolAtom nextAtom() {
            int index = this.currentBond;
            this.currentBond = this.nextBondIndex(this.currentBond);
            return this.getBond(index).getOtherAtom(this.atom);
        }

        @Override
        public MolAtom next() {
            if (this.hasNext()) {
                int index = this.currentBond;
                this.currentBond = this.nextBondIndex(this.currentBond);
                return this.getBond(index).getOtherAtom(this.atom);
            }
            throw new NoSuchElementException();
        }
    }

    public class AtomIterator
    implements Iterator<MolAtom> {
        int currentAtom = this.nextAtomIndex(this.currentAtom - 1);

        @Override
        public boolean hasNext() {
            return this.currentAtom < IteratorFactory.this.molecule.getAtomCount();
        }

        private int nextAtomIndex(int index) {
            while (++index < IteratorFactory.this.molecule.getAtomCount() && IteratorFactory.this.isExcludedAtomPrivate(IteratorFactory.this.molecule.getAtom(index))) {
            }
            return index;
        }

        public MolAtom nextAtom() {
            int index = this.currentAtom;
            this.currentAtom = this.nextAtomIndex(this.currentAtom);
            return IteratorFactory.this.molecule.getAtom(index);
        }

        @Override
        public MolAtom next() {
            if (this.hasNext()) {
                int index = this.currentAtom;
                this.currentAtom = this.nextAtomIndex(this.currentAtom);
                return IteratorFactory.this.molecule.getAtom(index);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public abstract class NeighbourIterator<E>
    implements Iterator<E> {
        protected MolAtom atom = null;
        protected int currentBond = 0;
        protected List<MolBond> secondaryBonds = new ArrayList<MolBond>();

        public NeighbourIterator(MolAtom atom) {
            this.atom = atom;
            this.generateSecondaryBonds();
            this.currentBond = IteratorFactory.this.isExcludedAtomPrivate(atom) ? this.getBondCount() : this.nextBondIndex(this.currentBond - 1);
        }

        private int getBondCount() {
            return this.atom.getBondCount() + this.secondaryBonds.size();
        }

        protected MolBond getBond(int index) {
            if (index < this.atom.getBondCount()) {
                return this.atom.getBond(index);
            }
            return this.secondaryBonds.get(index - this.atom.getBondCount());
        }

        private void generateSecondaryBonds() {
            if (IteratorFactory.this.replace_bonds_to_multicenter_with_secondary && !IteratorFactory.this.skip_coordinate_bond) {
                MolAtom center = this.getSecondaryNeighbour(this.atom);
                if (center != null) {
                    for (int j = 0; j < center.getBondCount(); ++j) {
                        if (!center.getBond(j).isCoordinate()) continue;
                        MolAtom otherAtom = center.getBond(j).getOtherAtom(center);
                        this.secondaryBonds.add(new MolBond(this.atom, otherAtom, 9));
                    }
                }
                for (int i = 0; i < this.atom.getBondCount(); ++i) {
                    MolAtom otherAtom;
                    MolBond bond = this.atom.getBond(i);
                    if (!bond.isCoordinate() || (otherAtom = bond.getOtherAtom(this.atom)).getAtno() != 137) continue;
                    MulticenterSgroup sgroup = IteratorFactory.this.molecule.findContainingMulticenterSgroup(otherAtom);
                    for (int j = 0; j < sgroup.getAtomCount(); ++j) {
                        this.secondaryBonds.add(new MolBond(sgroup.getAtom(j), this.atom, 9));
                    }
                }
            }
        }

        private MolAtom getSecondaryNeighbour(MolAtom atom) {
            MulticenterSgroup msgroup;
            MolAtom center;
            Sgroup sgroup = IteratorFactory.this.molecule.findSmallestSgroupContaining(atom);
            if (sgroup != null && sgroup.getType() == 14 && (center = (msgroup = (MulticenterSgroup)sgroup).getCentralAtom()) != null && center.getBondCount() > 0 && !msgroup.hasNonCoordinateBond()) {
                return center;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.currentBond < this.getBondCount();
        }

        protected int nextBondIndex(int index) {
            MolBond bond;
            do {
                if (++index < this.atom.getBondCount()) continue;
                return index;
            } while (IteratorFactory.this.isExcludedBondPrivate(bond = this.getBond(index)) || IteratorFactory.this.isExcludedAtomPrivate(bond.getOtherAtom(this.atom)));
            return index;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

