/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class CustomFormatter
extends Formatter {
    private static final String DEFAULT_FORMAT = "%L: %m  [%Ts|%c.%M|%t] %E";
    private final MessageFormat messageFormat;
    private final DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public CustomFormatter() {
        String propName = this.getClass().getName() + ".format";
        String format2 = LogManager.getLogManager().getProperty(propName);
        if (format2 == null || format2.trim().length() == 0) {
            format2 = DEFAULT_FORMAT;
        }
        if (format2.contains("{") || format2.contains("}")) {
            throw new IllegalArgumentException("curly braces not allowed");
        }
        format2 = format2.replace("%L", "{0}").replace("%m", "{1}").replace("%M", "{2}").replace("%t", "{3}").replace("%c", "{4}").replace("%n", "{5}").replace("%C", "{6}").replace("%Tn", "{7}").replace("%Ti", "{8}").replace("%Ts", "{9}").replace("%E", "{10}") + "\n";
        this.messageFormat = new MessageFormat(format2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        Throwable thrown;
        String[] arguments = new String[11];
        arguments[0] = record.getLevel().toString();
        arguments[1] = record.getMessage();
        if ((arguments[1] == null || arguments[1].length() == 0) && (thrown = record.getThrown()) != null) {
            arguments[1] = thrown.getMessage();
        }
        arguments[1] = record.getMessage();
        arguments[2] = record.getSourceMethodName() != null ? record.getSourceMethodName() : "?";
        Date date = new Date(record.getMillis());
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            arguments[3] = this.dateFormat.format(date);
        }
        arguments[4] = record.getSourceClassName() != null ? record.getSourceClassName() : "?";
        arguments[5] = record.getLoggerName();
        int start = arguments[4].lastIndexOf(".") + 1;
        arguments[6] = start > 0 && start < arguments[4].length() ? arguments[4].substring(start) : arguments[4];
        arguments[7] = Thread.currentThread().getName();
        arguments[8] = Integer.valueOf(record.getThreadID()).toString();
        arguments[9] = arguments[7].equals("main") ? "main" : "thread-".concat(arguments[8]);
        Throwable thrown2 = record.getThrown();
        arguments[10] = thrown2 != null ? "\n" + CustomFormatter.getStackTrace(thrown2) : "";
        MessageFormat messageFormat = this.messageFormat;
        synchronized (messageFormat) {
            return this.messageFormat.format(arguments);
        }
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }
}

