/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipWindow;

public class FocusableTip {
    private JTextArea textArea;
    private TipWindow tipWindow;
    private URL imageBase;
    private TextAreaListener textAreaListener;
    private HyperlinkListener hyperlinkListener;
    private String lastText;
    private Rectangle tipVisibleBounds;
    private static final int X_MARGIN = 18;
    private static final int Y_MARGIN = 12;
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip");

    public FocusableTip(JTextArea jTextArea, HyperlinkListener hyperlinkListener) {
        this.setTextArea(jTextArea);
        this.hyperlinkListener = hyperlinkListener;
        this.textAreaListener = new TextAreaListener();
        this.tipVisibleBounds = new Rectangle();
    }

    private void computeTipVisibleBounds() {
        Rectangle rectangle = this.tipWindow.getBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointFromScreen(point, this.textArea);
        rectangle.setLocation(point);
        this.tipVisibleBounds.setBounds(rectangle.x, rectangle.y - 15, rectangle.width, rectangle.height + 30);
    }

    private void createAndShowTipWindow(final MouseEvent mouseEvent, final String string) {
        Window window = SwingUtilities.getWindowAncestor(this.textArea);
        this.tipWindow = new TipWindow(window, this, string);
        this.tipWindow.setHyperlinkListener(this.hyperlinkListener);
        PopupWindowDecorator popupWindowDecorator = PopupWindowDecorator.get();
        if (popupWindowDecorator != null) {
            popupWindowDecorator.decorate(this.tipWindow);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (FocusableTip.this.tipWindow == null) {
                    return;
                }
                FocusableTip.this.tipWindow.fixSize();
                ComponentOrientation componentOrientation = FocusableTip.this.textArea.getComponentOrientation();
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, FocusableTip.this.textArea);
                Rectangle rectangle = TipUtil.getScreenBoundsForPoint(point.x, point.y);
                int n = point.y + 12;
                if (n + FocusableTip.this.tipWindow.getHeight() >= rectangle.y + rectangle.height) {
                    n = point.y - 12 - FocusableTip.this.tipWindow.getHeight();
                }
                int n2 = point.x - 18;
                if (!componentOrientation.isLeftToRight()) {
                    n2 = point.x - FocusableTip.this.tipWindow.getWidth() + 18;
                }
                if (n2 < rectangle.x) {
                    n2 = rectangle.x;
                } else if (n2 + FocusableTip.this.tipWindow.getWidth() > rectangle.x + rectangle.width) {
                    n2 = rectangle.x + rectangle.width - FocusableTip.this.tipWindow.getWidth();
                }
                FocusableTip.this.tipWindow.setLocation(n2, n);
                FocusableTip.this.tipWindow.setVisible(true);
                FocusableTip.this.computeTipVisibleBounds();
                FocusableTip.this.textAreaListener.install(FocusableTip.this.textArea);
                FocusableTip.this.lastText = string;
            }
        });
    }

    public URL getImageBase() {
        return this.imageBase;
    }

    static String getString(String string) {
        return msg.getString(string);
    }

    public void possiblyDisposeOfTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.dispose();
            this.tipWindow = null;
            this.textAreaListener.uninstall();
            this.tipVisibleBounds.setBounds(-1, -1, 0, 0);
            this.lastText = null;
            this.textArea.requestFocus();
        }
    }

    void removeListeners() {
        this.textAreaListener.uninstall();
    }

    public void setImageBase(URL uRL) {
        this.imageBase = uRL;
    }

    private void setTextArea(JTextArea jTextArea) {
        this.textArea = jTextArea;
        ToolTipManager.sharedInstance().registerComponent(jTextArea);
    }

    public void toolTipRequested(MouseEvent mouseEvent, String string) {
        if (string == null || string.length() == 0) {
            this.possiblyDisposeOfTipWindow();
            this.lastText = string;
            return;
        }
        if (this.lastText == null || string.length() != this.lastText.length() || !string.equals(this.lastText)) {
            this.possiblyDisposeOfTipWindow();
            this.createAndShowTipWindow(mouseEvent, string);
        }
    }

    private class TextAreaListener
    extends MouseInputAdapter
    implements CaretListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        private TextAreaListener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            Object object = caretEvent.getSource();
            if (object == FocusableTip.this.textArea) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            boolean bl;
            Component component = focusEvent.getOppositeComponent();
            boolean bl2 = bl = component instanceof TipWindow || component != null && SwingUtilities.getWindowAncestor(component) instanceof TipWindow;
            if (!bl) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        private void handleComponentEvent(ComponentEvent componentEvent) {
            FocusableTip.this.possiblyDisposeOfTipWindow();
        }

        public void install(JTextArea jTextArea) {
            jTextArea.addCaretListener(this);
            jTextArea.addComponentListener(this);
            jTextArea.addFocusListener(this);
            jTextArea.addKeyListener(this);
            jTextArea.addMouseListener(this);
            jTextArea.addMouseMotionListener(this);
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            } else if (keyEvent.getKeyCode() == 113 && FocusableTip.this.tipWindow != null && !FocusableTip.this.tipWindow.getFocusableWindowState()) {
                FocusableTip.this.tipWindow.actionPerformed(null);
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (FocusableTip.this.tipVisibleBounds == null || !FocusableTip.this.tipVisibleBounds.contains(mouseEvent.getPoint())) {
                FocusableTip.this.possiblyDisposeOfTipWindow();
            }
        }

        public void uninstall() {
            FocusableTip.this.textArea.removeCaretListener(this);
            FocusableTip.this.textArea.removeComponentListener(this);
            FocusableTip.this.textArea.removeFocusListener(this);
            FocusableTip.this.textArea.removeKeyListener(this);
            FocusableTip.this.textArea.removeMouseListener(this);
            FocusableTip.this.textArea.removeMouseMotionListener(this);
        }
    }
}

