/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4GRImage;
import ncsa.hdf.object.h4.H4Group;
import ncsa.hdf.object.h4.H4SDS;
import ncsa.hdf.object.h4.H4Vdata;

public class H4File
extends FileFormat {
    private static final long serialVersionUID = 8985533001471224030L;
    private int flag;
    private DefaultMutableTreeNode rootNode;
    private List objList;
    private int grid;
    private boolean isNetCDF = false;
    private int sdid;
    private boolean showAll = false;

    public H4File() {
        this("", 1);
    }

    public H4File(String pathname) {
        this(pathname, 1);
    }

    public H4File(String fileName, int access) {
        super(fileName);
        this.isReadOnly = access == 0;
        this.objList = new Vector();
        this.fid = -1;
        this.flag = access == 0 ? 1 : (access == 1 ? 2 : (access == 2 ? 4 : access));
        String shwAll = System.getProperty("h4showall");
        if (shwAll != null) {
            this.showAll = true;
        }
    }

    @Override
    public boolean isThisType(FileFormat fileformat) {
        return fileformat instanceof H4File;
    }

    @Override
    public boolean isThisType(String filename) {
        boolean isH4 = false;
        try {
            isH4 = HDFLibrary.Hishdf((String)filename);
        }
        catch (HDFException ex) {
            isH4 = false;
        }
        if (!isH4) {
            isH4 = this.isNetCDF(filename);
        }
        return isH4;
    }

    @Override
    public FileFormat createFile(String filename, int createFlag) throws Exception {
        File f;
        Boolean doCreateFile = true;
        if (createFlag == 11 && (f = new File(filename)).exists()) {
            doCreateFile = false;
        }
        if (doCreateFile.booleanValue()) {
            int fileid = HDFLibrary.Hopen((String)filename, (int)4);
            try {
                HDFLibrary.Hclose((int)fileid);
            }
            catch (HDFException ex) {
                // empty catch block
            }
        }
        return new H4File(filename, 1);
    }

    @Override
    public FileFormat createInstance(String filename, int access) throws Exception {
        return new H4File(filename, access);
    }

    @Override
    public int open() throws Exception {
        if (this.fid >= 0) {
            return this.fid;
        }
        if (this.flag < 0) {
            throw new HDFException("Invalid access identifer -- " + this.flag);
        }
        if (this.flag == 1) {
            if (!this.exists()) {
                throw new HDFException("File does not exist -- " + this.fullFileName);
            }
            if (this.exists() && !this.canRead()) {
                throw new HDFException("Cannot read file -- " + this.fullFileName);
            }
        } else if ((this.flag == 2 || this.flag == 4) && this.exists() && !this.canWrite()) {
            throw new HDFException("Cannot write file, try open as read-only -- " + this.fullFileName);
        }
        this.isNetCDF = this.isNetCDF(this.fullFileName);
        if (this.isNetCDF) {
            this.isReadOnly = true;
        }
        if (this.isNetCDF) {
            this.fid = 0;
        } else {
            this.fid = HDFLibrary.Hopen((String)this.fullFileName, (int)this.flag);
            HDFLibrary.Vstart((int)this.fid);
            this.grid = HDFLibrary.GRstart((int)this.fid);
        }
        this.sdid = HDFLibrary.SDstart((String)this.fullFileName, (int)this.flag);
        this.rootNode = this.loadTree();
        return this.fid;
    }

    @Override
    public void close() throws HDFException {
        if (this.rootNode != null) {
            DefaultMutableTreeNode theNode = null;
            HObject theObj = null;
            Enumeration<TreeNode> local_enum = this.rootNode.breadthFirstEnumeration();
            while (local_enum.hasMoreElements()) {
                theNode = (DefaultMutableTreeNode)local_enum.nextElement();
                theObj = (HObject)theNode.getUserObject();
                if (theObj instanceof Dataset) {
                    ((Dataset)theObj).clearData();
                }
                theObj = null;
                theNode = null;
            }
        }
        try {
            HDFLibrary.GRend((int)this.grid);
        }
        catch (HDFException ex) {
            // empty catch block
        }
        try {
            HDFLibrary.SDend((int)this.sdid);
        }
        catch (HDFException ex) {
            // empty catch block
        }
        try {
            HDFLibrary.Vend((int)this.fid);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
        HDFLibrary.Hclose((int)this.fid);
        this.fid = -1;
        this.objList = null;
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Group createGroup(String name, Group pgroup) throws Exception {
        return H4Group.create(name, pgroup);
    }

    @Override
    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign) throws Exception {
        return new H4Datatype(tclass, tsize, torder, tsign);
    }

    @Override
    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign, String name) throws Exception {
        throw new UnsupportedOperationException("HDF4 does not support named datatype.");
    }

    @Override
    public Dataset createScalarDS(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object fillValue, Object data) throws Exception {
        return H4SDS.create(name, pgroup, type, dims, maxdims, chunks, gzip, fillValue, data);
    }

    @Override
    public Dataset createImage(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, int ncomp, int interlace, Object data) throws Exception {
        H4GRImage dataset = H4GRImage.create(name, pgroup, type, dims, maxdims, chunks, gzip, ncomp, interlace, data);
        return dataset;
    }

    @Override
    public void delete(HObject obj) throws Exception {
        throw new UnsupportedOperationException("Cannot delete HDF4 object.");
    }

    @Override
    public TreeNode copy(HObject srcObj, Group dstGroup, String dstName) throws Exception {
        TreeNode newNode = null;
        if (srcObj == null || dstGroup == null) {
            return null;
        }
        if (dstName == null) {
            dstName = srcObj.getName();
        }
        if (srcObj instanceof H4SDS) {
            newNode = new DefaultMutableTreeNode(((H4SDS)srcObj).copy(dstGroup, dstName, null, null));
        } else if (srcObj instanceof H4GRImage) {
            newNode = new DefaultMutableTreeNode(((H4GRImage)srcObj).copy(dstGroup, dstName, null, null));
        } else if (srcObj instanceof H4Vdata) {
            newNode = new DefaultMutableTreeNode(((H4Vdata)srcObj).copy(dstGroup, null, null, null));
        } else if (srcObj instanceof H4Group) {
            newNode = this.copyGroup((H4Group)srcObj, (H4Group)dstGroup);
        }
        return newNode;
    }

    @Override
    public void writeAttribute(HObject obj, Attribute attr, boolean isSDglobalAttr) throws HDFException {
        Object attrValue;
        String attrName = attr.getName();
        int attrType = attr.getType().toNative();
        long[] dims = attr.getDataDims();
        int count = 1;
        if (dims != null) {
            for (int i = 0; i < dims.length; ++i) {
                count *= (int)dims[i];
            }
        }
        if (Array.get(attrValue = attr.getValue(), 0) instanceof String) {
            String strValue = (String)Array.get(attrValue, 0);
            if (strValue.length() > count) {
                strValue = strValue.substring(0, count);
                Array.set(attrValue, 0, strValue);
            } else {
                for (int i = strValue.length(); i < count; ++i) {
                    strValue = strValue + " ";
                }
            }
            byte[] bval = strValue.getBytes();
            bval[strValue.length() - 1] = 0;
            attrValue = bval;
        }
        if (obj instanceof H4Group && ((H4Group)obj).isRoot()) {
            if (isSDglobalAttr) {
                HDFLibrary.SDsetattr((int)this.sdid, (String)attrName, (int)attrType, (int)count, (Object)attrValue);
            } else {
                HDFLibrary.GRsetattr((int)this.grid, (String)attrName, (int)attrType, (int)count, (Object)attrValue);
            }
            return;
        }
        int id = obj.open();
        if (obj instanceof H4Group) {
            HDFLibrary.Vsetattr((int)id, (String)attrName, (int)attrType, (int)count, (Object)attrValue);
        } else if (obj instanceof H4SDS) {
            HDFLibrary.SDsetattr((int)id, (String)attrName, (int)attrType, (int)count, (Object)attrValue);
        } else if (obj instanceof H4GRImage) {
            HDFLibrary.GRsetattr((int)id, (String)attrName, (int)attrType, (int)count, (Object)attrValue);
        } else if (obj instanceof H4Vdata) {
            HDFLibrary.VSsetattr((int)id, (int)-1, (String)attrName, (int)attrType, (int)count, (Object)attrValue);
        }
        obj.close(id);
    }

    private TreeNode copyGroup(H4Group srcGroup, H4Group pgroup) throws Exception {
        H4Group group = null;
        String gname = null;
        String path = null;
        int dstgid = HDFLibrary.Vattach((int)this.fid, (int)-1, (String)"w");
        if (dstgid < 0) {
            return null;
        }
        gname = srcGroup.getName();
        int srcgid = srcGroup.open();
        HDFLibrary.Vsetname((int)dstgid, (String)gname);
        int ref = HDFLibrary.VQueryref((int)dstgid);
        int tag = HDFLibrary.VQuerytag((int)dstgid);
        if (pgroup.isRoot()) {
            path = "/";
        } else {
            path = pgroup.getPath() + pgroup.getName() + "/";
            int pid = pgroup.open();
            HDFLibrary.Vinsert((int)pid, (int)dstgid);
            pgroup.close(pid);
        }
        int numberOfAttributes = 0;
        try {
            numberOfAttributes = HDFLibrary.Vnattrs((int)srcgid);
        }
        catch (Exception ex) {
            numberOfAttributes = 0;
        }
        String[] attrName = new String[1];
        byte[] attrBuff = null;
        int[] attrInfo = new int[3];
        for (int i = 0; i < numberOfAttributes; ++i) {
            try {
                attrName[0] = "";
                HDFLibrary.Vattrinfo((int)srcgid, (int)i, (String[])attrName, (int[])attrInfo);
                attrBuff = new byte[attrInfo[2]];
                HDFLibrary.Vgetattr((int)srcgid, (int)i, (byte[])attrBuff);
                HDFLibrary.Vsetattr((int)dstgid, (String)attrName[0], (int)attrInfo[0], (int)attrInfo[2], (byte[])attrBuff);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        long[] oid = new long[]{tag, ref};
        group = new H4Group(this, gname, path, pgroup, oid);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(group){
            private static final long serialVersionUID = -8601910527549035409L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        pgroup.addToMemberList(group);
        List<HObject> members = srcGroup.getMemberList();
        if (members != null && members.size() > 0) {
            for (HObject mObj : members) {
                try {
                    newNode.add((MutableTreeNode)this.copy(mObj, group));
                }
                catch (Exception ex) {}
            }
        }
        srcGroup.close(srcgid);
        try {
            HDFLibrary.Vdetach((int)dstgid);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return newNode;
    }

    private DefaultMutableTreeNode loadTree() {
        if (this.fid < 0) {
            return null;
        }
        long[] oid = new long[]{0L, 0L};
        int n = 0;
        int ref = -1;
        int[] argv = null;
        DefaultMutableTreeNode node = null;
        H4Group rootGroup = new H4Group(this, "/", null, null, oid);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup){
            private static final long serialVersionUID = 3507473044690724650L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        int[] tmpN = new int[1];
        int[] refs = null;
        try {
            n = HDFLibrary.Vlone((int)this.fid, (int[])tmpN, (int)0);
            refs = new int[n];
            n = HDFLibrary.Vlone((int)this.fid, (int[])refs, (int)n);
        }
        catch (HDFException ex) {
            n = 0;
        }
        int i0 = Math.max(0, this.getStartMembers());
        int i1 = this.getMaxMembers();
        if (i1 >= n) {
            i1 = n;
            i0 = 0;
        }
        i1 += i0;
        i1 = Math.min(i1, n);
        for (int i = i0; i < i1; ++i) {
            ref = refs[i];
            H4Group g = this.getVGroup(1965, ref, "/", rootGroup, false);
            if (g == null) continue;
            node = new DefaultMutableTreeNode(g){
                private static final long serialVersionUID = 8927502967802143369L;

                @Override
                public boolean isLeaf() {
                    return false;
                }
            };
            root.add(node);
            rootGroup.addToMemberList(g);
            this.depth_first(node, null);
        }
        argv = new int[2];
        boolean b = false;
        try {
            b = HDFLibrary.GRfileinfo((int)this.grid, (int[])argv);
        }
        catch (HDFException ex) {
            b = false;
        }
        if (b) {
            n = argv[0];
            for (int i = 0; i < n; ++i) {
                H4GRImage gr = this.getGRImage(306, i, "/", false);
                if (gr == null) continue;
                node = new DefaultMutableTreeNode(gr);
                root.add(node);
                rootGroup.addToMemberList(gr);
            }
        }
        try {
            b = HDFLibrary.SDfileinfo((int)this.sdid, (int[])argv);
        }
        catch (HDFException ex) {
            b = false;
        }
        if (b) {
            n = argv[0];
            for (int i = 0; i < n; ++i) {
                H4SDS sds = this.getSDS(720, i, "/", false);
                if (sds == null) continue;
                node = new DefaultMutableTreeNode(sds);
                root.add(node);
                rootGroup.addToMemberList(sds);
            }
        }
        try {
            n = HDFLibrary.VSlone((int)this.fid, (int[])tmpN, (int)0);
            refs = new int[n];
            n = HDFLibrary.VSlone((int)this.fid, (int[])refs, (int)n);
        }
        catch (HDFException ex) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            ref = refs[i];
            H4Vdata vdata = this.getVdata(1963, ref, "/", false);
            if (vdata == null) continue;
            node = new DefaultMutableTreeNode(vdata);
            root.add(node);
            rootGroup.addToMemberList(vdata);
        }
        if (rootGroup != null) {
            List attributeList = null;
            try {
                attributeList = rootGroup.getMetadata();
            }
            catch (HDFException ex) {
                // empty catch block
            }
            if (attributeList != null) {
                try {
                    this.getFileAnnotation(this.fid, attributeList);
                }
                catch (HDFException ex) {
                    // empty catch block
                }
                try {
                    this.getGRglobleAttribute(this.grid, attributeList);
                }
                catch (HDFException ex) {
                    // empty catch block
                }
                try {
                    this.getSDSglobleAttribute(this.sdid, attributeList);
                }
                catch (HDFException ex) {
                    // empty catch block
                }
            }
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void depth_first(MutableTreeNode parentNode, H4Group pgroup) {
        if (pgroup == null && parentNode == null) {
            return;
        }
        int nelems = 0;
        int ref = -1;
        int tag = -1;
        int index = -1;
        int[] tags = null;
        int[] refs = null;
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode pnode = null;
        if (parentNode != null) {
            pnode = (DefaultMutableTreeNode)parentNode;
            pgroup = (H4Group)pnode.getUserObject();
        }
        String fullPath = pgroup.getPath() + pgroup.getName() + "/";
        int gid = pgroup.open();
        if (gid == -1) {
            return;
        }
        try {
            nelems = HDFLibrary.Vntagrefs((int)gid);
            tags = new int[nelems];
            refs = new int[nelems];
            nelems = HDFLibrary.Vgettagrefs((int)gid, (int[])tags, (int[])refs, (int)nelems);
        }
        catch (HDFException ex) {
            nelems = 0;
        }
        finally {
            pgroup.close(gid);
        }
        int i0 = Math.max(0, this.getStartMembers());
        int i1 = this.getMaxMembers();
        if (i1 >= nelems) {
            i1 = nelems;
            i0 = 0;
        }
        i1 += i0;
        i1 = Math.min(i1, nelems);
        block15: for (int i = i0; i < i1; ++i) {
            tag = tags[i];
            ref = refs[i];
            switch (tag) {
                case 202: 
                case 302: 
                case 306: {
                    try {
                        index = HDFLibrary.GRreftoindex((int)this.grid, (short)((short)ref));
                    }
                    catch (HDFException ex) {
                        index = -1;
                    }
                    if (index == -1) continue block15;
                    H4GRImage gr = this.getGRImage(tag, index, fullPath, true);
                    pgroup.addToMemberList(gr);
                    if (gr == null || pnode == null) continue block15;
                    node = new DefaultMutableTreeNode(gr);
                    pnode.add(node);
                    continue block15;
                }
                case 700: 
                case 702: 
                case 720: {
                    try {
                        index = HDFLibrary.SDreftoindex((int)this.sdid, (int)ref);
                    }
                    catch (HDFException ex) {
                        index = -1;
                    }
                    if (index == -1) continue block15;
                    H4SDS sds = this.getSDS(tag, index, fullPath, true);
                    pgroup.addToMemberList(sds);
                    if (sds == null || pnode == null) continue block15;
                    node = new DefaultMutableTreeNode(sds);
                    pnode.add(node);
                    continue block15;
                }
                case 1962: 
                case 1963: {
                    H4Vdata vdata = this.getVdata(tag, ref, fullPath, true);
                    pgroup.addToMemberList(vdata);
                    if (vdata == null || pnode == null) continue block15;
                    node = new DefaultMutableTreeNode(vdata);
                    pnode.add(node);
                    continue block15;
                }
                case 1965: {
                    H4Group vgroup = this.getVGroup(tag, ref, fullPath, pgroup, true);
                    pgroup.addToMemberList(vgroup);
                    if (vgroup == null || pnode == null) continue block15;
                    node = new DefaultMutableTreeNode(vgroup){
                        private static final long serialVersionUID = -8774836537322039221L;

                        @Override
                        public boolean isLeaf() {
                            return false;
                        }
                    };
                    pnode.add(node);
                    boolean looped = false;
                    DefaultMutableTreeNode theNode = pnode;
                    while (theNode != null && !looped) {
                        long[] oid;
                        H4Group theGroup = (H4Group)theNode.getUserObject();
                        if (theGroup.equalsOID(oid = new long[]{tag, ref})) {
                            looped = true;
                            continue;
                        }
                        theNode = (DefaultMutableTreeNode)theNode.getParent();
                    }
                    if (looped) continue block15;
                    this.depth_first(node, null);
                    continue block15;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4GRImage getGRImage(int tag, int index, String path, boolean copyAllowed) {
        int id = -1;
        int ref = -1;
        H4GRImage gr = null;
        String[] objName = new String[]{""};
        int[] imgInfo = new int[4];
        int[] dim_sizes = new int[]{0, 0};
        try {
            id = HDFLibrary.GRselect((int)this.grid, (int)index);
            ref = HDFLibrary.GRidtoref((int)id);
            HDFLibrary.GRgetiminfo((int)id, (String[])objName, (int[])imgInfo, (int[])dim_sizes);
        }
        catch (HDFException ex) {
            id = -1;
        }
        finally {
            try {
                HDFLibrary.GRendaccess((int)id);
            }
            catch (HDFException ex) {}
        }
        if (id != -1) {
            long[] oid = new long[]{tag, ref};
            if (copyAllowed) {
                this.objList.add(oid);
            } else if (this.find(oid)) {
                return null;
            }
            gr = new H4GRImage(this, objName[0], path, oid);
        }
        return gr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4SDS getSDS(int tag, int index, String path, boolean copyAllowed) {
        int id = -1;
        int ref = -1;
        H4SDS sds = null;
        String[] objName = new String[]{""};
        int[] tmpInfo = new int[32];
        int[] sdInfo = new int[]{0, 0, 0};
        boolean isCoordvar = false;
        try {
            id = HDFLibrary.SDselect((int)this.sdid, (int)index);
            if (this.isNetCDF) {
                ref = index;
                tag = 67687001;
            } else {
                ref = HDFLibrary.SDidtoref((int)id);
            }
            HDFLibrary.SDgetinfo((int)id, (String[])objName, (int[])tmpInfo, (int[])sdInfo);
            isCoordvar = HDFLibrary.SDiscoordvar((int)id);
        }
        catch (HDFException ex) {
            id = -1;
        }
        finally {
            try {
                HDFLibrary.SDendaccess((int)id);
            }
            catch (HDFException ex) {}
        }
        if (isCoordvar) {
            objName[0] = objName[0] + " (dimension)";
        }
        if (id != -1) {
            long[] oid = new long[]{tag, ref};
            if (copyAllowed) {
                this.objList.add(oid);
            } else if (this.find(oid)) {
                return null;
            }
            sds = new H4SDS(this, objName[0], path, oid);
        }
        return sds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4Vdata getVdata(int tag, int ref, String path, boolean copyAllowed) {
        int id = -1;
        H4Vdata vdata = null;
        String[] objName = new String[]{""};
        String[] vClass = new String[]{""};
        long[] oid = new long[]{tag, ref};
        if (copyAllowed) {
            this.objList.add(oid);
        } else if (this.find(oid)) {
            return null;
        }
        try {
            id = HDFLibrary.VSattach((int)this.fid, (int)ref, (String)"r");
            HDFLibrary.VSgetclass((int)id, (String[])vClass);
            vClass[0] = vClass[0].trim();
            HDFLibrary.VSgetname((int)id, (String[])objName);
        }
        catch (HDFException ex) {
            id = -1;
        }
        finally {
            try {
                HDFLibrary.VSdetach((int)id);
            }
            catch (HDFException ex) {}
        }
        if (this.showAll || id != -1 && !vClass[0].startsWith("_HDF_CHK_TBL_") && !vClass[0].equalsIgnoreCase("CDF0.0")) {
            vdata = new H4Vdata(this, objName[0], path, oid);
        }
        return vdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final H4Group getVGroup(int tag, int ref, String path, H4Group pgroup, boolean copyAllowed) {
        int id = -1;
        H4Group vgroup = null;
        String[] objName = new String[]{""};
        String[] vClass = new String[]{""};
        long[] oid = new long[]{tag, ref};
        if (copyAllowed) {
            this.objList.add(oid);
        } else if (this.find(oid)) {
            return null;
        }
        try {
            id = HDFLibrary.Vattach((int)this.fid, (int)ref, (String)"r");
            HDFLibrary.Vgetclass((int)id, (String[])vClass);
            vClass[0] = vClass[0].trim();
            HDFLibrary.Vgetname((int)id, (String[])objName);
        }
        catch (HDFException ex) {
            id = -1;
        }
        finally {
            try {
                HDFLibrary.Vdetach((int)id);
            }
            catch (HDFException ex) {}
        }
        if (this.showAll || id != -1 && !vClass[0].equalsIgnoreCase("RIG0.0") && !vClass[0].equalsIgnoreCase("RI0.0") && !vClass[0].equalsIgnoreCase("RIATTR0.0N") && !vClass[0].equalsIgnoreCase("RIATTR0.0C") && !vClass[0].equalsIgnoreCase("CDF0.0")) {
            vgroup = new H4Group(this, objName[0], path, pgroup, oid);
        }
        return vgroup;
    }

    private final boolean find(long[] oid) {
        boolean existed = false;
        if (this.objList == null) {
            return false;
        }
        int n = this.objList.size();
        long[] theOID = null;
        for (int i = 0; i < n; ++i) {
            theOID = (long[])this.objList.get(i);
            if (theOID[0] != oid[0] || theOID[1] != oid[1]) continue;
            existed = true;
            break;
        }
        if (!existed) {
            this.objList.add(oid);
        }
        return existed;
    }

    int getGRAccessID() {
        return this.grid;
    }

    int getSDAccessID() {
        return this.sdid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFileAnnotation(int fid, List attrList) throws HDFException {
        if (fid < 0) {
            return attrList;
        }
        int anid = -1;
        try {
            anid = HDFLibrary.ANstart((int)fid);
            int[] fileInfo = new int[4];
            HDFLibrary.ANfileinfo((int)anid, (int[])fileInfo);
            if (fileInfo[0] + fileInfo[1] <= 0) {
                try {
                    HDFLibrary.ANend((int)anid);
                }
                catch (HDFException ex) {
                    // empty catch block
                }
                Vector<Attribute> ex = attrList;
                return ex;
            }
            if (attrList == null) {
                attrList = new Vector<Attribute>(fileInfo[0] + fileInfo[1], 5);
            }
            int id = -1;
            int[] annTypes = new int[]{2, 3};
            for (int j = 0; j < 2; ++j) {
                String annName = null;
                annName = j == 0 ? "File Label" : "File Description";
                for (int i = 0; i < fileInfo[j]; ++i) {
                    try {
                        id = HDFLibrary.ANselect((int)anid, (int)i, (int)annTypes[j]);
                    }
                    catch (HDFException ex) {
                        id = -1;
                    }
                    if (id == -1) {
                        try {
                            HDFLibrary.ANendaccess((int)id);
                        }
                        catch (HDFException ex) {}
                        continue;
                    }
                    int length = 0;
                    try {
                        length = HDFLibrary.ANannlen((int)id) + 1;
                    }
                    catch (HDFException ex) {
                        length = 0;
                    }
                    if (length > 0) {
                        boolean b = false;
                        String[] str = new String[]{""};
                        try {
                            b = HDFLibrary.ANreadann((int)id, (String[])str, (int)length);
                        }
                        catch (HDFException ex) {
                            b = false;
                        }
                        if (b && str[0].length() > 0) {
                            long[] attrDims = new long[]{str[0].length()};
                            Attribute newAttr = new Attribute(annName + " #" + i, new H4Datatype(4), attrDims);
                            attrList.add(newAttr);
                            newAttr.setValue(str[0]);
                        }
                    }
                    try {
                        HDFLibrary.ANendaccess((int)id);
                        continue;
                    }
                    catch (HDFException ex) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            try {
                HDFLibrary.ANend((int)anid);
            }
            catch (HDFException ex) {}
        }
        return attrList;
    }

    private List getGRglobleAttribute(int grid, List attrList) throws HDFException {
        if (grid == -1) {
            return attrList;
        }
        int[] attrInfo = new int[]{0, 0};
        HDFLibrary.GRfileinfo((int)grid, (int[])attrInfo);
        int numberOfAttributes = attrInfo[1];
        if (numberOfAttributes > 0) {
            if (attrList == null) {
                attrList = new Vector<Attribute>(numberOfAttributes, 5);
            }
            String[] attrName = new String[1];
            for (int i = 0; i < numberOfAttributes; ++i) {
                attrName[0] = "";
                boolean b = false;
                try {
                    b = HDFLibrary.GRattrinfo((int)grid, (int)i, (String[])attrName, (int[])attrInfo);
                    attrInfo[0] = attrInfo[0] & 0xFFFFBFFF;
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                long[] attrDims = new long[]{attrInfo[1]};
                Attribute attr = new Attribute(attrName[0], new H4Datatype(attrInfo[0]), attrDims);
                attrList.add(attr);
                String[] buf = H4Datatype.allocateArray(attrInfo[0], attrInfo[1]);
                try {
                    HDFLibrary.GRgetattr((int)grid, (int)i, (Object)buf);
                }
                catch (HDFException ex) {
                    buf = null;
                }
                if (buf == null) continue;
                if (attrInfo[0] == 4 || attrInfo[0] == 3) {
                    buf = Dataset.byteToString((byte[])buf, attrInfo[1]);
                }
                attr.setValue(buf);
            }
        }
        return attrList;
    }

    private List getSDSglobleAttribute(int sdid, List attrList) throws HDFException {
        if (sdid == -1) {
            return attrList;
        }
        int[] attrInfo = new int[]{0, 0};
        HDFLibrary.SDfileinfo((int)sdid, (int[])attrInfo);
        int numberOfAttributes = attrInfo[1];
        if (numberOfAttributes > 0) {
            if (attrList == null) {
                attrList = new Vector<Attribute>(numberOfAttributes, 5);
            }
            String[] attrName = new String[1];
            for (int i = 0; i < numberOfAttributes; ++i) {
                attrName[0] = "";
                boolean b = false;
                try {
                    b = HDFLibrary.SDattrinfo((int)sdid, (int)i, (String[])attrName, (int[])attrInfo);
                    attrInfo[0] = attrInfo[0] & 0xFFFFBFFF;
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                long[] attrDims = new long[]{attrInfo[1]};
                Attribute attr = new Attribute(attrName[0], new H4Datatype(attrInfo[0]), attrDims);
                attrList.add(attr);
                String[] buf = H4Datatype.allocateArray(attrInfo[0], attrInfo[1]);
                try {
                    HDFLibrary.SDreadattr((int)sdid, (int)i, (Object)buf);
                }
                catch (HDFException ex) {
                    buf = null;
                }
                if (buf == null) continue;
                if (attrInfo[0] == 4 || attrInfo[0] == 3) {
                    buf = Dataset.byteToString((byte[])buf, attrInfo[1]);
                }
                attr.setValue(buf);
            }
        }
        return attrList;
    }

    @Override
    public String getLibversion() {
        int[] vers = new int[3];
        String ver = "HDF ";
        String[] verStr = new String[]{""};
        try {
            HDFLibrary.Hgetlibversion((int[])vers, (String[])verStr);
        }
        catch (HDFException ex) {
            // empty catch block
        }
        ver = ver + vers[0] + "." + vers[1] + "." + vers[2];
        return ver;
    }

    private boolean isNetCDF(String filename) {
        boolean isnetcdf = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (Exception ex) {
            try {
                raf.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            raf = null;
        }
        if (raf == null) {
            return false;
        }
        byte[] header = new byte[4];
        try {
            raf.read(header);
        }
        catch (Exception ex) {
            header = null;
        }
        if (header != null) {
            isnetcdf = header[0] == 67 && header[1] == 68 && header[2] == 70 && header[3] == 1;
        }
        try {
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return isnetcdf;
    }

    @Override
    public HObject get(String path) throws Exception {
        if (this.objList == null) {
            this.objList = new Vector();
        }
        if (path == null || path.length() <= 0) {
            return null;
        }
        if (!(path = path.replace('\\', '/')).startsWith("/")) {
            path = "/" + path;
        }
        String name = null;
        String pPath = null;
        boolean isRoot = false;
        if (path.equals("/")) {
            name = "/";
            isRoot = true;
        } else {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 2);
            }
            int idx = path.lastIndexOf(47);
            name = path.substring(idx + 1);
            pPath = idx == 0 ? "/" : path.substring(0, idx);
        }
        HObject obj = null;
        this.isReadOnly = false;
        if (this.fid < 0) {
            this.fid = HDFLibrary.Hopen((String)this.fullFileName, (int)2);
            if (this.fid < 0) {
                this.isReadOnly = true;
                this.fid = HDFLibrary.Hopen((String)this.fullFileName, (int)1);
            }
            HDFLibrary.Vstart((int)this.fid);
            this.grid = HDFLibrary.GRstart((int)this.fid);
            this.sdid = HDFLibrary.SDstart((String)this.fullFileName, (int)this.flag);
        }
        obj = isRoot ? this.getRootGroup() : this.getAttachedObject(pPath, name);
        return obj;
    }

    private H4Group getRootGroup() {
        H4Group rootGroup = null;
        long[] oid = new long[]{0L, 0L};
        int n = 0;
        int ref = -1;
        int[] argv = null;
        rootGroup = new H4Group(this, "/", null, null, oid);
        int[] tmpN = new int[1];
        int[] refs = null;
        try {
            n = HDFLibrary.Vlone((int)this.fid, (int[])tmpN, (int)0);
            refs = new int[n];
            n = HDFLibrary.Vlone((int)this.fid, (int[])refs, (int)n);
        }
        catch (HDFException ex) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            ref = refs[i];
            H4Group g = this.getVGroup(1965, ref, "/", rootGroup, false);
            if (g == null) continue;
            rootGroup.addToMemberList(g);
        }
        argv = new int[2];
        boolean b = false;
        try {
            b = HDFLibrary.GRfileinfo((int)this.grid, (int[])argv);
        }
        catch (HDFException ex) {
            b = false;
        }
        if (b) {
            n = argv[0];
            for (int i = 0; i < n; ++i) {
                H4GRImage gr = this.getGRImage(306, i, "/", false);
                if (gr == null) continue;
                rootGroup.addToMemberList(gr);
            }
        }
        try {
            b = HDFLibrary.SDfileinfo((int)this.sdid, (int[])argv);
        }
        catch (HDFException ex) {
            b = false;
        }
        if (b) {
            n = argv[0];
            for (int i = 0; i < n; ++i) {
                H4SDS sds = this.getSDS(720, i, "/", false);
                if (sds == null) continue;
                rootGroup.addToMemberList(sds);
            }
        }
        try {
            n = HDFLibrary.VSlone((int)this.fid, (int[])tmpN, (int)0);
            refs = new int[n];
            n = HDFLibrary.VSlone((int)this.fid, (int[])refs, (int)n);
        }
        catch (HDFException ex) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            ref = refs[i];
            H4Vdata vdata = this.getVdata(1963, ref, "/", false);
            if (vdata == null) continue;
            rootGroup.addToMemberList(vdata);
        }
        if (rootGroup != null) {
            List attributeList = null;
            try {
                attributeList = rootGroup.getMetadata();
            }
            catch (HDFException ex) {
                // empty catch block
            }
            if (attributeList != null) {
                try {
                    this.getFileAnnotation(this.fid, attributeList);
                }
                catch (HDFException ex) {
                    // empty catch block
                }
                try {
                    this.getGRglobleAttribute(this.grid, attributeList);
                }
                catch (HDFException ex) {
                    // empty catch block
                }
                try {
                    this.getSDSglobleAttribute(this.sdid, attributeList);
                }
                catch (HDFException ex) {
                    // empty catch block
                }
            }
        }
        return rootGroup;
    }

    private HObject getAttachedObject(String path, String name) {
        if (name == null || name.length() <= 0) {
            return null;
        }
        HObject obj = null;
        String[] objName = new String[]{""};
        int idx = -1;
        try {
            idx = HDFLibrary.GRnametoindex((int)this.grid, (String)name);
        }
        catch (HDFException ex) {
            idx = -1;
        }
        if (idx >= 0) {
            return this.getGRImage(306, idx, "/", false);
        }
        try {
            idx = HDFLibrary.SDnametoindex((int)this.sdid, (String)name);
        }
        catch (HDFException ex) {
            idx = -1;
        }
        if (idx >= 0) {
            return this.getSDS(720, idx, "/", false);
        }
        int ref = 0;
        try {
            ref = HDFLibrary.Vfind((int)this.fid, (String)name);
        }
        catch (HDFException ex) {
            ref = -1;
        }
        if (ref > 0) {
            long[] oid = new long[]{1965L, ref};
            H4Group g = new H4Group(this, objName[0], path, null, oid);
            this.depth_first(null, g);
            return g;
        }
        try {
            ref = HDFLibrary.VSfind((int)this.fid, (String)name);
        }
        catch (HDFException ex) {
            ref = -1;
        }
        if (ref > 0) {
            return this.getVdata(1963, ref, "/", false);
        }
        return obj;
    }

    static {
        HDFLibrary.loadH4Lib();
    }
}

