/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class H5Group
extends Group {
    private static final long serialVersionUID = -951164512330444150L;
    protected List attributeList;
    private int nAttributes = -1;
    private H5O_info_t obj_info;

    public H5Group(FileFormat theFile, String name, String path, Group parent) {
        this(theFile, name, path, parent, null);
    }

    @Deprecated
    public H5Group(FileFormat theFile, String name, String path, Group parent, long[] oid) {
        super(theFile, name, path, parent, oid);
        this.nMembersInFile = -1;
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (oid == null && theFile != null) {
            try {
                byte[] ref_buf = H5.H5Rcreate((int)theFile.getFID(), (String)this.getFullName(), (int)HDF5Constants.H5R_OBJECT, (int)-1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong((byte[])ref_buf, (int)0);
            }
            catch (Exception ex) {
                this.oid = new long[1];
                this.oid[0] = 0L;
            }
        }
    }

    @Override
    public boolean hasAttribute() {
        int gid;
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L && (gid = this.open()) > 0) {
            try {
                this.obj_info = H5.H5Oget_info((int)gid);
            }
            catch (Exception ex) {
                this.obj_info.num_attrs = 0L;
            }
            this.close(gid);
        }
        return this.obj_info.num_attrs > 0L;
    }

    @Override
    public int getNumberOfMembersInFile() {
        int gid;
        if (this.nMembersInFile < 0 && (gid = this.open()) > 0) {
            try {
                H5G_info_t group_info = null;
                group_info = H5.H5Gget_info((int)gid);
                this.nMembersInFile = (int)group_info.nlinks;
            }
            catch (Exception ex) {
                this.nMembersInFile = 0;
            }
            this.close(gid);
        }
        return this.nMembersInFile;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata(int ... attrPropList) throws HDF5Exception {
        if (this.attributeList == null) {
            int gid = this.open();
            int indxType = HDF5Constants.H5_INDEX_NAME;
            int order = HDF5Constants.H5_ITER_INC;
            if (attrPropList.length > 0) {
                indxType = attrPropList[0];
                if (attrPropList.length > 1) {
                    order = attrPropList[1];
                }
            }
            try {
                this.attributeList = H5File.getAttribute(gid, indxType, order);
            }
            finally {
                this.close(gid);
            }
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        boolean attrExisted = false;
        Attribute attr = (Attribute)info;
        String name = attr.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            attrExisted = this.attributeList.contains(attr);
        }
        this.getFileFormat().writeAttribute(this, attr, attrExisted);
        if (!attrExisted) {
            this.attributeList.add(attr);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object info) throws HDF5Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        Attribute attr = (Attribute)info;
        int gid = this.open();
        try {
            H5.H5Adelete((int)gid, (String)attr.getName());
            List attrList = this.getMetadata();
            attrList.remove(attr);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(gid);
        }
    }

    @Override
    public int open() {
        int gid = -1;
        try {
            gid = this.isRoot() ? H5.H5Gopen((int)this.getFID(), (String)"/", (int)HDF5Constants.H5P_DEFAULT) : H5.H5Gopen((int)this.getFID(), (String)(this.getPath() + this.getName()), (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception ex) {
            gid = -1;
        }
        return gid;
    }

    @Override
    public void close(int gid) {
        try {
            H5.H5Gclose((int)gid);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    public static H5Group create(String name, Group pgroup, int ... gplist) throws Exception {
        H5Group group = null;
        String fullPath = null;
        int lcpl = HDF5Constants.H5P_DEFAULT;
        int gcpl = HDF5Constants.H5P_DEFAULT;
        int gapl = HDF5Constants.H5P_DEFAULT;
        if (gplist.length > 0) {
            lcpl = gplist[0];
            if (gplist.length > 1) {
                gcpl = gplist[1];
                if (gplist.length > 2) {
                    gapl = gplist[2];
                }
            }
        }
        if (name == null) {
            return null;
        }
        H5File file = (H5File)pgroup.getFileFormat();
        if (file == null) {
            return null;
        }
        if (pgroup == null) {
            pgroup = (Group)file.get("/");
        }
        String path = "/";
        if (!pgroup.isRoot()) {
            int idx;
            path = pgroup.getPath() + pgroup.getName() + "/";
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if ((idx = name.lastIndexOf("/")) >= 0) {
                name = name.substring(idx + 1);
            }
        }
        fullPath = path + name;
        int gid = H5.H5Gcreate((int)file.open(), (String)fullPath, (int)lcpl, (int)gcpl, (int)gapl);
        try {
            H5.H5Gclose((int)gid);
        }
        catch (Exception ex) {
            // empty catch block
        }
        byte[] ref_buf = H5.H5Rcreate((int)file.open(), (String)fullPath, (int)HDF5Constants.H5R_OBJECT, (int)-1);
        long l = HDFNativeData.byteToLong((byte[])ref_buf, (int)0);
        long[] oid = new long[]{l};
        group = new H5Group(file, name, path, pgroup, oid);
        if (group != null) {
            pgroup.addToMemberList(group);
        }
        if (gcpl > 0) {
            try {
                H5.H5Pclose((int)gcpl);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return group;
    }

    @Override
    public void setName(String newName) throws Exception {
        H5File.renameObject(this, newName);
        super.setName(newName);
    }

    @Override
    public void setPath(String newPath) throws Exception {
        super.setPath(newPath);
        List<HObject> members = this.getMemberList();
        if (members == null) {
            return;
        }
        int n = members.size();
        HObject obj = null;
        for (int i = 0; i < n; ++i) {
            obj = members.get(i);
            obj.setPath(this.getPath() + this.getName() + "/");
        }
    }
}

