/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import org.apache.commons.io.IOUtils;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.io.util.IOUtil;

public class GeneeExtensionManager {
    private static final GeneeExtensionManager instance = new GeneeExtensionManager();
    private ClassLoader classLoader;
    private List<ExtensionHolder> installedExtensions = new ArrayList<ExtensionHolder>();
    private String url = "https://software.broadinstitute.org/GENE-E/extensions/";

    private GeneeExtensionManager() {
        File[] jars;
        System.setSecurityManager(null);
        File pluginRootDir = new File(Application.getGENEEDir(), "extensions");
        if (!pluginRootDir.exists()) {
            pluginRootDir.mkdirs();
        }
        if ((jars = pluginRootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".jar");
            }
        })) != null) {
            try {
                for (File jar : jars) {
                    this.update(jar);
                }
                this.classLoader = this.createClassLoader(jars);
                for (File jar : jars) {
                    this.loadPluginJar(jar);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void install(JMenuBar menuBar, JToolBar toolBar) {
        for (ExtensionHolder holder : this.installedExtensions) {
            Class<?> c = holder.plugin;
            try {
                Method m = c.getMethod("install", JMenuBar.class, JToolBar.class);
                m.setAccessible(true);
                m.invoke(null, menuBar, toolBar);
            }
            catch (Throwable x) {
                System.err.println("Unable to create extension " + holder.name);
            }
        }
    }

    public Map<String, ExtensionHolder> listFromWeb() {
        HashMap<String, ExtensionHolder> map = new HashMap<String, ExtensionHolder>();
        try {
            String[] lines;
            String text = IOUtils.toString((URL)new URL(this.url));
            for (String line : lines = text.split("\n")) {
                if (line.equals("")) continue;
                int index = line.indexOf(61);
                String name = line.substring(0, index);
                String desc = line.substring(index + 1);
                int index2 = desc.indexOf(58);
                String version = desc.substring(0, index2);
                desc = desc.substring(index2 + 1);
                map.put(name, new ExtensionHolder(null, version, name, desc));
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        return map;
    }

    private ClassLoader createClassLoader(File[] files) throws Exception {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            URL url;
            String path = "jar:file:" + IOUtil.getPath(files[i]) + "!/";
            urls[i] = url = new URL(path);
        }
        ClassLoader loader = this.getClass().getClassLoader();
        return new URLClassLoader(urls, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(File jar) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String version = attrs.getValue("GENE-E-App-Version");
            String name = attrs.getValue("GENE-E-App-Name");
            try {
                boolean isOutOfDate;
                String webVersionString = IOUtil.getUrl(new URL(this.url + name + "/version")).trim();
                int webMajor = Integer.parseInt(webVersionString.substring(0, webVersionString.indexOf(46)));
                int webMinor = Integer.parseInt(webVersionString.substring(webVersionString.indexOf(46) + 1));
                int idx = version.indexOf(46);
                int major = 0;
                int minor = 0;
                if (idx != -1) {
                    major = Integer.parseInt(version.substring(0, version.indexOf(46)));
                    minor = Integer.parseInt(version.substring(version.indexOf(46) + 1));
                } else {
                    major = Integer.parseInt(version);
                }
                boolean bl = isOutOfDate = webMajor > major || webMajor == major && webMinor > minor;
                if (isOutOfDate) {
                    System.out.println("updating " + name);
                    File pluginRootDir = new File(Application.getGENEEDir(), "extensions");
                    jarFile.close();
                    if (!jar.delete()) {
                        System.out.println("unable to delete jar");
                    }
                    File destFile = new File(pluginRootDir, jar.getName());
                    IOUtil.download(this.url + jar.getName(), destFile);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginJar(File jar) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Manifest manifest = jarFile.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String version = attrs.getValue("GENE-E-App-Version");
            String name = attrs.getValue("GENE-E-App-Name");
            String main = attrs.getValue("GENE-E-App");
            if (main != null) {
                Class<?> plugin = this.classLoader.loadClass(main);
                this.installedExtensions.add(new ExtensionHolder(plugin, version, name, null));
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static GeneeExtensionManager getInstance() {
        return instance;
    }

    private static class ExtensionHolder {
        String desc;
        String name;
        Class<?> plugin;
        String version;

        public ExtensionHolder(Class<?> plugin, String version, String name, String desc) {
            this.plugin = plugin;
            this.version = version;
            this.name = name;
            this.desc = desc;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((ExtensionHolder)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

