/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import com.google.common.base.Function;
import java.awt.Font;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.HistoryAuditTrail;
import org.broadinstitute.genee.application.HistoryParameter;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;

public class HistoryPanel
extends JPanel {
    public HistoryPanel(ViewableGENEETreeNode node, boolean includeBuildInfo, Function<ProjectGENEEResultTreeNode, Boolean> goToOperationAction) {
        boolean showParameters = true;
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        FormBuilder builder = new FormBuilder(this);
        builder.setIndentedBorder();
        HistoryAuditTrail auditTrail = node.getAuditTrail();
        List<History> trail = auditTrail.getTrail();
        for (int i = 0; i < trail.size(); ++i) {
            History t = trail.get(i);
            JLabel operationComponent = new JLabel(i + 1 + ". " + t.getOperationName());
            List<HistoryParameter> params = t.getParameters();
            builder.nextRow();
            builder.addSpanned(operationComponent);
            if (!showParameters) continue;
            for (HistoryParameter entry : params) {
                builder.nextRow();
                String name = entry.getKey();
                String value = entry.getValue();
                if (value != null) {
                    builder.addLabel("    " + name + ":");
                    builder.add(new JLabel(value));
                    continue;
                }
                builder.addLabel("    " + name);
            }
        }
        Application.Version version = includeBuildInfo ? Application.getVersion() : null;
        builder.nextRow();
        builder.nextRow();
        if (version != null) {
            builder.addSpanned(new JLabel(Application.getName() + " " + version.versionString));
            builder.nextRow();
            builder.addSpanned(new JLabel("Built " + version.date));
        }
    }

    public static String toString(ViewableGENEETreeNode node, Application.Version version) {
        StringBuilder buf = new StringBuilder();
        if (version != null) {
            buf.append(Application.getName());
            buf.append(" ");
            buf.append(version.versionString);
            buf.append("\n");
            buf.append("Built ");
            buf.append(version.date);
            buf.append("\n");
        }
        HistoryAuditTrail auditTrail = node.getAuditTrail();
        List<History> trail = auditTrail.getTrail();
        int i = trail.size() - 1;
        int n = 1;
        while (i >= 0) {
            History t = trail.get(i);
            if (t != null) {
                buf.append(n + ". " + t.getOperationName());
                buf.append("\n");
                List<HistoryParameter> params = t.getParameters();
                for (HistoryParameter entry : params) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    buf.append(name);
                    if (value != null) {
                        buf.append(": " + value);
                    }
                    buf.append("\n");
                }
            }
            --i;
            ++n;
        }
        return buf.toString();
    }
}

