/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.category.ColorPanel;
import org.broadinstitute.genee.gui.TableToolTip;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultSizesAndPositions;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class RowColorPanel
extends ColorPanel
implements TableToolTip {
    private int leftBorder = 2;
    private MetadataModel metadata;
    private Project project;
    private ProjectListener projectListener = new ProjectListener(){

        @Override
        public void projectChanged(ProjectEvent e) {
            boolean vis;
            RowColorPanel.this.dataset = RowColorPanel.this.project.getSortedFilteredDataset();
            RowColorPanel.this.metadata = MetadataUtil.filter(RowColorPanel.this.dataset.getRowMetadata(), "Color Visible");
            boolean bl = vis = RowColorPanel.this.metadata.getMetadataCount() > 0;
            if (RowColorPanel.this.isVisible() != vis) {
                RowColorPanel.this.setVisible(vis);
            }
            RowColorPanel.this.revalidate();
            RowColorPanel.this.repaint();
        }
    };
    private Dataset dataset;

    @Override
    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip(this);
        this.setProject(this.project);
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        if (this.metadata == null) {
            return;
        }
        int rowIndexStart = 0;
        int rowIndexEnd = this.metadata.getItemCount();
        if (clip != null) {
            rowIndexStart = Math.max(this.sizesAndPositions.getIndex(clip.y, false) - 1, 0);
            rowIndexEnd = Math.min(this.sizesAndPositions.getIndex(clip.y + clip.height, false) + 1, this.metadata.getItemCount());
        }
        if (rowIndexStart > rowIndexEnd) {
            int tmp = rowIndexStart;
            rowIndexStart = rowIndexEnd;
            rowIndexEnd = tmp;
        }
        int metadataCount = this.metadata.getMetadataCount();
        int x = this.leftBorder;
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float rect = new Rectangle2D.Float();
        float pixHeight = this.sizesAndPositions.getSize();
        for (int i = 0; i < metadataCount; ++i) {
            Vector v = this.metadata.get(i);
            for (int rowIndex = rowIndexStart; rowIndex < rowIndexEnd; ++rowIndex) {
                Object value = v.getValue(rowIndex);
                Color c = (Color)this.categoryColorModel.getMappedValue(v, value);
                float y = this.sizesAndPositions.getPosition(rowIndex);
                if (c != null) {
                    g.setColor(c);
                    rect.setRect(x, y, this.categorySize, pixHeight);
                    if (pixHeight <= 1.0f) {
                        g2.draw(rect);
                    } else {
                        g2.fill(rect);
                    }
                }
                if (!this.gridVisible || this.categorySize <= 3 || !(pixHeight > 3.0f)) continue;
                g.setColor(Color.GRAY);
                rect.setRect(x, y, this.categorySize, pixHeight);
                g2.draw(rect);
            }
            x += this.categorySize;
        }
    }

    @Override
    public Dimension getDrawableSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width += 4;
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public MetadataModel getMetadata() {
        return this.metadata;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        preferredSize.width = this.metadata.getMetadataCount() == 0 ? 0 : this.metadata.getMetadataCount() * this.categorySize + this.leftBorder + 1;
        preferredSize.height = HeatMapPanel.getSize(this.sizesAndPositions);
        return preferredSize;
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public List<Map.Entry> getTableToolTipText(MouseEvent e) {
        int[] indices = DefaultSizesAndPositions.getIndices(this.sizesAndPositions, e.getPoint().y);
        String metadataName = this.metadata.getColumnName(this.getMetadataIndex(e));
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>();
        for (int index : indices) {
            entries.addAll(DatasetUtil.getToolTipText(this.dataset, index, -1, metadataName, null));
        }
        return entries;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw(g, g.getClipBounds());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip(this);
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addProjectListener(this.projectListener);
            this.projectListener.projectChanged(null);
        }
    }

    private int getMetadataIndex(MouseEvent e) {
        int index = (int)Math.ceil(e.getPoint().x / this.categorySize);
        index = Math.max(index, 0);
        index = Math.min(index, this.metadata.getMetadataCount() - 1);
        return index;
    }
}

