/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.broadinstitute.genee.category.AbstractVectorVisualMapper;
import org.broadinstitute.genee.category.VectorVisualMapperEvent;
import org.broadinstitute.genee.matrix.Vector;

public class VectorShapeModel
extends AbstractVectorVisualMapper<Integer> {
    private Map<String, Map<Object, Integer>> userSetVectorToValueToShapeIndex = new HashMap<String, Map<Object, Integer>>();
    private Map<Object, Integer> valueToIndex;
    private boolean autoUpdateShapes = false;
    private int maxIndex = 0;

    @Override
    public Integer getMappedValue(Vector vector, Object value) {
        Integer index;
        Map<Object, Integer> userSetValueToIndex = this.userSetVectorToValueToShapeIndex.get(vector.getName());
        if (userSetValueToIndex != null && (index = userSetValueToIndex.get(value)) != null) {
            return index;
        }
        if (this.autoUpdateShapes && (index = this.valueToIndex.get(value)) == null) {
            this.valueToIndex.put(value, this.maxIndex++);
        }
        return this.valueToIndex == null ? 0 : this.valueToIndex.get(value);
    }

    public void setAutoUpdateShapes(boolean autoUpdateShapes) {
        this.autoUpdateShapes = autoUpdateShapes;
        this.valueToIndex = new HashMap<Object, Integer>();
        this.maxIndex = 0;
    }

    @Override
    public void setMappedValue(Vector vector, Object value, Integer mappedValue) {
        Map<Object, Integer> vectorToShapeToIndex = this.userSetVectorToValueToShapeIndex.get(vector.getName());
        if (vectorToShapeToIndex == null) {
            vectorToShapeToIndex = new HashMap<Object, Integer>();
            this.userSetVectorToValueToShapeIndex.put(vector.getName(), vectorToShapeToIndex);
        }
        vectorToShapeToIndex.put(value, mappedValue);
        this.fireVectorVisualMapperListenerChanged(new VectorVisualMapperEvent(this));
    }

    public void setVector(Vector vector) {
        if (vector != null) {
            int i;
            this.valueToIndex = vector.getComparator() != null ? new TreeMap(vector.getComparator()) : new HashMap();
            int size = vector.size();
            for (i = 0; i < size; ++i) {
                Object value = vector.getValue(i);
                this.valueToIndex.put(value, 0);
            }
            i = 0;
            for (Object value : this.valueToIndex.keySet()) {
                this.valueToIndex.put(value, i++);
            }
        } else {
            this.valueToIndex = null;
        }
    }
}

