/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.chart.BoxPlotChartDataset;
import org.broadinstitute.genee.chart.ChartToolTipProvider;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.io.util.Formatter;

public class BoxPlotToolTipProvider
implements ChartToolTipProvider {
    @Override
    public List<Map.Entry> getToolTipText(XYChartDataset chartDataset, int seriesIndex, int itemIndex) {
        BoxPlotChartDataset dataset = (BoxPlotChartDataset)chartDataset;
        ArrayList<Map.Entry> tips = new ArrayList<Map.Entry>();
        tips.add(new BasicMapEntry<String>("UAV", Formatter.format(dataset.getUpperAdjacentValue(seriesIndex, itemIndex))));
        tips.add(new BasicMapEntry<String>("Q3", Formatter.format(dataset.getQ3(seriesIndex, itemIndex))));
        tips.add(new BasicMapEntry<String>("Median", Formatter.format(dataset.getMedian(seriesIndex, itemIndex))));
        tips.add(new BasicMapEntry<String>("Mean", Formatter.format(dataset.getMean(seriesIndex, itemIndex))));
        tips.add(new BasicMapEntry<String>("Q1", Formatter.format(dataset.getQ1(seriesIndex, itemIndex))));
        tips.add(new BasicMapEntry<String>("LAV", Formatter.format(dataset.getLowerAdjacentValue(seriesIndex, itemIndex))));
        tips.add(new BasicMapEntry<String>("Min", Formatter.format(dataset.getMin(seriesIndex, itemIndex))));
        tips.add(new BasicMapEntry<String>("Max", Formatter.format(dataset.getMax(seriesIndex, itemIndex))));
        int noutliers = dataset.getUpperOutliers(seriesIndex, itemIndex).size() + dataset.getLowerOutliers(seriesIndex, itemIndex).size();
        tips.add(new BasicMapEntry<String>("# of outliers", "" + noutliers));
        return tips;
    }
}

