/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ChartSelectionModel {
    private Map<Integer, Multimap<Integer, Integer>> datasetToSeriesToItems = new HashMap<Integer, Multimap<Integer, Integer>>();

    public void add(int dataset, int series, int item) {
        HashMultimap seriesToItem = this.datasetToSeriesToItems.get(dataset);
        if (seriesToItem == null) {
            seriesToItem = HashMultimap.create();
            this.datasetToSeriesToItems.put(dataset, (Multimap<Integer, Integer>)seriesToItem);
        }
        seriesToItem.put((Object)series, (Object)item);
    }

    public void clear() {
        for (Integer dataset : this.datasetToSeriesToItems.keySet()) {
            Multimap<Integer, Integer> seriesToItem = this.datasetToSeriesToItems.get(dataset);
            seriesToItem.clear();
        }
        this.datasetToSeriesToItems.clear();
    }

    public Collection<Integer> getSelectedItems(int dataset, int series) {
        Multimap<Integer, Integer> seriesToItem = this.datasetToSeriesToItems.get(dataset);
        if (seriesToItem == null) {
            return Collections.emptyList();
        }
        Collection items = seriesToItem.get((Object)series);
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    public Collection<Integer> getSelectedSeries(int dataset) {
        Multimap<Integer, Integer> seriesToItem = this.datasetToSeriesToItems.get(dataset);
        if (seriesToItem == null) {
            return Collections.emptyList();
        }
        return seriesToItem.keySet();
    }

    public boolean isEmpty() {
        return this.datasetToSeriesToItems.size() == 0;
    }

    public boolean isSelected(int dataset, int series, int item) {
        Multimap<Integer, Integer> seriesToItem = this.datasetToSeriesToItems.get(dataset);
        if (seriesToItem == null) {
            return false;
        }
        if (seriesToItem.containsKey((Object)-1)) {
            return true;
        }
        Collection items = seriesToItem.get((Object)series);
        if (items == null) {
            return false;
        }
        if (items.contains(-1)) {
            return true;
        }
        return items.contains(item);
    }

    public boolean remove(int dataset, int series, int item) {
        Multimap<Integer, Integer> seriesToItem = this.datasetToSeriesToItems.get(dataset);
        boolean ret = false;
        if (seriesToItem != null) {
            ret = seriesToItem.remove((Object)series, (Object)item);
        }
        ret = ret || this.datasetToSeriesToItems.remove(dataset) != null;
        return ret;
    }

    public String toString() {
        return this.datasetToSeriesToItems.toString();
    }
}

