/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.Color;
import org.broadinstitute.genee.category.VectorVisualMapper;
import org.broadinstitute.genee.chart.ColorByChartLegend;
import org.broadinstitute.genee.chart.ColorSizeShapeAttribute;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.Vector;

public abstract class ColorBy
extends ColorSizeShapeAttribute {
    private Highlighter highlighter = new Highlighter(){

        @Override
        protected void notifyChanged() {
            ColorBy.this.notifyHighlighterChanged();
        }
    };

    public ColorBy() {
        this.legend = new ColorByChartLegend(this.highlighter);
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    @Override
    public void setVector(OrientedVector v) {
        if (v != this.vector) {
            this.vector = v;
            this.highlighter.clearHighlighted(false);
        }
    }

    @Override
    public void updateLegend() {
        Vector vectorInSelectedIndicesSpace = this.getVectorInSelectedIndicesSpace(this.vector);
        if (vectorInSelectedIndicesSpace != null) {
            VectorVisualMapper<Color> visualMapper = this.getVisualMapper(this.vector.isRowVector());
            this.legend.setVectorVisualMapper(visualMapper);
            this.legend.setVector(vectorInSelectedIndicesSpace);
        } else {
            this.legend.setVector(null);
        }
    }

    protected abstract VectorVisualMapper<Color> getVisualMapper(boolean var1);
}

