/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Icon;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.AbstractLegend;
import org.broadinstitute.genee.gui.ColorByIcon;
import org.broadinstitute.genee.gui.Highlighter;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeLegend;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class ColorByChartLegend
extends AbstractLegend {
    public ColorByChartLegend(Highlighter chartHighlighter) {
        super(chartHighlighter);
    }

    @Override
    public void createLegend() {
        if (this.vector != null && MetadataUtil.getBoolean(this.vector, "Continuous Key")) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            HeatMapColorScheme colorScheme = ((VectorColorModel)this.visualMapper).getContinuousColorScheme(this.vector);
            HeatMapColorSchemeLegend legend = (HeatMapColorSchemeLegend)colorScheme.getLegend();
            legend.setPreferredSize(new Dimension(200, 100));
            legend.setMinimumSize(new Dimension());
            legend.setScalingStringVisible(false);
            this.add(legend);
        } else {
            super.createLegend();
        }
    }

    @Override
    protected Icon createIcon(Object value) {
        Color c = (Color)this.visualMapper.getMappedValue(this.vector, value);
        return new ColorByIcon(c);
    }

    @Override
    protected void showEditDialog(Object value) {
        Color color = UIUtil.showColorDialog(this.getComponentPopupMenu(), Formatter.toString(value) + " Color", (Color)this.visualMapper.getMappedValue(this.vector, value));
        if (color != null) {
            this.visualMapper.setMappedValue(this.vector, value, color);
        }
    }
}

