/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import gnu.trove.list.array.TFloatArrayList;
import org.broadinstitute.genee.chart.HistogramChartSeries;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.math.adjust.LogScaleUnivariateFunction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.TroveFloatList;

public class DefaultHistogramChartSeries
implements HistogramChartSeries {
    public static final int NaN_BIN = -2147483647;
    private int[] binNumberToOccurences;
    private float binSize = 1.0f;
    private String name;
    private float xmax;
    private float xmin;
    private int ymax;
    private boolean normalizedToOne = false;
    private long totalNumberOfOccurences;

    public DefaultHistogramChartSeries(String name, int numberOfBins, float histogramMin, float histogramMax) {
        this.name = name;
        this.ymax = -2147483647;
        if (histogramMax == histogramMin) {
            histogramMin -= 0.5f;
            histogramMax += 0.5f;
        }
        this.xmax = histogramMax;
        this.xmin = histogramMin;
        numberOfBins = Math.max(numberOfBins, 1);
        this.binSize = (this.xmax - this.xmin) / (float)numberOfBins;
        this.binNumberToOccurences = new int[numberOfBins];
    }

    @Override
    public float getBinSize() {
        return this.binSize;
    }

    @Override
    public int getItemCount() {
        return this.binNumberToOccurences.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getX(int index) {
        return this.xmin + (float)index * this.binSize;
    }

    @Override
    public float getXEnd(int index) {
        return this.xmin + (float)index * this.binSize + this.binSize;
    }

    @Override
    public float getXMax() {
        return this.xmax + this.binSize;
    }

    @Override
    public float getXMin() {
        return this.xmin;
    }

    @Override
    public float getXStart(int index) {
        return this.xmin + (float)index * this.binSize;
    }

    @Override
    public float getY(int index) {
        float val = this.binNumberToOccurences[index];
        return this.normalizedToOne ? val / (float)this.totalNumberOfOccurences : val;
    }

    @Override
    public float getYEnd(int index) {
        return this.getY(index);
    }

    @Override
    public float getYMax() {
        return this.ymax;
    }

    @Override
    public float getYMin() {
        return 0.0f;
    }

    @Override
    public float getYStart(int index) {
        return 0.0f;
    }

    public void setNormalizedToOne(boolean normalizedToOne) {
        this.normalizedToOne = normalizedToOne;
        if (normalizedToOne) {
            this.totalNumberOfOccurences = 0L;
            int length = this.binNumberToOccurences.length;
            for (int i = 0; i < length; ++i) {
                this.totalNumberOfOccurences += (long)this.binNumberToOccurences[i];
            }
        }
    }

    public int getBinForValue(float value) {
        int bin = (int)((value - this.xmin) / this.binSize);
        if (bin < 0) {
            bin = 0;
        } else if (bin >= this.binNumberToOccurences.length) {
            bin = this.binNumberToOccurences.length - 1;
        }
        return bin;
    }

    public static DefaultHistogramChartSeries createInstance(Dataset dataset, int numberOfBins, float histogramMin, float histogramMax) {
        if (Float.isNaN(histogramMin)) {
            histogramMin = DatasetUtil.min(dataset);
        }
        if (Float.isNaN(histogramMax)) {
            histogramMax = DatasetUtil.max(dataset);
        }
        DefaultHistogramChartSeries series = new DefaultHistogramChartSeries(dataset.getName(), numberOfBins, histogramMin, histogramMax);
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int columns = dataset.getColumnCount();
            for (int j = 0; j < columns; ++j) {
                float value = dataset.getValue(i, j);
                series.add(value);
            }
        }
        return series;
    }

    public void add(float value) {
        if (!Float.isNaN(value)) {
            int bin;
            int n = bin = this.getBinForValue(value);
            this.binNumberToOccurences[n] = this.binNumberToOccurences[n] + 1;
            this.ymax = Math.max(this.ymax, this.binNumberToOccurences[bin]);
        }
    }

    public static int getNumberOfBinsScotts(Dataset dataset) {
        TFloatArrayList bin = new TFloatArrayList();
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                float d = dataset.getValue(i, j);
                if (Float.isNaN(d)) continue;
                bin.add(d);
            }
        }
        float stdev = FloatListStatUtils.stdev(new TroveFloatList(bin));
        float h = (float)((double)(3.5f * stdev) / Math.pow(bin.size(), 0.3333333333333333));
        return (int)Math.ceil((bin.max() - bin.min()) / h);
    }

    public static int getNumberOfBinsSturges(int count) {
        return (int)Math.ceil(LogScaleUnivariateFunction.log2(count) + 1.0f);
    }
}

