/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import org.broadinstitute.genee.chart.AbstractChartRenderer;
import org.broadinstitute.genee.chart.ChartPropertiesSupplier;
import org.broadinstitute.genee.chart.DefaultChartPropertiesSupplier;
import org.broadinstitute.genee.chart.MultiYValueXYChartDataset;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.matrix.FloatList;

public class LineAndShapeRenderer
extends AbstractChartRenderer {
    public static final String LINES = "lines";
    public static final String POINTS = "points";
    public static final String POLYGONS = "polygons";
    private boolean lines = true;
    private boolean points = true;
    private boolean polygons = false;

    @Override
    public float getGutter() {
        return this.points ? this.chartPropertiesSupplier.getGutter() : 0.0f;
    }

    public boolean getProperty(String property) {
        if (LINES.equals(property)) {
            return this.lines;
        }
        if (POINTS.equals(property)) {
            return this.points;
        }
        if (POLYGONS.equals(property)) {
            return this.polygons;
        }
        return false;
    }

    @Override
    public void paint(XYChartDataset chartDataset, int datasetIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        if (this.lines) {
            int nseries = chartDataset.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                this.paintLines(g2, worldCoordinateMapper, chartDataset, datasetIndex, seriesIndex, this.points);
            }
        } else if (this.points) {
            int nseries = chartDataset.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                this.paintPoints(g2, worldCoordinateMapper, chartDataset, datasetIndex, seriesIndex);
            }
        } else if (this.polygons) {
            this.paintPolygons(chartDataset, datasetIndex, g2, worldCoordinateMapper);
        }
    }

    public void setProperty(String property, boolean visible) {
        if (LINES.equals(property)) {
            this.lines = visible;
        } else if (POINTS.equals(property)) {
            this.points = visible;
        } else if (POLYGONS.equals(property)) {
            this.polygons = visible;
        }
    }

    private void paintLines(Graphics2D g2, CoordinateMapper worldCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex, boolean paintPoints) {
        float ypix;
        float xpix;
        int itemIndex;
        if (chartDataset.getItemCount(seriesIndex) == 0) {
            return;
        }
        if (chartDataset.getItemCount(seriesIndex) == 1) {
            this.paintPoints(g2, worldCoordinateMapper, chartDataset, datasetIndex, seriesIndex);
            return;
        }
        Line2D.Float line = new Line2D.Float();
        Stroke seriesStroke = !paintPoints ? this.chartPropertiesSupplier.getSeriesStroke(chartDataset, datasetIndex, seriesIndex) : DefaultChartPropertiesSupplier.DEFAULT_STROKE;
        int nitems = chartDataset.getItemCount(seriesIndex) - 1;
        for (itemIndex = 0; itemIndex < nitems; ++itemIndex) {
            xpix = worldCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex));
            ypix = worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex));
            float xpixItemIndexPlusOne = worldCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex + 1));
            float ypixItemIndexPlusOne = worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex + 1));
            Color c = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex);
            Color colorIndexPlusOne = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex + 1);
            GradientPaint paint = new GradientPaint(xpix, ypix, c, xpixItemIndexPlusOne, ypixItemIndexPlusOne, colorIndexPlusOne);
            g2.setPaint(paint);
            if (!paintPoints && !this.chartPropertiesSupplier.isSizeBySeries()) {
                g2.setStroke(this.chartPropertiesSupplier.getItemStroke(chartDataset, datasetIndex, seriesIndex, itemIndex));
            } else {
                g2.setStroke(seriesStroke);
            }
            line.setLine(xpix, ypix, xpixItemIndexPlusOne, ypixItemIndexPlusOne);
            g2.draw(line);
            g2.setPaint(c);
            g2.setStroke(DefaultChartPropertiesSupplier.DEFAULT_STROKE);
            if (!paintPoints && !this.chartPropertiesSupplier.isSelected(chartDataset, datasetIndex, seriesIndex, itemIndex)) continue;
            LineAndShapeRenderer.paintSinglePoint(this.chartPropertiesSupplier, g2, xpix, ypix, chartDataset, datasetIndex, seriesIndex, itemIndex);
        }
        itemIndex = chartDataset.getItemCount(seriesIndex) - 1;
        if (paintPoints || this.chartPropertiesSupplier.isSelected(chartDataset, datasetIndex, seriesIndex, itemIndex)) {
            Color itemColor = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex);
            g2.setColor(itemColor);
            xpix = worldCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex));
            ypix = worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex));
            LineAndShapeRenderer.paintSinglePoint(this.chartPropertiesSupplier, g2, xpix, ypix, chartDataset, datasetIndex, seriesIndex, chartDataset.getItemCount(seriesIndex) - 1);
        }
    }

    private void paintPoints(Graphics2D g2, CoordinateMapper worldCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex) {
        int nitems = chartDataset.getItemCount(seriesIndex);
        for (int itemIndex = 0; itemIndex < nitems; ++itemIndex) {
            float x = chartDataset.getX(seriesIndex, itemIndex);
            float y = chartDataset.getY(seriesIndex, itemIndex);
            float xpix = worldCoordinateMapper.xToPix(x);
            float ypix = worldCoordinateMapper.yToPix(y);
            Color itemColor = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex);
            g2.setColor(itemColor);
            LineAndShapeRenderer.paintSinglePoint(this.chartPropertiesSupplier, g2, xpix, ypix, chartDataset, datasetIndex, seriesIndex, itemIndex);
        }
    }

    private void paintPolygons(XYChartDataset chartDataset, int datasetIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        Path2D.Float path = new Path2D.Float();
        g2.setStroke(new BasicStroke(1.0f));
        float zero = worldCoordinateMapper.yToPix(0.0f);
        Composite composite = g2.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.2f);
        g2.setComposite(chartDataset.getSeriesCount() > 1 ? ac : composite);
        int maxItemCount = chartDataset.getItemCount(0);
        float[] values = new float[chartDataset.getSeriesCount()];
        for (int itemIndex = 1; itemIndex < maxItemCount; ++itemIndex) {
            int[] seriesPaintOrderForItem = ChartUtil.getSeriesPaintOrder(chartDataset, itemIndex, values, false);
            int nseries = chartDataset.getSeriesCount();
            for (int seriesCounter = 0; seriesCounter < nseries; ++seriesCounter) {
                int seriesIndex = seriesPaintOrderForItem[seriesCounter];
                path.reset();
                Color c = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex - 1);
                g2.setColor(c);
                float xpix1 = worldCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex));
                float ypix1 = worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex));
                float xpix0 = worldCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex - 1));
                float ypix0 = worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex - 1));
                path.moveTo(xpix0, zero);
                path.lineTo(xpix0, ypix0);
                path.lineTo(xpix1, ypix1);
                path.lineTo(xpix1, zero);
                path.closePath();
                g2.draw(path);
                g2.fill(path);
            }
        }
        g2.setComposite(composite);
    }

    private void paintYPoints(Graphics2D g2, CoordinateMapper worldCoordinateMapper, MultiYValueXYChartDataset chartDataset, int datasetIndex, int seriesIndex) {
        int nitems = chartDataset.getItemCount(seriesIndex);
        for (int itemIndex = 0; itemIndex < nitems; ++itemIndex) {
            float xpix = worldCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex));
            FloatList ypoints = chartDataset.getYValues(seriesIndex, itemIndex);
            Color itemColor = this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex);
            g2.setColor(itemColor);
            int npoints = ypoints.size();
            for (int i = 0; i < npoints; ++i) {
                float ypix = worldCoordinateMapper.yToPix(ypoints.getValue(i));
                LineAndShapeRenderer.paintSinglePoint(this.chartPropertiesSupplier, g2, xpix, ypix, chartDataset, datasetIndex, seriesIndex, itemIndex);
            }
        }
    }

    public static void paintSinglePoint(ChartPropertiesSupplier chartPropertiesSupplier, Graphics2D g2, float xpix, float ypix, XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int itemIndex) {
        float pointSize = chartPropertiesSupplier.getItemSize(chartDataset, datasetIndex, seriesIndex, itemIndex);
        Shape originalShape = chartPropertiesSupplier.getItemShape(chartDataset, datasetIndex, seriesIndex, itemIndex, pointSize);
        AffineTransform transform = AffineTransform.getTranslateInstance(xpix - pointSize / 2.0f, ypix - pointSize / 2.0f);
        Shape shape = transform.createTransformedShape(originalShape);
        if (chartPropertiesSupplier.isSelected(chartDataset, datasetIndex, seriesIndex, itemIndex)) {
            Paint paint = g2.getPaint();
            Stroke stroke = g2.getStroke();
            g2.setColor(Color.BLACK);
            float drawPointSize = pointSize + 6.0f;
            Shape bigShape = chartPropertiesSupplier.getItemShape(chartDataset, datasetIndex, seriesIndex, itemIndex, drawPointSize);
            transform = AffineTransform.getTranslateInstance(xpix - drawPointSize / 2.0f, ypix - drawPointSize / 2.0f);
            Shape drawShape = transform.createTransformedShape(bigShape);
            g2.fill(drawShape);
            g2.setPaint(paint);
            g2.setStroke(stroke);
        }
        g2.fill(shape);
    }
}

