/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;

public class TransformedXYChartDataset
implements XYChartDataset {
    private XYChartDataset chartDataset;
    private UnivariateFloatFunction xFunction;
    private UnivariateFloatFunction yFunction;

    public TransformedXYChartDataset(XYChartDataset dataset, UnivariateFloatFunction xFunction, UnivariateFloatFunction yFunction) {
        this.chartDataset = dataset;
        this.xFunction = xFunction;
        this.yFunction = yFunction;
    }

    @Override
    public int getItemCount(int seriesIndex) {
        return this.chartDataset.getItemCount(seriesIndex);
    }

    @Override
    public float getX(int seriesIndex, int index) {
        return this.xFunction != null ? this.xFunction.evaluate(this.chartDataset.getX(seriesIndex, index)) : this.chartDataset.getX(seriesIndex, index);
    }

    @Override
    public float getY(int seriesIndex, int index) {
        return this.yFunction != null ? this.yFunction.evaluate(this.chartDataset.getY(seriesIndex, index)) : this.chartDataset.getY(seriesIndex, index);
    }

    @Override
    public float getYStart(int seriesIndex, int index) {
        return this.yFunction != null ? this.yFunction.evaluate(this.chartDataset.getYStart(seriesIndex, index)) : this.chartDataset.getYStart(seriesIndex, index);
    }

    @Override
    public float getYEnd(int seriesIndex, int index) {
        return this.yFunction != null ? this.yFunction.evaluate(this.chartDataset.getYEnd(seriesIndex, index)) : this.chartDataset.getYEnd(seriesIndex, index);
    }

    @Override
    public float getXStart(int seriesIndex, int index) {
        return this.chartDataset.getXStart(seriesIndex, index);
    }

    @Override
    public float getXEnd(int seriesIndex, int index) {
        return this.chartDataset.getXEnd(seriesIndex, index);
    }

    @Override
    public int getSeriesCount() {
        return this.chartDataset.getSeriesCount();
    }

    @Override
    public String getSeriesName(int series) {
        return this.chartDataset.getSeriesName(series);
    }

    @Override
    public float getXMax() {
        return this.xFunction != null ? this.xFunction.evaluate(this.chartDataset.getXMax()) : this.chartDataset.getXMax();
    }

    @Override
    public float getXMin() {
        return this.xFunction != null ? this.xFunction.evaluate(this.chartDataset.getXMin()) : this.chartDataset.getXMin();
    }

    @Override
    public float getYMax() {
        return this.yFunction != null ? this.yFunction.evaluate(this.chartDataset.getYMax()) : this.chartDataset.getYMax();
    }

    @Override
    public float getYMin() {
        return this.yFunction != null ? this.yFunction.evaluate(this.chartDataset.getYMin()) : this.chartDataset.getYMin();
    }

    @Override
    public float getXMax(int series) {
        return this.xFunction != null ? this.xFunction.evaluate(this.chartDataset.getXMax(series)) : this.chartDataset.getXMax(series);
    }

    @Override
    public float getXMin(int series) {
        return this.xFunction != null ? this.xFunction.evaluate(this.chartDataset.getXMin(series)) : this.chartDataset.getXMin(series);
    }

    @Override
    public float getYMax(int series) {
        return this.yFunction != null ? this.yFunction.evaluate(this.chartDataset.getYMax(series)) : this.chartDataset.getYMax(series);
    }

    @Override
    public float getYMin(int series) {
        return this.yFunction != null ? this.yFunction.evaluate(this.chartDataset.getYMin(series)) : this.chartDataset.getYMin(series);
    }
}

