/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import gnu.trove.list.array.TFloatArrayList;
import org.broadinstitute.genee.chart.DefaultXYChartSeries;

public class YIntervalXYChartSeries
extends DefaultXYChartSeries {
    protected TFloatArrayList yErrors;

    public YIntervalXYChartSeries(String seriesName, int size) {
        super(seriesName, size);
        this.yErrors = new TFloatArrayList(size);
    }

    @Override
    public void add(float x, float y) {
        super.add(x, y);
        this.yErrors.add(0.0f);
    }

    public void add(float x, float y, float yError) {
        float upper = y + yError;
        float lower = y - yError;
        if (!Float.isNaN(upper)) {
            this.ymax = Math.max(this.ymax, upper);
        }
        if (!Float.isNaN(lower)) {
            this.ymin = Math.min(this.ymin, lower);
        }
        if (!Float.isNaN(x)) {
            this.xmax = Math.max(this.xmax, x);
            this.xmin = Math.min(this.xmin, x);
        }
        this.xpoints.add(x);
        this.ypoints.add(y);
        this.yErrors.add(yError);
    }

    @Override
    public float getYEnd(int index) {
        float y = this.getY(index);
        return y + this.yErrors.getQuick(index);
    }

    @Override
    public float getYStart(int index) {
        float y = this.getY(index);
        return y - this.yErrors.getQuick(index);
    }
}

