/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import com.google.common.base.Function;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.category.VectorVisualMapperEvent;
import org.broadinstitute.genee.category.VectorVisualMapperListener;
import org.broadinstitute.genee.chart.Axis;
import org.broadinstitute.genee.chart.ChartChangeEvent;
import org.broadinstitute.genee.chart.ChartChangeListener;
import org.broadinstitute.genee.chart.ChartPropertiesSupplier;
import org.broadinstitute.genee.chart.ChartRenderer;
import org.broadinstitute.genee.chart.ColorBy;
import org.broadinstitute.genee.chart.DefaultChartPropertiesSupplier;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.ShapeBy;
import org.broadinstitute.genee.chart.SizeBy;
import org.broadinstitute.genee.chart.grid.BasicVectorDatasetValuesSupplier;
import org.broadinstitute.genee.chart.grid.ChartGridOptionsComponent;
import org.broadinstitute.genee.chart.grid.ChartMovieControlPanel;
import org.broadinstitute.genee.chart.grid.ChartTransition;
import org.broadinstitute.genee.chart.grid.ConvertToBoxplot;
import org.broadinstitute.genee.chart.grid.ConvertToChart;
import org.broadinstitute.genee.chart.grid.ConvertToHistogramChart;
import org.broadinstitute.genee.chart.grid.ConvertToProfileChart;
import org.broadinstitute.genee.chart.grid.ConvertToXYChart;
import org.broadinstitute.genee.chart.grid.DatasetGrid2D;
import org.broadinstitute.genee.chart.grid.ModelIndicesVector;
import org.broadinstitute.genee.gui.CartesianProductHeader;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.JideSplitPaneSynchronizer;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.grid.AttributesDragAndDropComponent;
import org.broadinstitute.genee.gui.grid.DropListPanel;
import org.broadinstitute.genee.heatmap.HeatMapToolBar;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.heatmap.menu.CopyImageAction;
import org.broadinstitute.genee.heatmap.menu.SaveImageAction;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.SlicedVector;
import org.broadinstitute.genee.matrix.TransformedDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class ChartGrid
implements GENEEWindowNotifier,
Drawable,
ChartChangeListener {
    public static final String BOXPLOT = "Boxplot";
    public static final String COLUMN_PROFILE = "Column Profile";
    public static final String COLUMN_XY_CHART = "Row XY Chart";
    public static final String CURVE_CHART = "Curve Chart";
    public static final String HISTOGRAM = "Histogram";
    public static final String ROW_PROFILE = "Row Profile";
    public static final String ROW_XY_CHART = "Column XY Chart";
    private static final String COLOR_DRAG_OWNER_NAME = "Color";
    private static final String SHAPE_DRAG_OWNER_NAME = "Shape";
    private static final String SIZE_DRAG_OWNER_NAME = "Size";
    private static final String X_AXIS_LABEL_DRAG_OWNER_NAME = "X Axis Label";
    protected Dataset modelDataset;
    protected Project project;
    private boolean animationRunning = false;
    private AttributesDragAndDropComponent attributesDragAndDropComponent;
    private float ceiling = Float.NaN;
    private boolean centroidChart;
    private int chartHeight = 400;
    private GENEEChart[][] chartMatrix = new GENEEChart[0][0];
    private ChartMovieControlPanel chartMovieControlPanel;
    private ChartGridOptionsComponent chartOptionsPanel;
    private JPanel chartPanelsHolder;
    private boolean chartPanelsValid = true;
    private JScrollPane chartScrollPane;
    private ChartTransition chartTransition;
    private String chartType;
    private int chartWidth = 300;
    private ColorBy colorBy;
    private DropListPanel colorByMarksPanel;
    private JPanel columnFooterPanel;
    private JPanel columnHeaderPanel;
    private SelectionListener columnSelectionListener;
    private ConvertToBoxplot convertToBoxplot = new ConvertToBoxplot();
    private ConvertToChart convertToChart;
    private ConvertToProfileChart convertToColumnProfileChart = new ConvertToProfileChart(false);
    private ConvertToChart convertToColumnXY = new ConvertToXYChart(true);
    private ConvertToHistogramChart convertToHistogramChart = new ConvertToHistogramChart();
    private ConvertToProfileChart convertToRowProfileChart = new ConvertToProfileChart(true);
    private ConvertToChart convertToRowXY = new ConvertToXYChart(false);
    private float customXMax = Float.NaN;
    private float customXMin = Float.NaN;
    private float customYMax = Float.NaN;
    private float customYMin = Float.NaN;
    private DatasetGrid2D datasetGrid2D;
    private Color defaultChartColor = QualitativeColorSchemes.getTenColor(0);
    private JideSplitPane dockableFramesAndChartSplitter;
    private float floor = Float.NaN;
    private boolean forcePreferredSize;
    private JideSplitPane headerChartsFooterVerticalSplitPane;
    private JComponent horizontalSplitPane;
    private boolean inverseLogScale;
    private JComponent[] legends;
    private boolean logScale;
    private JPanel mainChartComponent;
    private String noDataMessage = "Select rows and columns in the heat map";
    private ProjectListener projectListener;
    private boolean robustZScoreTransform;
    private CartesianProductHeader rowCartesianProductHeader;
    private JPanel rowHeaderPanel;
    private Class<?>[] rowsAndColumnsAcceptDropTypes;
    private SelectionListener rowSelectionListener;
    private ShapeBy shapeBy;
    private DropListPanel shapeByMarksPanel;
    private SizeBy sizeBy;
    private DropListPanel sizeByMarksPanel;
    private boolean synchronizeChartWithSelection = true;
    private boolean updateDividerLocation = true;
    private Function<Void, UpdateSelection> updateSelectedDatasetFunction;
    private boolean useMeanForCentroid = true;
    private VectorVisualMapperListener vectorVisualMapperListener;
    private Axis[] xAxes;
    private DropListPanel xAxisLabelPanel;
    private boolean xAxisVisible = true;
    private ScalingMode xMaxScaling = ScalingMode.GLOBAL;
    private ScalingMode xMinScaling = ScalingMode.GLOBAL;
    private Axis[] yAxes;
    private boolean yAxisVisible = true;
    private ScalingMode yMaxScaling = ScalingMode.GLOBAL;
    private ScalingMode yMinScaling = ScalingMode.GLOBAL;
    private boolean zScoreTransform;

    public ChartGrid(String chartType) {
        this(chartType, AttributesDragAndDropComponent.ACCEPT_DROP_TYPES);
    }

    public ChartGrid(String chartType, Class<?>[] rowsAndColumnsAcceptDropTypes) {
        this.chartType = chartType;
        this.updateSelectedDatasetFunction = new Function<Void, UpdateSelection>(){

            public UpdateSelection apply(Void v) {
                int[] selectedModelColumnIndices = ChartGrid.this.project.getModelColumnIndices(true, false);
                int[] selectedModelRowIndices = ChartGrid.this.project.getModelRowIndices(true, false);
                Dataset modelDataset = ChartGrid.this.project.getOriginalDataset();
                return new UpdateSelection(modelDataset, selectedModelRowIndices, selectedModelColumnIndices);
            }
        };
        this.rowsAndColumnsAcceptDropTypes = rowsAndColumnsAcceptDropTypes;
        this.colorBy = new ColorBy(){

            @Override
            protected Vector getVectorInSelectedIndicesSpace(OrientedVector vector) {
                return ChartGrid.this.getVectorInSelectedIndicesSpace(vector);
            }

            protected VectorColorModel getVisualMapper(boolean isRowVector) {
                return ChartGrid.this.getColorModel(isRowVector);
            }

            @Override
            protected void notifyHighlighterChanged() {
                ChartGrid.this.repaintCharts();
            }
        };
        this.sizeBy = new SizeBy(){

            @Override
            protected Vector getVectorInSelectedIndicesSpace(OrientedVector vector) {
                return ChartGrid.this.getVectorInSelectedIndicesSpace(vector);
            }

            @Override
            protected void notifyHighlighterChanged() {
                ChartGrid.this.repaintCharts();
            }
        };
        this.shapeBy = new ShapeBy(){

            @Override
            protected Vector getVectorInSelectedIndicesSpace(OrientedVector vector) {
                return ChartGrid.this.getVectorInSelectedIndicesSpace(vector);
            }

            @Override
            protected void notifyHighlighterChanged() {
                ChartGrid.this.repaintCharts();
            }
        };
        this.chartTransition = new ChartTransition(this);
        this.chartPanelsHolder = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.datasetGrid2D = new DatasetGrid2D();
        this.chartScrollPane = UIUtil.createNoBorderScrollPane(this.chartPanelsHolder);
        this.chartScrollPane.setHorizontalScrollBarPolicy(31);
        this.columnHeaderPanel = new JPanel();
        this.columnFooterPanel = new JPanel();
        this.columnFooterPanel.setMinimumSize(new Dimension());
        this.headerChartsFooterVerticalSplitPane = new JideSplitPane(0);
        JScrollPane columnHeaderScrollPane = UIUtil.createNoBorderScrollPane(this.columnHeaderPanel);
        columnHeaderScrollPane.getHorizontalScrollBar().setModel(this.chartScrollPane.getHorizontalScrollBar().getModel());
        columnHeaderScrollPane.setHorizontalScrollBarPolicy(31);
        columnHeaderScrollPane.setVerticalScrollBarPolicy(21);
        columnHeaderScrollPane.setMinimumSize(new Dimension());
        this.headerChartsFooterVerticalSplitPane.addPane((Component)columnHeaderScrollPane);
        this.headerChartsFooterVerticalSplitPane.addPane((Component)this.chartScrollPane);
        JScrollPane columnFooterScrollPane = UIUtil.createNoBorderScrollPane(this.columnFooterPanel);
        columnFooterScrollPane.getHorizontalScrollBar().setModel(this.chartScrollPane.getHorizontalScrollBar().getModel());
        columnFooterScrollPane.setVerticalScrollBarPolicy(21);
        columnFooterScrollPane.setHorizontalScrollBarPolicy(30);
        columnFooterScrollPane.setMinimumSize(new Dimension());
        this.headerChartsFooterVerticalSplitPane.addPane((Component)columnFooterScrollPane);
        this.rowHeaderPanel = new JPanel();
        this.rowHeaderPanel.setMinimumSize(new Dimension());
        JideSplitPane leftVerticalSplitPane = new JideSplitPane(0);
        leftVerticalSplitPane.addPane((Component)new JPanel());
        JScrollPane rowHeaderScrollPane = UIUtil.createNoBorderScrollPane(this.rowHeaderPanel);
        rowHeaderScrollPane.setHorizontalScrollBarPolicy(31);
        rowHeaderScrollPane.setVerticalScrollBarPolicy(21);
        rowHeaderScrollPane.getVerticalScrollBar().setModel(this.chartScrollPane.getVerticalScrollBar().getModel());
        rowHeaderScrollPane.setMinimumSize(new Dimension());
        leftVerticalSplitPane.addPane((Component)rowHeaderScrollPane);
        leftVerticalSplitPane.addPane((Component)new JPanel());
        leftVerticalSplitPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.horizontalSplitPane = new JideSplitPane(1);
        this.horizontalSplitPane.add((Component)leftVerticalSplitPane);
        this.horizontalSplitPane.add((Component)this.headerChartsFooterVerticalSplitPane, "vary");
        new JideSplitPaneSynchronizer(this.headerChartsFooterVerticalSplitPane, leftVerticalSplitPane);
        this.project = Application.getProject();
        this.vectorVisualMapperListener = new VectorVisualMapperListener(){

            @Override
            public void mappingChanged(VectorVisualMapperEvent e) {
                ChartGrid.this.attributesDragAndDropComponent.setDataset(ChartGrid.this.project.getOriginalDataset());
                ChartGrid.this.updateCharts(false);
            }
        };
        this.rowSelectionListener = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                if (ChartGrid.this.synchronizeChartWithSelection && !ChartGrid.this.animationRunning) {
                    ChartGrid.this.updateSelectedDataset();
                }
            }
        };
        this.columnSelectionListener = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                if (ChartGrid.this.synchronizeChartWithSelection && !ChartGrid.this.animationRunning) {
                    ChartGrid.this.updateSelectedDataset();
                }
            }
        };
        this.mainChartComponent = new JPanel((LayoutManager)new JideBorderLayout());
        this.mainChartComponent.add(this.horizontalSplitPane);
        JToolBar toolBar = new JToolBar();
        toolBar.setBorderPainted(false);
        toolBar.setFloatable(false);
        SaveImageAction saveImageAction = new SaveImageAction();
        saveImageAction.setDrawable(this);
        saveImageAction.setJComponent(this.mainChartComponent);
        CopyImageAction copyImageAction = new CopyImageAction();
        copyImageAction.setDrawable(this);
        copyImageAction.setJComponent(this.mainChartComponent);
        toolBar.add(HeatMapToolBar.createButton(saveImageAction));
        toolBar.add(HeatMapToolBar.createButton(copyImageAction));
        this.chartMovieControlPanel = new ChartMovieControlPanel(this);
        this.mainChartComponent.add((Component)toolBar, "North");
        this.attributesDragAndDropComponent = new AttributesDragAndDropComponent(rowsAndColumnsAcceptDropTypes){

            @Override
            protected void notifyGroupColumnsByChanged(String sourceOwnerName, String destOwnerName) {
                ChartGrid.this.dropDropChanged(sourceOwnerName, destOwnerName);
            }

            @Override
            protected void notifyGroupRowsByChanged(String sourceOwnerName, String destOwnerName) {
                ChartGrid.this.dropDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        this.xAxisLabelPanel = new DropListPanel(AttributesDragAndDropComponent.ACCEPT_DROP_TYPES, false, false, null, X_AXIS_LABEL_DRAG_OWNER_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                ChartGrid.this.dropDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        this.colorByMarksPanel = new DropListPanel(AttributesDragAndDropComponent.ACCEPT_DROP_TYPES, false, false, null, COLOR_DRAG_OWNER_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                ChartGrid.this.dropDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        this.sizeByMarksPanel = new DropListPanel(AttributesDragAndDropComponent.ACCEPT_DROP_TYPES, false, false, null, SIZE_DRAG_OWNER_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                ChartGrid.this.dropDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        this.shapeByMarksPanel = new DropListPanel(AttributesDragAndDropComponent.ACCEPT_DROP_TYPES, false, false, null, SHAPE_DRAG_OWNER_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                ChartGrid.this.dropDropChanged(sourceOwnerName, destOwnerName);
            }
        };
        this.attributesDragAndDropComponent.setAdditionalDropListPanels(new DropListPanel[]{this.xAxisLabelPanel, this.colorByMarksPanel, this.sizeByMarksPanel, this.shapeByMarksPanel});
        this.legends = new JComponent[]{null, this.colorBy.getLegend(), this.sizeBy.getLegend(), this.shapeBy.getLegend()};
        this.attributesDragAndDropComponent.setLegends(this.legends, new String[]{null, "Color Legend", "Size Legend", "Shape Legend"});
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                ChartGrid.this.attributesDragAndDropComponent.setDataset(ChartGrid.this.project.getOriginalDataset());
            }
        };
        this.attributesDragAndDropComponent.setDataset(this.project.getOriginalDataset());
        this.chartOptionsPanel = new ChartGridOptionsComponent(this);
        JScrollPane chartOptionsScrollPane = UIUtil.createNoBorderScrollPane(this.chartOptionsPanel.getComponent());
        chartOptionsScrollPane.setMinimumSize(new Dimension());
        this.attributesDragAndDropComponent.setBottomLeftComponent(chartOptionsScrollPane, "Options");
        this.attributesDragAndDropComponent.buildUI();
        this.dockableFramesAndChartSplitter = new JideSplitPane();
        this.dockableFramesAndChartSplitter.addPane(this.attributesDragAndDropComponent.getComponent());
        this.dockableFramesAndChartSplitter.addPane((Component)this.mainChartComponent);
        this.dockableFramesAndChartSplitter.setProportionalLayout(true);
        this.dockableFramesAndChartSplitter.setProportions(new double[]{0.3});
        this.headerChartsFooterVerticalSplitPane.setProportionalLayout(true);
        this.headerChartsFooterVerticalSplitPane.setProportions(new double[]{0.0, 0.8});
        leftVerticalSplitPane.setProportionalLayout(true);
        leftVerticalSplitPane.setProportions(this.headerChartsFooterVerticalSplitPane.getProportions());
        ((JideSplitPane)this.horizontalSplitPane).setProportionalLayout(true);
        ((JideSplitPane)this.horizontalSplitPane).setProportions(new double[]{0.2});
        this.dockableFramesAndChartSplitter.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                ChartGrid.this.updateDividerLocations();
            }
        });
        this.setChartType(chartType);
        this.chartOptionsPanel.setVisibility();
        if (this.modelDataset != null) {
            if (chartType.equals(ROW_PROFILE)) {
                this.colorByMarksPanel.drop(VectorUtil.asOrientedVector(this.modelDataset.getRowMetadata().get(0), true), true);
                MetadataModel textMetadata = MetadataUtil.getTextColumns(this.modelDataset.getColumnMetadata());
                if (textMetadata.getMetadataCount() == 0) {
                    textMetadata = this.modelDataset.getColumnMetadata();
                }
                if (textMetadata.getMetadataCount() > 0) {
                    this.xAxisLabelPanel.drop(VectorUtil.asOrientedVector(textMetadata.get(0), false), true);
                }
            } else if (chartType.equals(COLUMN_PROFILE)) {
                this.colorByMarksPanel.drop(VectorUtil.asOrientedVector(this.modelDataset.getColumnMetadata().get(0), false), true);
                MetadataModel textMetadata = MetadataUtil.getTextColumns(this.modelDataset.getRowMetadata());
                if (textMetadata.getMetadataCount() == 0) {
                    textMetadata = this.modelDataset.getRowMetadata();
                }
                if (textMetadata.getMetadataCount() > 0) {
                    this.xAxisLabelPanel.drop(VectorUtil.asOrientedVector(textMetadata.get(0), true), true);
                }
            }
        }
    }

    @Override
    public void chartChanged(ChartChangeEvent e) {
        this.refreshAxes();
        this.updateDividerLocation = true;
        if (this.updateDividerLocation) {
            this.updateDividerLocations();
            this.updateDividerLocation = false;
        }
    }

    public ChartGrid copy() {
        ChartGrid chartGrid = new ChartGrid(this.chartType, this.rowsAndColumnsAcceptDropTypes);
        chartGrid.synchronizeChartWithSelection = this.synchronizeChartWithSelection;
        chartGrid.convertToChart = this.convertToChart.copy();
        chartGrid.yMaxScaling = this.yMaxScaling;
        chartGrid.yMinScaling = this.yMinScaling;
        chartGrid.zScoreTransform = this.zScoreTransform;
        chartGrid.robustZScoreTransform = this.robustZScoreTransform;
        chartGrid.logScale = this.logScale;
        return chartGrid;
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        int j;
        int ncols;
        int i;
        int chartWidth;
        int chartHeight;
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform savedTransform = g2.getTransform();
        int totalLegendHeight = 0;
        for (JComponent legend : this.legends) {
            if (legend == null || !legend.isVisible()) continue;
            DrawableWrapper wrapper = new DrawableWrapper(legend);
            wrapper.draw(g2, new Rectangle(legend.getPreferredSize()));
            int height = legend.getPreferredSize().height;
            g2.translate(0, height);
            totalLegendHeight += height;
        }
        g2.setTransform(savedTransform);
        if (this.chartMatrix[0][0].isPreferredSizeSet()) {
            chartHeight = this.chartHeight;
            chartWidth = this.chartWidth;
        } else {
            chartHeight = this.chartMatrix[0][0].getHeight();
            chartWidth = this.chartMatrix[0][0].getWidth();
        }
        int totalWidthBeforeChart = this.rowHeaderPanel.getPreferredSize().width;
        int widthBeforeYAxis = this.rowCartesianProductHeader.getPreferredSize().width;
        Color savedColumnHeaderPanelBackground = this.columnHeaderPanel.getBackground();
        Color savedRowHeaderPanelBackground = this.rowHeaderPanel.getBackground();
        this.columnHeaderPanel.setBackground(Color.WHITE);
        this.rowHeaderPanel.setBackground(Color.WHITE);
        if (this.columnHeaderPanel.isVisible()) {
            g2.translate(totalWidthBeforeChart, totalLegendHeight);
            new DrawableWrapper(this.columnHeaderPanel, true).draw(g, new Rectangle(this.columnHeaderPanel.getPreferredSize()));
            g2.setTransform(savedTransform);
        }
        int ty = this.columnHeaderPanel.getPreferredSize().height + totalLegendHeight;
        if (this.yAxisVisible) {
            int nrows = this.chartMatrix.length;
            for (int i2 = 0; i2 < nrows; ++i2) {
                g2.setTransform(savedTransform);
                g.translate(widthBeforeYAxis, chartHeight * i2 + ty);
                this.yAxes[i2].draw(g, null);
            }
        }
        g2.setTransform(savedTransform);
        g2.setColor(Color.LIGHT_GRAY);
        Line2D.Float line = new Line2D.Float();
        line.setLine(totalWidthBeforeChart, ty, totalWidthBeforeChart, chartHeight * this.chartMatrix.length + ty);
        g2.draw(line);
        int nrows = this.chartMatrix.length;
        for (i = 0; i < nrows; ++i) {
            ncols = this.chartMatrix[0].length;
            for (j = 0; j < ncols; ++j) {
                g2.setTransform(savedTransform);
                g.translate(chartWidth * j + totalWidthBeforeChart, chartHeight * i + ty);
                this.chartMatrix[i][j].draw(g2, this.chartMatrix[i][j].getCoordinateMapper(), chartWidth, chartHeight);
            }
        }
        g2.setTransform(savedTransform);
        g2.translate(0, ty);
        new DrawableWrapper(this.rowCartesianProductHeader).draw(g2, null);
        if (this.xAxisVisible) {
            int ncols2 = this.chartMatrix[0].length;
            for (int j2 = 0; j2 < ncols2; ++j2) {
                g2.setTransform(savedTransform);
                g.translate(chartWidth * j2 + totalWidthBeforeChart, chartHeight * this.chartMatrix.length + ty);
                this.xAxes[j2].draw(g, null);
            }
        }
        g2.setTransform(savedTransform);
        g2.setColor(Color.LIGHT_GRAY);
        line.setLine(totalWidthBeforeChart, chartHeight * this.chartMatrix.length + ty, chartWidth + totalWidthBeforeChart, chartHeight * this.chartMatrix.length + ty);
        g2.draw(line);
        nrows = this.chartMatrix.length;
        for (i = 0; i < nrows; ++i) {
            ncols = this.chartMatrix[0].length;
            for (j = 0; j < ncols; ++j) {
                this.chartMatrix[i][j].revalidate();
                this.chartMatrix[i][j].repaint();
            }
        }
        this.columnHeaderPanel.setBackground(savedColumnHeaderPanelBackground);
        this.rowHeaderPanel.setBackground(savedRowHeaderPanelBackground);
    }

    public AttributesDragAndDropComponent getAttributesDragAndDropComponent() {
        return this.attributesDragAndDropComponent;
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public GENEEChart[][] getChartPanels() {
        return this.chartMatrix;
    }

    public int getChartWidth() {
        return this.chartWidth;
    }

    public OrientedVector getColorByVector() {
        return this.colorBy.getModelVector();
    }

    public VectorColorModel getColorModel(boolean isRowVector) {
        return isRowVector ? this.project.getRowColorModel() : this.project.getColumnColorModel();
    }

    public Component getComponent() {
        return this.dockableFramesAndChartSplitter;
    }

    public ConvertToChart getConverter() {
        return this.convertToChart;
    }

    public float getCustomYMax() {
        return this.customYMax;
    }

    public float getCustomYMin() {
        return this.customYMin;
    }

    public DatasetGrid2D getDatasetGrid2D() {
        return this.datasetGrid2D;
    }

    public Color getDefaultChartColor() {
        return this.defaultChartColor;
    }

    @Override
    public Dimension getDrawableSize() {
        int chartWidth;
        int chartHeight;
        if (this.chartMatrix[0][0].isPreferredSizeSet()) {
            chartHeight = this.chartHeight;
            chartWidth = this.chartWidth;
        } else {
            chartHeight = this.chartMatrix[0][0].getHeight();
            chartWidth = this.chartMatrix[0][0].getWidth();
        }
        Dimension d = new Dimension(chartWidth * this.chartMatrix[0].length, chartHeight * this.chartMatrix.length);
        this.beforePrint();
        d.width += this.rowHeaderPanel.getPreferredSize().width;
        d.height += this.columnHeaderPanel.getPreferredSize().height;
        int footerHeight = Math.max(2, this.columnFooterPanel.getPreferredSize().height);
        d.height += footerHeight;
        for (JComponent legend : this.legends) {
            if (legend == null || !legend.isVisible()) continue;
            int height = legend.getPreferredSize().height;
            d.height += height;
            d.width = Math.max(d.width, legend.getPreferredSize().width);
        }
        d.width += 10;
        return d;
    }

    public Project getProject() {
        return this.project;
    }

    public ShapeBy getShapeBy() {
        return this.shapeBy;
    }

    public OrientedVector getShapeByVector() {
        return this.shapeBy.getModelVector();
    }

    public OrientedVector getSizeByVector() {
        return this.sizeBy.getModelVector();
    }

    public Map<Object, Float> getValueToSize() {
        return this.sizeBy.getValueToPercent();
    }

    public OrientedVector getXLabelBy() {
        List<Object> droppedData = this.xAxisLabelPanel.getDroppedData();
        for (Object obj : droppedData) {
            if (!(obj instanceof OrientedVector)) continue;
            return (OrientedVector)obj;
        }
        return null;
    }

    public boolean isInverseLogScale() {
        return this.inverseLogScale;
    }

    @Override
    public void notifyHidden() {
        this.project.getRowSelectionModel().removeSelectionListener(this.rowSelectionListener);
        this.project.getColumnSelectionModel().removeSelectionListener(this.columnSelectionListener);
        this.project.removeProjectListener(this.projectListener);
        this.attributesDragAndDropComponent.dispose();
        this.project.getRowColorModel().removeVectorVisualMapperListener(this.vectorVisualMapperListener);
        this.project.getColumnColorModel().removeVectorVisualMapperListener(this.vectorVisualMapperListener);
        this.shapeBy.getVectorShapeModel().removeVectorVisualMapperListener(this.vectorVisualMapperListener);
    }

    @Override
    public void notifyShowing() {
        this.project.getRowColorModel().addVectorVisualMapperListener(this.vectorVisualMapperListener);
        this.project.getColumnColorModel().addVectorVisualMapperListener(this.vectorVisualMapperListener);
        this.project.addProjectListener(this.projectListener);
        this.project.getRowSelectionModel().addSelectionListener(this.rowSelectionListener);
        this.project.getColumnSelectionModel().addSelectionListener(this.columnSelectionListener);
        this.shapeBy.getVectorShapeModel().addVectorVisualMapperListener(this.vectorVisualMapperListener);
    }

    public void setAnimationRunning(boolean animationRunning) {
        this.animationRunning = animationRunning;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
        if (this.chartMatrix.length == 1 && this.chartMatrix[0].length == 1) {
            int nrows = this.chartMatrix.length;
            for (int i = 0; i < nrows; ++i) {
                int ncols = this.chartMatrix[0].length;
                for (int j = 0; j < ncols; ++j) {
                    this.chartMatrix[i][j].setPreferredSize(null);
                }
            }
        } else {
            int nrows = this.chartMatrix.length;
            for (int i = 0; i < nrows; ++i) {
                int ncols = this.chartMatrix[0].length;
                for (int j = 0; j < ncols; ++j) {
                    this.chartMatrix[i][j].setPreferredSize(new Dimension(this.chartWidth, chartHeight));
                }
            }
        }
        this.chartPanelsHolder.revalidate();
        this.chartPanelsHolder.repaint();
        this.layoutYAxis();
        this.rowHeaderPanel.revalidate();
        this.rowHeaderPanel.repaint();
        this.updateDividerLocations();
    }

    public void setChartOptionsVisible(boolean visible) {
        this.attributesDragAndDropComponent.setBottomLeftComponentVisible(visible);
    }

    public void setChartPanelsValid(boolean b) {
        this.chartPanelsValid = b;
    }

    public void setChartType(String chartType) {
        if (this.convertToChart != null) {
            this.convertToChart.dispose();
        }
        this.chartType = chartType;
        if (chartType.equals(ROW_PROFILE)) {
            this.convertToChart = this.convertToRowProfileChart;
        } else if (chartType.equals(COLUMN_PROFILE)) {
            this.convertToChart = this.convertToColumnProfileChart;
        } else if (chartType.equals(HISTOGRAM)) {
            this.convertToChart = this.convertToHistogramChart;
        } else if (chartType.equals(BOXPLOT)) {
            this.convertToChart = this.convertToBoxplot;
        } else if (chartType.equals(COLUMN_XY_CHART)) {
            this.convertToChart = this.convertToColumnXY;
        } else if (chartType.equals(ROW_XY_CHART)) {
            this.convertToChart = this.convertToRowXY;
        } else {
            throw new IllegalArgumentException();
        }
        this.chartPanelsValid = false;
        this.updateSelectedDataset();
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
        if (this.chartMatrix.length == 1 && this.chartMatrix[0].length == 1) {
            int nrows = this.chartMatrix.length;
            for (int i = 0; i < nrows; ++i) {
                int ncols = this.chartMatrix[0].length;
                for (int j = 0; j < ncols; ++j) {
                    this.chartMatrix[i][j].setPreferredSize(null);
                }
            }
        } else {
            int nrows = this.chartMatrix.length;
            for (int i = 0; i < nrows; ++i) {
                int ncols = this.chartMatrix[0].length;
                for (int j = 0; j < ncols; ++j) {
                    this.chartMatrix[i][j].setPreferredSize(new Dimension(chartWidth, this.chartHeight));
                }
            }
        }
        this.chartPanelsHolder.revalidate();
        this.chartPanelsHolder.repaint();
        this.layoutXAxis();
        this.columnHeaderPanel.revalidate();
        this.columnHeaderPanel.repaint();
        this.columnFooterPanel.revalidate();
        this.columnFooterPanel.repaint();
        this.updateDividerLocations();
    }

    public void setColorBy(OrientedVector v) {
        this.colorByMarksPanel.drop(v, true);
    }

    public void setDefaultChartColor(Color c) {
        this.defaultChartColor = c;
        int nrows = this.chartMatrix.length;
        for (int i = 0; i < nrows; ++i) {
            int ncols = this.chartMatrix[0].length;
            for (int j = 0; j < ncols; ++j) {
                DefaultChartPropertiesSupplier chartPropertiesSupplier = (DefaultChartPropertiesSupplier)this.chartMatrix[i][j].getChartRenderer().getChartPropertiesSupplier();
                chartPropertiesSupplier.setDefaultColor(this.defaultChartColor);
            }
        }
        this.updateCharts(false);
    }

    public void setForcePreferredSize(boolean forcePreferredSize) {
        this.forcePreferredSize = forcePreferredSize;
    }

    public void setInverseLogScale(boolean inverseLogScale) {
        this.inverseLogScale = inverseLogScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public void setNoDataMessage(String message) {
        this.noDataMessage = message;
    }

    public void setProperties(GENEEChart chartPanel, ChartRenderer renderer) {
        int height;
        int width;
        boolean isMatrix;
        ChartPropertiesSupplier supplier = renderer.getChartPropertiesSupplier();
        supplier.setDefaultColor(this.defaultChartColor);
        supplier.setColorByChartHighlighter(this.colorBy.getHighlighter());
        supplier.setSizeByChartHighlighter(this.sizeBy.getHighlighter());
        supplier.setShapeByChartHighlighter(this.shapeBy.getHighlighter());
        boolean bl = isMatrix = this.forcePreferredSize || this.datasetGrid2D.getRowCount() > 1 || this.datasetGrid2D.getColumnCount() > 1;
        if (isMatrix) {
            width = this.chartWidth;
            height = this.chartHeight;
        } else {
            width = this.chartPanelsHolder.getWidth();
            height = this.chartPanelsHolder.getHeight();
        }
        renderer.getChartPropertiesSupplier().init(chartPanel.getSelectionModel(), width, height);
    }

    public void setRobustZScoreTransform(boolean robustZScoreTransform) {
        this.robustZScoreTransform = robustZScoreTransform;
    }

    public void setShapeBy(OrientedVector v) {
        this.shapeByMarksPanel.drop(v, true);
    }

    public void setSynchronizeChartWithSelection(boolean synchronizeChartWithSelection) {
        this.synchronizeChartWithSelection = synchronizeChartWithSelection;
    }

    public void setUpdateDividerLocation(boolean b) {
        this.updateDividerLocation = true;
    }

    public void setUpdateSelectedDatasetFunction(Function<Void, UpdateSelection> updateSelectedDatasetFunction) {
        this.updateSelectedDatasetFunction = updateSelectedDatasetFunction;
    }

    public void setXAxisLabelBy(OrientedVector v) {
        this.xAxisLabelPanel.drop(v, true);
    }

    public void setZScoreTransform(boolean zScoreTransform) {
        this.zScoreTransform = zScoreTransform;
    }

    public void updateCharts(boolean transition) {
        this.updateCharts(this.modelDataset, this.datasetGrid2D.getSelectedModelRowIndices(), this.datasetGrid2D.getSelectedModelColumnIndices(), true, transition);
    }

    public void updateCharts(Dataset modelDataset, int[] rowIndices, int[] columnIndices, boolean repaint, boolean transition) {
        int j;
        int i;
        int j2;
        int ncols;
        int i2;
        int nrows;
        this.modelDataset = modelDataset;
        this.datasetGrid2D.setSelectedModelIndices(rowIndices, columnIndices);
        this.updateGroupBy();
        this.chartOptionsPanel.setVisibility(this.datasetGrid2D.getRowCount(), this.datasetGrid2D.getColumnCount());
        if (!this.chartPanelsValid || this.datasetGrid2D.getRowCount() != this.chartMatrix.length || this.datasetGrid2D.getColumnCount() != this.chartMatrix[0].length) {
            nrows = this.chartMatrix.length;
            for (i2 = 0; i2 < nrows; ++i2) {
                ncols = this.chartMatrix[0].length;
                for (j2 = 0; j2 < ncols; ++j2) {
                    this.chartMatrix[i2][j2].removeChartChangeListener(this);
                }
            }
            transition = false;
            this.chartPanelsValid = true;
            this.chartMatrix = new GENEEChart[this.datasetGrid2D.getRowCount()][this.datasetGrid2D.getColumnCount()];
            nrows = this.chartMatrix.length;
            for (i2 = 0; i2 < nrows; ++i2) {
                ncols = this.chartMatrix[0].length;
                for (j2 = 0; j2 < ncols; ++j2) {
                    this.chartMatrix[i2][j2] = new GENEEChart();
                }
            }
            this.xAxes = new Axis[this.datasetGrid2D.getColumnCount()];
            int ncols2 = this.chartMatrix[0].length;
            for (int j3 = 0; j3 < ncols2; ++j3) {
                this.xAxes[j3] = new Axis(true, this.chartMatrix[0][j3].getCoordinateMapper());
            }
            this.yAxes = new Axis[this.datasetGrid2D.getRowCount()];
            nrows = this.chartMatrix.length;
            for (i2 = 0; i2 < nrows; ++i2) {
                this.yAxes[i2] = new Axis(false, this.chartMatrix[i2][0].getCoordinateMapper());
            }
            nrows = this.chartMatrix.length;
            for (i2 = 0; i2 < nrows; ++i2) {
                ncols = this.chartMatrix[0].length;
                for (j2 = 0; j2 < ncols; ++j2) {
                    this.chartMatrix[i2][j2].addChartChangeListener(this);
                }
            }
            this.layoutChartPanelsHolderAndAxes(this.datasetGrid2D.getRowCount(), this.datasetGrid2D.getColumnCount());
            this.setXAxisVisible(this.xAxisVisible);
            this.setYAxisVisible(this.yAxisVisible);
        }
        if (transition) {
            this.chartTransition.saveTransitionFrom();
        }
        this.updateSizeBy();
        this.updateColorBy();
        this.updateShapeBy();
        this.convertToChart.init(this);
        nrows = this.chartMatrix.length;
        for (i2 = 0; i2 < nrows; ++i2) {
            ncols = this.chartMatrix[0].length;
            for (j2 = 0; j2 < ncols; ++j2) {
                Dimension size = new Dimension(this.chartWidth, this.chartHeight);
                boolean isMatrix = this.forcePreferredSize || nrows > 1 || ncols > 1;
                this.chartMatrix[i2][j2].setPreferredSize(isMatrix ? size : null);
                this.chartMatrix[i2][j2].setMaximumSize(isMatrix ? size : null);
                this.chartMatrix[i2][j2].setMinimumSize(isMatrix ? size : new Dimension(200, 200));
                this.chartMatrix[i2][j2].setNoDataMessage(this.noDataMessage);
            }
        }
        Dataset dataset = this.getDataset();
        int nrows2 = this.chartMatrix.length;
        for (i = 0; i < nrows2; ++i) {
            int ncols3 = this.chartMatrix[0].length;
            for (j = 0; j < ncols3; ++j) {
                this.centroidChart = false;
                this.convertToChart.customize(this.chartMatrix[i][j], dataset, this.datasetGrid2D.getRowIndices(i, j), this.datasetGrid2D.getColumnIndices(i, j), i, j);
            }
        }
        int ncols4 = this.chartMatrix[0].length;
        for (int j4 = 0; j4 < ncols4; ++j4) {
            this.convertToChart.customizeXAxis(this.xAxes[j4], this.chartMatrix, j4);
        }
        if (this.yAxes != null) {
            nrows2 = this.chartMatrix.length;
            for (i = 0; i < nrows2; ++i) {
                if (this.yAxes[i] == null) continue;
                this.yAxes[i].setIntegerTicks(false);
                this.convertToChart.customizeYAxis(this.yAxes[i], this.chartMatrix, i);
            }
        }
        this.sizeBy.updateLegend();
        this.colorBy.updateLegend();
        this.shapeBy.updateLegend();
        if (!transition) {
            this.setXAxisScale();
            this.setYAxisScale();
        } else {
            nrows2 = this.chartMatrix.length;
            for (i = 0; i < nrows2; ++i) {
                int ncols5 = this.chartMatrix[0].length;
                for (j = 0; j < ncols5; ++j) {
                    this.chartMatrix[i][j].setCustomYMin(Float.NaN);
                    this.chartMatrix[i][j].setCustomYMax(Float.NaN);
                    this.chartMatrix[i][j].setCustomXMin(Float.NaN);
                    this.chartMatrix[i][j].setCustomXMax(Float.NaN);
                }
            }
        }
        if (transition) {
            this.chartTransition.transition();
        }
        this.rowHeaderPanel.revalidate();
        this.columnHeaderPanel.revalidate();
        this.columnFooterPanel.revalidate();
        this.mainChartComponent.revalidate();
        this.mainChartComponent.repaint();
        if (!transition) {
            this.repaintCharts();
        }
        this.updateDividerLocation = true;
    }

    protected Dataset getDataset() {
        Dataset dataset = this.modelDataset;
        if (this.logScale || this.zScoreTransform || this.robustZScoreTransform || this.chartOptionsPanel.isCeiling() || this.chartOptionsPanel.isFloor() || this.inverseLogScale) {
            dataset = new TransformedDataset(dataset, this.logScale, this.zScoreTransform, this.robustZScoreTransform, this.chartOptionsPanel.isCeiling() ? this.ceiling : Float.NaN, this.chartOptionsPanel.isFloor() ? this.floor : Float.NaN, this.inverseLogScale);
        }
        return dataset;
    }

    protected BasicVectorDatasetValuesSupplier[] getGroupByArray(List<Object> droppedDataList) {
        ArrayList<BasicVectorDatasetValuesSupplier> groupBy = new ArrayList<BasicVectorDatasetValuesSupplier>();
        for (Object obj : droppedDataList) {
            OrientedVector vector = (OrientedVector)obj;
            if (vector != null) {
                SlicedVector selectedVector = new SlicedVector(vector, vector.isRowVector() ? this.datasetGrid2D.getSelectedModelRowIndices() : this.datasetGrid2D.getSelectedModelColumnIndices());
                BasicVectorDatasetValuesSupplier supplier = new BasicVectorDatasetValuesSupplier(selectedVector, vector.isRowVector());
                groupBy.add(supplier);
                continue;
            }
            System.err.println("Null vector");
        }
        return groupBy.toArray(new BasicVectorDatasetValuesSupplier[0]);
    }

    protected void setXAxisScale() {
        this.setScale(new XMinChartScaleSupplier(), this.xMinScaling, this.customXMin, true);
        this.setScale(new XMaxChartScaleSupplier(), this.xMaxScaling, this.customXMax, false);
    }

    protected void updateGroupBy() {
        ModelIndicesVector[] rows = this.getGroupByArray(this.attributesDragAndDropComponent.getDroppedGroupRowsByData());
        ModelIndicesVector[] columns = this.getGroupByArray(this.attributesDragAndDropComponent.getDroppedGroupColumnsByData());
        this.datasetGrid2D.setGroupBy(rows, columns);
    }

    protected void updateSelectedDataset() {
        this.updateSelectedDataset(false);
    }

    protected void updateSelectedDataset(boolean transition) {
        UpdateSelection update = (UpdateSelection)this.updateSelectedDatasetFunction.apply(null);
        this.modelDataset = update.modelDataset;
        this.updateCharts(this.modelDataset, update.selectedModelRowIndices, update.selectedModelColumnIndices, true, transition);
    }

    float getCeiling() {
        return this.ceiling;
    }

    ChartMovieControlPanel getChartMovieControlPanel() {
        return this.chartMovieControlPanel;
    }

    String getChartType() {
        return this.chartType;
    }

    float getFloor() {
        return this.floor;
    }

    ScalingMode getyMaxScaling() {
        return this.yMaxScaling;
    }

    ScalingMode getyMinScaling() {
        return this.yMinScaling;
    }

    boolean isCentroidChart() {
        return this.centroidChart;
    }

    boolean isChartPanelsValid() {
        return this.chartPanelsValid;
    }

    boolean isLogScale() {
        return this.logScale;
    }

    boolean isRobustZScoreTransform() {
        return this.robustZScoreTransform;
    }

    boolean isSynchronizeChartWithSelection() {
        return this.synchronizeChartWithSelection;
    }

    boolean isUseMeanForCentroid() {
        return this.useMeanForCentroid;
    }

    boolean iszScoreTransform() {
        return this.zScoreTransform;
    }

    void repaintCharts() {
        int nrows = this.chartMatrix.length;
        for (int i = 0; i < nrows; ++i) {
            int ncols = this.chartMatrix[0].length;
            for (int j = 0; j < ncols; ++j) {
                this.chartMatrix[i][j].invalidateImage();
            }
        }
    }

    void setCeiling(float ceiling) {
        this.ceiling = ceiling;
    }

    void setCentroidChart(boolean centroidChart) {
        this.centroidChart = centroidChart;
    }

    void setCustomYMax(float customYMax) {
        this.customYMax = customYMax;
    }

    void setCustomYMin(float customYMin) {
        this.customYMin = customYMin;
    }

    void setFloor(float floor) {
        this.floor = floor;
    }

    void setUseMeanForCentroid(boolean useMeanForCentroid) {
        this.useMeanForCentroid = useMeanForCentroid;
    }

    void setXAxisVisible(boolean visible) {
        this.xAxisVisible = visible && this.convertToChart.isXAxisVisible();
        for (Axis axis : this.xAxes) {
            axis.setVisible(this.xAxisVisible);
        }
    }

    void setYAxisScale() {
        this.setScale(new YMinChartScaleSupplier(), this.yMinScaling, this.customYMin, true);
        this.setScale(new YMaxChartScaleSupplier(), this.yMaxScaling, this.customYMax, false);
    }

    void setYAxisVisible(boolean visible) {
        this.yAxisVisible = visible;
        for (Axis axis : this.yAxes) {
            axis.setVisible(visible);
        }
    }

    void setYMaxScalingMode(ScalingMode yMaxScaling) {
        this.yMaxScaling = yMaxScaling;
    }

    void setyMinScaling(ScalingMode yMinScaling) {
        this.yMinScaling = yMinScaling;
    }

    void setzScoreTransform(boolean zScoreTransform) {
        this.zScoreTransform = zScoreTransform;
    }

    private void beforePrint() {
        int nrows = this.chartMatrix.length;
        for (int i = 0; i < nrows; ++i) {
            int ncols = this.chartMatrix[0].length;
            for (int j = 0; j < ncols; ++j) {
                this.chartMatrix[i][j].forceScale();
            }
        }
        if (this.xAxisVisible) {
            for (Axis axis : this.xAxes) {
                axis.refresh();
                axis.revalidate();
            }
        }
        if (this.yAxisVisible) {
            for (Axis axis : this.yAxes) {
                axis.refresh();
                axis.revalidate();
            }
        }
    }

    private void dropDropChanged(String source, String dest) {
        this.chartPanelsValid = false;
        this.updateCharts(this.modelDataset, this.datasetGrid2D.getSelectedModelRowIndices(), this.datasetGrid2D.getSelectedModelColumnIndices(), true, false);
    }

    private Vector getVectorInSelectedIndicesSpace(OrientedVector v) {
        if (v != null) {
            boolean isRow = v.isRowVector();
            return new SlicedVector(v, isRow ? this.datasetGrid2D.getSelectedModelRowIndices() : this.datasetGrid2D.getSelectedModelColumnIndices());
        }
        return null;
    }

    private void layoutChartPanelsHolderAndAxes(int rows, int columns) {
        this.chartPanelsHolder.removeAll();
        this.columnHeaderPanel.removeAll();
        this.columnFooterPanel.removeAll();
        CellConstraints cc = new CellConstraints();
        if (rows == 1 && columns == 1) {
            this.chartPanelsHolder.setLayout(new BorderLayout());
            this.chartPanelsHolder.add(this.chartMatrix[0][0]);
        } else {
            FormLayout fl = new FormLayout(UIUtil.rep("p:none", columns, ", "), UIUtil.rep("p:none", rows, ", "));
            this.chartPanelsHolder.setLayout((LayoutManager)fl);
            int i = 0;
            int nrows = this.chartMatrix.length;
            int y = 1;
            while (i < nrows) {
                int j = 0;
                int x = 1;
                int ncols = this.chartMatrix[0].length;
                while (j < ncols) {
                    this.chartPanelsHolder.add((Component)this.chartMatrix[i][j], cc.xy(x, y));
                    ++j;
                    ++x;
                }
                ++i;
                ++y;
            }
        }
        this.layoutXAxis();
        this.layoutYAxis();
    }

    private void layoutXAxis() {
        CellConstraints cc = new CellConstraints();
        int ncols = this.chartMatrix[0].length;
        this.columnHeaderPanel.removeAll();
        this.columnFooterPanel.removeAll();
        this.columnHeaderPanel.setLayout((LayoutManager)new FormLayout(UIUtil.rep(ncols == 1 ? "p:g" : this.chartWidth + "px:none", ncols, ", "), "bottom:p:none"));
        this.columnFooterPanel.setLayout((LayoutManager)new FormLayout(UIUtil.rep(ncols == 1 ? "fill:p:g" : this.chartWidth + "px:none", ncols, ", "), "top:p:none"));
        CartesianProductHeader header = new CartesianProductHeader(this.datasetGrid2D, true);
        if (ncols > 1) {
            header.setGridSize(this.chartWidth);
            header.layoutLabels();
        }
        this.columnHeaderPanel.add((Component)header, cc.xyw(1, 1, ncols));
        int j = 0;
        int x = 1;
        while (j < ncols) {
            this.columnFooterPanel.add((Component)this.xAxes[j], cc.xy(x, 1));
            ++j;
            ++x;
        }
    }

    private void layoutYAxis() {
        this.rowHeaderPanel.removeAll();
        CellConstraints cc = new CellConstraints();
        int nrows = this.chartMatrix.length;
        this.rowHeaderPanel.setLayout((LayoutManager)new FormLayout("r:p:g, r:p:g", UIUtil.rep(nrows == 1 ? "top:p:g" : this.chartHeight + "px:none", nrows, ", ")));
        this.rowCartesianProductHeader = new CartesianProductHeader(this.datasetGrid2D, false);
        if (nrows > 1) {
            this.rowCartesianProductHeader.setGridSize(this.chartHeight);
            this.rowCartesianProductHeader.layoutLabels();
        }
        this.rowHeaderPanel.add((Component)this.rowCartesianProductHeader, cc.xywh(1, 1, 1, nrows));
        for (int i = 0; i < nrows; ++i) {
            this.rowHeaderPanel.add((Component)this.yAxes[i], cc.xy(2, i + 1));
        }
    }

    private void refreshAxes() {
        for (Axis axis : this.xAxes) {
            axis.refresh();
            axis.revalidate();
            axis.repaint();
        }
        for (Axis axis : this.yAxes) {
            axis.refresh();
            axis.revalidate();
            axis.repaint();
        }
        this.rowHeaderPanel.revalidate();
        this.rowHeaderPanel.repaint();
        this.columnHeaderPanel.revalidate();
        this.columnHeaderPanel.repaint();
    }

    private void setScale(ChartScaleSupplier supplier, ScalingMode scalingMode, float customValue, boolean isMin) {
        if (scalingMode == ScalingMode.CUSTOM) {
            int nrows = this.chartMatrix.length;
            for (int i = 0; i < nrows; ++i) {
                int ncols = this.chartMatrix[0].length;
                for (int j = 0; j < ncols; ++j) {
                    GENEEChart chartPanel = this.chartMatrix[i][j];
                    supplier.set(chartPanel, customValue);
                }
            }
        } else if (scalingMode == ScalingMode.GLOBAL) {
            GENEEChart chartPanel;
            int j;
            int ncols;
            int i;
            float minOrMax = isMin ? Float.MAX_VALUE : -3.4028235E38f;
            int nrows = this.chartMatrix.length;
            for (i = 0; i < nrows; ++i) {
                ncols = this.chartMatrix[0].length;
                for (j = 0; j < ncols; ++j) {
                    chartPanel = this.chartMatrix[i][j];
                    float value = supplier.get(chartPanel);
                    if (Float.isNaN(value)) continue;
                    minOrMax = isMin ? (value < minOrMax ? value : minOrMax) : (value > minOrMax ? value : minOrMax);
                }
            }
            nrows = this.chartMatrix.length;
            for (i = 0; i < nrows; ++i) {
                ncols = this.chartMatrix[0].length;
                for (j = 0; j < ncols; ++j) {
                    chartPanel = this.chartMatrix[i][j];
                    supplier.set(chartPanel, minOrMax);
                }
            }
        } else if (scalingMode == ScalingMode.ROW) {
            int nrows = this.chartMatrix.length;
            for (int i = 0; i < nrows; ++i) {
                GENEEChart chartPanel;
                int j;
                float rowMinOrMax = isMin ? Float.MAX_VALUE : -3.4028235E38f;
                int ncols = this.chartMatrix[0].length;
                for (j = 0; j < ncols; ++j) {
                    chartPanel = this.chartMatrix[i][j];
                    float value = supplier.get(chartPanel);
                    if (Float.isNaN(value)) continue;
                    rowMinOrMax = isMin ? (value < rowMinOrMax ? value : rowMinOrMax) : (value > rowMinOrMax ? value : rowMinOrMax);
                }
                ncols = this.chartMatrix[0].length;
                for (j = 0; j < ncols; ++j) {
                    chartPanel = this.chartMatrix[i][j];
                    supplier.set(chartPanel, rowMinOrMax);
                }
            }
        } else if (scalingMode == ScalingMode.COLUMN) {
            int ncols = this.chartMatrix[0].length;
            for (int j = 0; j < ncols; ++j) {
                GENEEChart chartPanel;
                int i;
                float minOrMax = isMin ? Float.MAX_VALUE : -3.4028235E38f;
                int nrows = this.chartMatrix.length;
                for (i = 0; i < nrows; ++i) {
                    chartPanel = this.chartMatrix[i][j];
                    float value = supplier.get(chartPanel);
                    if (Float.isNaN(value)) continue;
                    minOrMax = isMin ? (value < minOrMax ? value : minOrMax) : (value > minOrMax ? value : minOrMax);
                }
                nrows = this.chartMatrix.length;
                for (i = 0; i < nrows; ++i) {
                    chartPanel = this.chartMatrix[i][j];
                    supplier.set(chartPanel, minOrMax);
                }
            }
        } else if (scalingMode == ScalingMode.INDIVIDUAL) {
            int nrows = this.chartMatrix.length;
            for (int i = 0; i < nrows; ++i) {
                int ncols = this.chartMatrix[0].length;
                for (int j = 0; j < ncols; ++j) {
                    GENEEChart chartPanel = this.chartMatrix[i][j];
                    supplier.set(chartPanel, Float.NaN);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void updateColorBy() {
        List<Object> droppedData = this.colorByMarksPanel.getDroppedData();
        OrientedVector v = null;
        if (droppedData.size() == 1) {
            v = (OrientedVector)droppedData.get(0);
        }
        this.colorBy.setVector(v);
    }

    private void updateDividerLocations() {
        int dividerLocation;
        int columnHeaderPanelHeight = Math.min(200, this.columnHeaderPanel.getPreferredSize().height);
        int columnFooterPanelHeight = Math.min(200, this.columnFooterPanel.getPreferredSize().height);
        int middle = this.chartPanelsHolder.getPreferredSize().height;
        int totalHeight = this.headerChartsFooterVerticalSplitPane.getHeight();
        int dividerSize = this.headerChartsFooterVerticalSplitPane.getDividerSize();
        if (this.chartMatrix.length > 1 || this.chartMatrix[0].length > 1) {
            dividerLocation = columnHeaderPanelHeight + middle + dividerSize;
            if (dividerLocation >= totalHeight - columnFooterPanelHeight - 20) {
                dividerLocation = totalHeight - columnFooterPanelHeight - 20;
            }
        } else {
            dividerLocation = totalHeight - columnHeaderPanelHeight - columnFooterPanelHeight - 20;
        }
        this.headerChartsFooterVerticalSplitPane.setDividerLocations(new int[]{columnHeaderPanelHeight, dividerLocation});
        int leftDividerLocation = Math.min(400, this.rowHeaderPanel.getPreferredSize().width + dividerSize);
        ((JideSplitPane)this.horizontalSplitPane).setProportionalLayout(false);
        ((JideSplitPane)this.horizontalSplitPane).setDividerLocations(new int[]{leftDividerLocation});
        this.columnFooterPanel.revalidate();
        this.columnFooterPanel.repaint();
    }

    private void updateShapeBy() {
        List<Object> droppedData = this.shapeByMarksPanel.getDroppedData();
        OrientedVector v = null;
        if (droppedData.size() == 1) {
            v = (OrientedVector)droppedData.get(0);
        }
        this.shapeBy.setVector(v);
    }

    private void updateSizeBy() {
        List<Object> droppedData = this.sizeByMarksPanel.getDroppedData();
        OrientedVector v = null;
        if (droppedData.size() == 1) {
            v = (OrientedVector)droppedData.get(0);
        }
        this.sizeBy.setVector(v);
    }

    public static void showChart(String chartType) {
        ChartGrid.showChart(new ChartGrid(chartType));
    }

    private static void showChart(final ChartGrid chartGrid) {
        GENEEWindow window = Application.createViewWindow("Plot", chartGrid);
        Dimension size = UIUtil.getMaximumWindowSize();
        window.getContentPane().add(chartGrid.getComponent());
        window.getContentPane().addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                chartGrid.updateDividerLocations();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        UIUtil.pack(window, (int)Math.round((double)size.width * 0.5), (int)Math.round((double)size.height * 0.4));
        window.setVisible(true);
    }

    private static class YMinChartScaleSupplier
    implements ChartScaleSupplier {
        private YMinChartScaleSupplier() {
        }

        @Override
        public float get(GENEEChart chart) {
            return chart.getAutoscaleYMin();
        }

        @Override
        public void set(GENEEChart chartPanel, float value) {
            chartPanel.setCustomYMin(value);
        }
    }

    private static class YMaxChartScaleSupplier
    implements ChartScaleSupplier {
        private YMaxChartScaleSupplier() {
        }

        @Override
        public float get(GENEEChart chart) {
            return chart.getAutoscaleYMax();
        }

        @Override
        public void set(GENEEChart chartPanel, float value) {
            chartPanel.setCustomYMax(value);
        }
    }

    private static class XMinChartScaleSupplier
    implements ChartScaleSupplier {
        private XMinChartScaleSupplier() {
        }

        @Override
        public float get(GENEEChart chart) {
            return chart.getAutoscaleXMin();
        }

        @Override
        public void set(GENEEChart chartPanel, float value) {
            chartPanel.setCustomXMin(value);
        }
    }

    private static class XMaxChartScaleSupplier
    implements ChartScaleSupplier {
        private XMaxChartScaleSupplier() {
        }

        @Override
        public float get(GENEEChart chart) {
            return chart.getAutoscaleXMax();
        }

        @Override
        public void set(GENEEChart chartPanel, float value) {
            chartPanel.setCustomXMax(value);
        }
    }

    private static interface ChartScaleSupplier {
        public float get(GENEEChart var1);

        public void set(GENEEChart var1, float var2);
    }

    public static class UpdateSelection {
        Dataset modelDataset;
        int[] selectedModelColumnIndices;
        int[] selectedModelRowIndices;

        public UpdateSelection(Dataset modelDataset, int[] selectedModelRowIndices, int[] selectedModelColumnIndices) {
            this.modelDataset = modelDataset;
            this.selectedModelColumnIndices = selectedModelColumnIndices;
            this.selectedModelRowIndices = selectedModelRowIndices;
        }
    }

    public static enum ScalingMode {
        COLUMN,
        CUSTOM,
        GLOBAL,
        INDIVIDUAL,
        ROW;

    }
}

