/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import java.util.Collection;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.chart.ChartPropertiesSupplier;
import org.broadinstitute.genee.chart.ChartRenderer;
import org.broadinstitute.genee.chart.ChartSelectionModel;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.DefaultXYChartSeries;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.heatmap.CurveElement;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.SlicedVector;
import org.broadinstitute.genee.stats.Sorting;

public class ChartUtil {
    private ChartUtil() {
    }

    public static DefaultXYChartDataset createDoseResponseChartDataset(Dataset dataset) {
        int doseResponseSeriesIndex = DatasetUtil.getSeriesIndex(dataset, CurveElement.class);
        DefaultXYChartDataset chartDataset = new DefaultXYChartDataset();
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int cols = dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                CurveElement element = (CurveElement)dataset.getObjectValue(i, j, doseResponseSeriesIndex);
                if (element == null || element.size() <= 0) continue;
                String name = ToStringUtil.toString(dataset.getRowMetadata(), i) + ", " + ToStringUtil.toString(dataset.getColumnMetadata(), j);
                DefaultXYChartSeries series = new DefaultXYChartSeries(name, element.size());
                int numPoints = element.size();
                for (int k = 0; k < numPoints; ++k) {
                    series.add(element.getX(i), element.getY(i));
                }
                chartDataset.addSeries(series);
            }
        }
        return chartDataset;
    }

    public static int getSeriesIndex(GENEEChart chart, CoordinateMapper cm, XYChartDataset chartDataset, int xpix, int ypix) {
        int seriesIndex;
        int result;
        Collection<Integer> series;
        if (chartDataset == null) {
            return -1;
        }
        ChartSelectionModel chartSelectionModel = chart.getSelectionModel();
        if (!chartSelectionModel.isEmpty() && (series = chartSelectionModel.getSelectedSeries(0)).size() > 0 && (result = ChartUtil.findSeriesLineAtPix(chart, cm, chartDataset, seriesIndex = series.iterator().next().intValue(), xpix, ypix)) >= 0) {
            return seriesIndex;
        }
        int seriesCount = chartDataset.getSeriesCount();
        for (int seriesIndex2 = 0; seriesIndex2 < seriesCount; ++seriesIndex2) {
            result = ChartUtil.findSeriesLineAtPix(chart, cm, chartDataset, seriesIndex2, xpix, ypix);
            if (result < 0) continue;
            return seriesIndex2;
        }
        return -1;
    }

    public static int findSortedBarItemIndex(ChartPropertiesSupplier chartPropertiesSupplier, CoordinateMapper chartCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int xpix, int ypix) {
        int low = 0;
        int high = chartDataset.getItemCount(seriesIndex) - 1;
        while (low <= high) {
            int cmp;
            float uy;
            int mid = low + high >>> 1;
            float lx = chartCoordinateMapper.xToPix(chartDataset.getXStart(seriesIndex, mid));
            float ux = chartCoordinateMapper.xToPix(chartDataset.getXEnd(seriesIndex, mid));
            float midXPix = (lx + ux) / 2.0f;
            float ly = chartCoordinateMapper.yToPix(chartDataset.getYStart(seriesIndex, mid));
            if (ly > (uy = chartCoordinateMapper.yToPix(chartDataset.getYEnd(seriesIndex, mid)))) {
                float tmp = uy;
                uy = ly;
                ly = tmp;
            }
            if ((cmp = (float)xpix >= lx && (float)xpix <= ux && (float)ypix >= ly && (float)ypix <= uy ? 0 : (midXPix < (float)xpix ? -1 : 1)) < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int findItemIndex(ChartPropertiesSupplier chartPropertiesSupplier, CoordinateMapper chartCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int xpix, int ypix) {
        int itemCount = chartDataset.getItemCount(seriesIndex);
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            float midXPix = chartCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex));
            float halfItemSize = chartPropertiesSupplier.getItemSize(chartDataset, datasetIndex, seriesIndex, itemIndex) / 2.0f;
            float midYPix = chartCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex));
            float lx = midXPix - halfItemSize;
            float ux = midXPix + halfItemSize;
            float ly = midYPix - halfItemSize;
            float uy = midYPix + halfItemSize;
            if (!((float)xpix >= lx) || !((float)xpix <= ux) || !((float)ypix >= ly) || !((float)ypix <= uy)) continue;
            return itemIndex;
        }
        return -1;
    }

    public static int[] getSeriesPaintOrder(XYChartDataset chartDataset, int itemIndex, float[] values, boolean ascending) {
        int nseries = chartDataset.getSeriesCount();
        for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
            float occurences;
            values[seriesIndex] = occurences = chartDataset.getY(seriesIndex, itemIndex);
        }
        return Sorting.index(values, ascending);
    }

    public static void setChartProperties(GENEEChart chartPanel, ChartGrid chartGrid, int rowIndex, int columnIndex, boolean rowMajorOrder, boolean containsSeries, ChartRenderer renderer) {
        ChartPropertiesSupplier chartPropertiesSupplier = renderer.getChartPropertiesSupplier();
        OrientedVector shapeByVector = chartGrid.getShapeByVector();
        if (shapeByVector != null) {
            int[] indices = shapeByVector.isRowVector() ? chartGrid.getDatasetGrid2D().getRowIndices(rowIndex, columnIndex) : chartGrid.getDatasetGrid2D().getColumnIndices(rowIndex, columnIndex);
            SlicedVector slicedShapeVector = new SlicedVector(shapeByVector, indices);
            chartPropertiesSupplier.setShapeByVector(slicedShapeVector, chartGrid.getShapeBy().getVectorShapeModel());
            boolean isRowVector = shapeByVector.isRowVector();
            if (!rowMajorOrder) {
                isRowVector = !isRowVector;
            }
            chartPropertiesSupplier.setShapeBySeries(containsSeries && isRowVector);
        } else {
            chartPropertiesSupplier.setShapeByVector(null, null);
        }
        OrientedVector sizeByVector = chartGrid.getSizeByVector();
        if (sizeByVector != null) {
            int[] indices = sizeByVector.isRowVector() ? chartGrid.getDatasetGrid2D().getRowIndices(rowIndex, columnIndex) : chartGrid.getDatasetGrid2D().getColumnIndices(rowIndex, columnIndex);
            SlicedVector slicedSizeVector = new SlicedVector(sizeByVector, indices);
            chartPropertiesSupplier.setSizeByVector(slicedSizeVector, chartGrid.getValueToSize());
            boolean isRowVector = sizeByVector.isRowVector();
            if (!rowMajorOrder) {
                isRowVector = !isRowVector;
            }
            chartPropertiesSupplier.setSizeBySeries(containsSeries && isRowVector);
        } else {
            chartPropertiesSupplier.setSizeByVector(null, null);
        }
        OrientedVector colorByVector = chartGrid.getColorByVector();
        if (colorByVector != null) {
            int[] indices = colorByVector.isRowVector() ? chartGrid.getDatasetGrid2D().getRowIndices(rowIndex, columnIndex) : chartGrid.getDatasetGrid2D().getColumnIndices(rowIndex, columnIndex);
            SlicedVector slicedVector = new SlicedVector(colorByVector, indices);
            chartPropertiesSupplier.setColorByVector(slicedVector);
            VectorColorModel colorModel = chartGrid.getColorModel(colorByVector.isRowVector());
            chartPropertiesSupplier.setColorModel(colorModel);
            boolean isRowVector = colorByVector.isRowVector();
            if (!rowMajorOrder) {
                isRowVector = !isRowVector;
            }
            chartPropertiesSupplier.setColorBySeries(containsSeries && isRowVector);
        } else {
            chartPropertiesSupplier.setColorByVector(null);
        }
    }

    public static void setMinMax(CoordinateMapper coordinateMapper, XYChartDataset chartDataset) {
        coordinateMapper.setXMax(chartDataset.getXMax());
        coordinateMapper.setYMax(chartDataset.getYMax());
        coordinateMapper.setXMin(chartDataset.getXMin());
        coordinateMapper.setYMin(chartDataset.getYMin());
    }

    public static String xValuesToString(XYChartDataset chartDataset, int seriesIndex) {
        StringBuilder buf = new StringBuilder();
        int items = chartDataset.getItemCount(seriesIndex);
        for (int i = 0; i < items; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(Formatter.format(chartDataset.getX(seriesIndex, i)));
        }
        return buf.toString();
    }

    public static String xyValuesToString(XYChartDataset chartDataset, int seriesIndex) {
        StringBuilder buf = new StringBuilder();
        int items = chartDataset.getItemCount(seriesIndex);
        for (int i = 0; i < items; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("[");
            buf.append(Formatter.format(chartDataset.getX(seriesIndex, i)));
            buf.append(Formatter.format(chartDataset.getY(seriesIndex, i)));
            buf.append("]");
        }
        return buf.toString();
    }

    public static String yValuesToString(XYChartDataset chartDataset, int seriesIndex) {
        StringBuilder buf = new StringBuilder();
        int items = chartDataset.getItemCount(seriesIndex);
        for (int i = 0; i < items; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(Formatter.format(chartDataset.getY(seriesIndex, i)));
        }
        return buf.toString();
    }

    private static int findSeriesLineAtPix(GENEEChart chart, CoordinateMapper coordinateMapper, XYChartDataset chartDataset, int seriesIndex, int xpix, int ypix) {
        if (seriesIndex < 0) {
            return -1;
        }
        int low = 0;
        int high = chartDataset.getItemCount(seriesIndex) - 1;
        if (high == -1) {
            return -1;
        }
        float xValue = coordinateMapper.pixToX(xpix);
        while (low <= high) {
            int mid = low + high >>> 1;
            float midVal = chartDataset.getX(seriesIndex, mid);
            int upperIndex = Math.min(high, mid + 1);
            float upperValue = chartDataset.getX(seriesIndex, upperIndex);
            int lowerIndex = Math.max(low, mid - 1);
            float lowerValue = chartDataset.getX(seriesIndex, lowerIndex);
            if (Float.isNaN(lowerValue) || Float.isNaN(upperValue) || Float.isNaN(midVal)) {
                return -1;
            }
            if (xValue <= midVal && xValue >= lowerValue) {
                return chart.interpolate(coordinateMapper, chartDataset, seriesIndex, lowerIndex, mid, xValue, ypix);
            }
            if (xValue >= midVal && xValue <= upperValue) {
                return chart.interpolate(coordinateMapper, chartDataset, seriesIndex, mid, upperIndex, xValue, ypix);
            }
            if (midVal < xValue) {
                low = mid + 1;
                continue;
            }
            if (!(midVal > xValue)) continue;
            high = mid - 1;
        }
        return -1;
    }
}

