/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import gnu.trove.list.array.TFloatArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.chart.Axis;
import org.broadinstitute.genee.chart.ChartToolTipProvider;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.DefaultXYChartSeries;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.LineAndShapeRenderer;
import org.broadinstitute.genee.chart.ProfileChartSeries;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.chart.grid.ChartUtil;
import org.broadinstitute.genee.chart.grid.ConvertToChart;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.SlicedVector;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.Vector;

public class ConvertToProfileChart
implements ConvertToChart {
    private boolean showCentroid;
    private boolean useMeanForCentroid;
    private boolean rowProfileChart = true;
    private ChartGrid chartGrid;
    public static final String CENTROID_PROPERTY = "Centroid";
    public static final String CENTROID_MEAN_PROPERTY = "Centroid Mean";
    public static final String ADDITIONAL_SERIES_PROPERTY = "Additional Series";
    private int additionalSeriesIndex = -1;
    private String additionalSeriesName;
    private Map<String, Boolean> properies = new HashMap<String, Boolean>();

    public ConvertToProfileChart(boolean rowProfile) {
        this.rowProfileChart = rowProfile;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ConvertToChart copy() {
        ConvertToProfileChart copy = new ConvertToProfileChart(this.rowProfileChart);
        copy.showCentroid = this.showCentroid;
        copy.useMeanForCentroid = this.useMeanForCentroid;
        copy.additionalSeriesName = this.additionalSeriesName;
        copy.properies = new HashMap<String, Boolean>(this.properies);
        return copy;
    }

    @Override
    public void customize(GENEEChart chartPanel, Dataset modelDataset, int[] gridRowIndices, int[] gridColumnIndices, int rowIndex, int columnIndex) {
        this.additionalSeriesIndex = this.additionalSeriesName != null ? DatasetUtil.getSeriesIndex(modelDataset, this.additionalSeriesName) : -1;
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        for (String key : this.properies.keySet()) {
            renderer.setProperty(key, this.properies.get(key));
        }
        this.chartGrid.setProperties(chartPanel, renderer);
        Dataset dataset = DatasetUtil.sliceView(modelDataset, gridRowIndices, gridColumnIndices);
        if (!this.rowProfileChart) {
            dataset = DatasetUtil.transposeView(dataset);
        }
        DefaultXYChartDataset chartDataset = new DefaultXYChartDataset();
        OrientedVector xAxisLabelBy = this.chartGrid.getXLabelBy();
        boolean isXAxisNumeric = false;
        int rows = dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            DatasetRowView rowView = new DatasetRowView(dataset);
            rowView.setIndex(i);
            ProfileChartSeries series = new ProfileChartSeries(rowView, isXAxisNumeric ? xAxisLabelBy : null, "");
            chartDataset.addSeries(series);
        }
        chartPanel.setChartRenderer(renderer);
        ChartUtil.setChartProperties(chartPanel, this.chartGrid, rowIndex, columnIndex, this.rowProfileChart, true, renderer);
        chartPanel.setChartDataset(chartDataset);
        final Dataset _dataset = dataset;
        renderer.setChartToolTipProvider(new ChartToolTipProvider(){

            @Override
            public List<Map.Entry> getToolTipText(XYChartDataset chartDataset, int seriesIndex, int itemIndex) {
                return DatasetUtil.getToolTipText(_dataset, seriesIndex, itemIndex, null, null);
            }
        });
        chartPanel.getSelectionModel().clear();
        if (this.showCentroid) {
            this.addCentroidDataset(chartPanel);
            chartPanel.getSelectionModel().add(1, -1, -1);
        }
    }

    @Override
    public void customizeXAxis(Axis axis, GENEEChart[][] charts, int columnIndex) {
        int itemCount;
        axis.setHorizontalLabelsRotated(true);
        OrientedVector labelByVector = this.chartGrid.getXLabelBy();
        SlicedVector vector = null;
        if (labelByVector != null) {
            int[] nArray;
            boolean matches = this.rowProfileChart && !labelByVector.isRowVector() || !this.rowProfileChart && labelByVector.isRowVector();
            int[] maxIndicesLength = new int[]{};
            int nrows = charts.length;
            for (int i = 0; i < nrows; ++i) {
                int[] tmp;
                int[] nArray2 = tmp = this.rowProfileChart ? this.chartGrid.getDatasetGrid2D().getColumnIndices(i, columnIndex) : this.chartGrid.getDatasetGrid2D().getRowIndices(i, columnIndex);
                if (tmp.length <= maxIndicesLength.length) continue;
                maxIndicesLength = tmp;
            }
            if (matches) {
                nArray = maxIndicesLength;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 0;
            }
            vector = new SlicedVector(labelByVector, nArray);
            itemCount = maxIndicesLength.length;
        } else {
            Dataset modelDataset = this.chartGrid.getDataset();
            Dataset dataset = DatasetUtil.sliceView(modelDataset, this.chartGrid.getDatasetGrid2D().getRowIndices(0, columnIndex), this.chartGrid.getDatasetGrid2D().getColumnIndices(0, columnIndex));
            if (!this.rowProfileChart) {
                dataset = DatasetUtil.transposeView(dataset);
            }
            itemCount = dataset.getColumnCount();
        }
        this.setXAxisLabels(axis, itemCount, vector);
    }

    @Override
    public void customizeYAxis(Axis axis, GENEEChart[][] charts, int rowIndex) {
        axis.setIntegerTicks(false);
    }

    @Override
    public void init(ChartGrid chartGrid) {
        this.chartGrid = chartGrid;
    }

    @Override
    public boolean isXAxisVisible() {
        return true;
    }

    @Override
    public void setProperty(String property, Object value) {
        if (CENTROID_PROPERTY.equals(property)) {
            this.showCentroid = (Boolean)value;
        } else if (CENTROID_MEAN_PROPERTY.equals(property)) {
            this.useMeanForCentroid = (Boolean)value;
        } else {
            this.properies.put(property, (Boolean)value);
        }
    }

    private void addCentroidDataset(GENEEChart chartPanel) {
        XYChartDataset pointsChartDataset = chartPanel.getChartDataset();
        DefaultXYChartDataset chartDataset = new DefaultXYChartDataset();
        DefaultXYChartSeries series = new DefaultXYChartSeries(CENTROID_PROPERTY, pointsChartDataset.getItemCount(0));
        chartDataset.addSeries(series);
        int numItems = pointsChartDataset.getItemCount(0);
        for (int itemIdx = 0; itemIdx < numItems; ++itemIdx) {
            TFloatArrayList bin = new TFloatArrayList();
            for (int seriesIdx = 0; seriesIdx < pointsChartDataset.getSeriesCount(); ++seriesIdx) {
                float y = pointsChartDataset.getY(seriesIdx, itemIdx);
                bin.add(y);
            }
            float x = pointsChartDataset.getX(0, itemIdx);
            series.add(x, this.useMeanForCentroid ? FloatListStatUtils.mean(new TroveFloatList(bin)) : FloatListStatUtils.median(new TroveFloatList(bin)));
        }
        chartPanel.addChartDataset(chartDataset);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setProperty("points", false);
        chartPanel.setChartRenderer(1, renderer);
    }

    private void setXAxisLabels(Axis axis, int columns, Vector xAxisLabelBy) {
        Object[] columnNames = null;
        columnNames = new String[columns];
        if (xAxisLabelBy != null) {
            if (xAxisLabelBy.size() < columns) {
                String val = "";
                try {
                    val = Formatter.toString(xAxisLabelBy.getValue(0));
                }
                catch (Exception x) {
                    System.err.println("Out of bounds");
                }
                Arrays.fill(columnNames, val);
            } else {
                for (int i = 0; i < columns; ++i) {
                    columnNames[i] = Formatter.toString(xAxisLabelBy.getValue(i));
                }
            }
        } else {
            Arrays.fill(columnNames, "");
        }
        float[] tickValues = new float[columns];
        boolean isXAxisNumeric = false;
        if (isXAxisNumeric) {
            for (int i = 0; i < columns; ++i) {
                float x;
                Number n = (Number)xAxisLabelBy.getValue(i);
                tickValues[i] = x = n != null ? n.floatValue() : Float.NaN;
            }
        } else {
            for (int i = 0; i < columns; ++i) {
                tickValues[i] = i;
            }
        }
        axis.setTickLabels((String[])columnNames, tickValues);
    }

    @Override
    public boolean isSizeBySupported() {
        return true;
    }

    @Override
    public boolean isShapeBySupported() {
        return true;
    }
}

