/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import com.google.common.collect.Sets;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.genee.chart.grid.ModelIndicesVector;
import org.broadinstitute.genee.cmap.rankedlist.HighlightTrack;
import org.broadinstitute.genee.gui.CartesianProduct;
import org.broadinstitute.genee.gui.Combination;
import org.broadinstitute.genee.gui.TextSpanPair;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.VectorUtil;

public class DatasetGrid2D
implements CartesianProduct {
    private ModelIndicesVector[] groupColumnsBy;
    private RowAndColumnIndices[][] matrix;
    private ModelIndicesVector[] groupRowsBy;
    private int[] selectedModelRowIndices;
    private int[] selectedModelColumnIndices;
    private List<TextSpanPair>[] rowTextSpanPairs;
    private List<TextSpanPair>[] columnTextSpanPairs;

    @Override
    public int getColumnCount() {
        return this.columnTextSpanPairs == null ? 1 : this.columnTextSpanPairs.length;
    }

    public int[] getColumnIndices(int i, int j) {
        return this.matrix == null ? null : this.matrix[i][j].columns;
    }

    @Override
    public List<TextSpanPair>[] getColumnNames() {
        return this.columnTextSpanPairs;
    }

    public ModelIndicesVector[] getGroupColumnsBy() {
        return this.groupColumnsBy;
    }

    @Override
    public int getGroupColumnsByCount() {
        return this.groupColumnsBy == null ? 0 : this.groupColumnsBy.length;
    }

    public ModelIndicesVector[] getGroupRowsBy() {
        return this.groupRowsBy;
    }

    @Override
    public int getGroupRowsByCount() {
        return this.groupRowsBy == null ? 0 : this.groupRowsBy.length;
    }

    @Override
    public int getRowCount() {
        return this.rowTextSpanPairs == null ? 1 : this.rowTextSpanPairs.length;
    }

    public int[] getRowIndices(int i, int j) {
        return this.matrix == null ? null : this.matrix[i][j].rows;
    }

    @Override
    public List<TextSpanPair>[] getRowNames() {
        return this.rowTextSpanPairs;
    }

    public int[] getSelectedModelColumnIndices() {
        return this.selectedModelColumnIndices;
    }

    public int[] getSelectedModelRowIndices() {
        return this.selectedModelRowIndices;
    }

    public void setGroupBy(ModelIndicesVector[] rowModelIndicesVectors, ModelIndicesVector[] columnModelIndicesVectors) {
        this.matrix = null;
        if (rowModelIndicesVectors != null && rowModelIndicesVectors.length == 0) {
            rowModelIndicesVectors = null;
        }
        if (columnModelIndicesVectors != null && columnModelIndicesVectors.length == 0) {
            columnModelIndicesVectors = null;
        }
        this.groupRowsBy = rowModelIndicesVectors;
        this.groupColumnsBy = columnModelIndicesVectors;
        if (columnModelIndicesVectors != null || rowModelIndicesVectors != null) {
            List<Combination> columnProduct = columnModelIndicesVectors == null ? null : VectorUtil.getCombinations(columnModelIndicesVectors);
            List<Combination> rowProduct = rowModelIndicesVectors == null ? null : VectorUtil.getCombinations(rowModelIndicesVectors);
            List[] columnGroups = null;
            if (columnProduct != null) {
                columnGroups = new List[columnProduct.size()];
                int index = 0;
                for (Combination item : columnProduct) {
                    columnGroups[index++] = item.getValues();
                }
            }
            List[] rowGroups = null;
            if (rowProduct != null) {
                rowGroups = new List[rowProduct.size()];
                int index = 0;
                for (Combination item : rowProduct) {
                    rowGroups[index++] = item.getValues();
                }
            }
            this.rowTextSpanPairs = rowProduct != null ? new List[rowProduct.size()] : null;
            this.columnTextSpanPairs = columnProduct != null ? new List[columnProduct.size()] : null;
            this.matrix = new RowAndColumnIndices[rowProduct != null ? rowProduct.size() : 1][columnProduct != null ? columnProduct.size() : 1];
            if (rowGroups != null) {
                this.rowTextSpanPairs = new List[this.matrix.length];
                for (int i = 0; i < this.matrix.length; ++i) {
                    this.rowTextSpanPairs[i] = new ArrayList<TextSpanPair>();
                }
                HighlightTrack.createNames(this.rowTextSpanPairs, rowProduct, this.groupRowsBy.length);
            }
            if (columnGroups != null) {
                this.columnTextSpanPairs = new List[this.matrix[0].length];
                for (int i = 0; i < this.matrix[0].length; ++i) {
                    this.columnTextSpanPairs[i] = new ArrayList<TextSpanPair>();
                }
                HighlightTrack.createNames(this.columnTextSpanPairs, columnProduct, this.groupColumnsBy.length);
            }
            int nrows = this.matrix.length;
            for (int i = 0; i < nrows; ++i) {
                Set<Integer>[] rowGroupIndices = rowGroups != null ? DatasetGrid2D.getIndices(rowModelIndicesVectors, rowGroups[i]) : null;
                int ncols = this.matrix[0].length;
                for (int j = 0; j < ncols; ++j) {
                    Set<Integer>[] columnGroupIndices = columnGroups != null && columnGroups[j] != null ? DatasetGrid2D.getIndices(columnModelIndicesVectors, columnGroups[j]) : null;
                    Set<Integer> rowIndices = DatasetGrid2D.getIndices(rowGroupIndices, columnGroupIndices, 0);
                    Set<Integer> columnIndices = DatasetGrid2D.getIndices(rowGroupIndices, columnGroupIndices, 1);
                    this.matrix[i][j] = new RowAndColumnIndices(rowIndices != null ? IOUtil.toIntArray(rowIndices) : this.selectedModelRowIndices, columnIndices != null ? IOUtil.toIntArray(columnIndices) : this.selectedModelColumnIndices);
                }
            }
            boolean removeEmpty = true;
            if (removeEmpty) {
                TIntArrayList rowIndices = this.getNonEmptyRowIndices();
                TIntArrayList columnIndices = this.getNonEmptyColumnIndices();
                if (this.columnTextSpanPairs != null && columnIndices.size() != this.columnTextSpanPairs.length) {
                    this.columnTextSpanPairs = IOUtil.subset(this.columnTextSpanPairs, columnIndices);
                }
                if (this.rowTextSpanPairs != null && rowIndices.size() != this.rowTextSpanPairs.length) {
                    this.rowTextSpanPairs = IOUtil.subset(this.rowTextSpanPairs, rowIndices);
                }
                this.matrix = DatasetGrid2D.subset(this.matrix, rowIndices, columnIndices);
            }
        } else {
            this.rowTextSpanPairs = null;
            this.columnTextSpanPairs = null;
            this.matrix = new RowAndColumnIndices[][]{{new RowAndColumnIndices(this.selectedModelRowIndices, this.selectedModelColumnIndices)}};
        }
    }

    public void setGroupByColumns(ModelIndicesVector[] columns) {
        this.setGroupBy(this.groupRowsBy, columns);
    }

    public void setGroupByRows(ModelIndicesVector[] rows) {
        this.setGroupBy(rows, this.groupColumnsBy);
    }

    public void setSelectedModelIndices(int[] selectedModelRowIndices, int[] selectedModelColumnIndices) {
        this.selectedModelRowIndices = selectedModelRowIndices;
        this.selectedModelColumnIndices = selectedModelColumnIndices;
    }

    private TIntArrayList getNonEmptyColumnIndices() {
        TIntArrayList columnIndices = new TIntArrayList();
        if (this.matrix.length == 0) {
            return columnIndices;
        }
        for (int j = 0; j < this.matrix[0].length; ++j) {
            boolean empty = true;
            for (int i = 0; i < this.matrix.length && empty; ++i) {
                if (this.matrix[i][j].columns.length <= 0) continue;
                empty = false;
            }
            if (empty) continue;
            columnIndices.add(j);
        }
        return columnIndices;
    }

    private TIntArrayList getNonEmptyRowIndices() {
        TIntArrayList rowIndices = new TIntArrayList();
        for (int i = 0; i < this.matrix.length; ++i) {
            boolean empty = true;
            for (int j = 0; j < this.matrix[0].length && empty; ++j) {
                if (this.matrix[i][j].rows.length <= 0) continue;
                empty = false;
            }
            if (empty) continue;
            rowIndices.add(i);
        }
        return rowIndices;
    }

    private static Set<Integer>[] getIndices(ModelIndicesVector[] supplier, Collection<Object> values) {
        LinkedHashSet<Integer> rowIndices = null;
        LinkedHashSet<Integer> columnIndices = null;
        if (values != null) {
            int groupIndex = 0;
            for (Object value : values) {
                boolean isRows = supplier[groupIndex].isRowVector();
                Set<Integer> indices = supplier[groupIndex].getModelIndices(value);
                if (!isRows) {
                    if (columnIndices == null) {
                        columnIndices = new LinkedHashSet<Integer>();
                        columnIndices.addAll(indices);
                    } else {
                        columnIndices.retainAll(indices);
                    }
                } else if (rowIndices == null) {
                    rowIndices = new LinkedHashSet<Integer>();
                    rowIndices.addAll(indices);
                } else {
                    rowIndices.retainAll(indices);
                }
                ++groupIndex;
            }
            return new Set[]{rowIndices, columnIndices};
        }
        return null;
    }

    private static Set<Integer> getIndices(Set<Integer>[] rowIndices, Set<Integer>[] columnIndices, int index) {
        Object set = rowIndices != null && columnIndices != null ? (rowIndices[index] != null && columnIndices[index] != null ? Sets.intersection(rowIndices[index], columnIndices[index]) : (rowIndices[index] != null ? rowIndices[index] : columnIndices[index])) : (rowIndices != null ? rowIndices[index] : columnIndices[index]);
        return set;
    }

    private static RowAndColumnIndices[][] subset(RowAndColumnIndices[][] existingArray, TIntArrayList rowIndices, TIntArrayList columnIndices) {
        RowAndColumnIndices[][] tmp = new RowAndColumnIndices[rowIndices.size()][columnIndices.size()];
        for (int i = 0; i < rowIndices.size(); ++i) {
            for (int j = 0; j < columnIndices.size(); ++j) {
                tmp[i][j] = existingArray[rowIndices.getQuick(i)][columnIndices.getQuick(j)];
            }
        }
        return tmp;
    }

    private static class RowAndColumnIndices {
        private int[] rows;
        private int[] columns;

        public RowAndColumnIndices(int[] rows, int[] columns) {
            this.rows = rows;
            this.columns = columns;
        }
    }
}

