/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart.grid;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.broadinstitute.genee.chart.grid.ChartGrid;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.OrientedVector;
import org.broadinstitute.genee.matrix.SlicedVector;
import org.broadinstitute.genee.matrix.Vector;

public class DatasetSplitter {
    private List<Dataset> datasets = new ArrayList<Dataset>();
    private Object[] values;
    private OrientedVector orientedVector;

    public DatasetSplitter(OrientedVector colorByVector, Dataset modelDataset, int[] gridRowIndices, int[] gridColumnIndices, int rowIndex, int columnIndex, ChartGrid chartGrid) {
        this.orientedVector = colorByVector;
        boolean isRowVector = colorByVector.isRowVector();
        int[] modelVectorIndices = isRowVector ? chartGrid.getDatasetGrid2D().getRowIndices(rowIndex, columnIndex) : chartGrid.getDatasetGrid2D().getColumnIndices(rowIndex, columnIndex);
        SlicedVector slicedVector = new SlicedVector(colorByVector, modelVectorIndices);
        LinkedHashMap<Object, TIntArrayList> valueToIndices = new LinkedHashMap<Object, TIntArrayList>();
        int n = slicedVector.size();
        for (int i = 0; i < n; ++i) {
            Object value = slicedVector.getValue(i);
            TIntArrayList vectorIndices = (TIntArrayList)valueToIndices.get(value);
            if (vectorIndices == null) {
                vectorIndices = new TIntArrayList();
                valueToIndices.put(value, vectorIndices);
            }
            vectorIndices.add(i);
        }
        this.values = valueToIndices.keySet().toArray();
        for (Object value : valueToIndices.keySet()) {
            int i;
            int[] indices;
            TIntArrayList vectorIndices = (TIntArrayList)valueToIndices.get(value);
            int size = vectorIndices.size();
            if (size <= 0) continue;
            if (isRowVector) {
                indices = new int[size];
                for (i = 0; i < size; ++i) {
                    indices[i] = gridRowIndices[vectorIndices.getQuick(i)];
                }
                this.datasets.add(DatasetUtil.sliceView(modelDataset, indices, gridColumnIndices));
                continue;
            }
            indices = new int[size];
            for (i = 0; i < size; ++i) {
                indices[i] = gridColumnIndices[vectorIndices.getQuick(i)];
            }
            this.datasets.add(DatasetUtil.sliceView(modelDataset, gridRowIndices, indices));
        }
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public Object[] getValues() {
        return this.values;
    }

    public Vector getVector() {
        return new Vector(){

            @Override
            public Class<?> getColumnClass() {
                return DatasetSplitter.this.orientedVector.getColumnClass();
            }

            @Override
            public Comparator<Object> getComparator() {
                return DatasetSplitter.this.orientedVector.getComparator();
            }

            @Override
            public String getName() {
                return DatasetSplitter.this.orientedVector.getName();
            }

            @Override
            public int size() {
                return DatasetSplitter.this.values.length;
            }

            @Override
            public Object getValue(int index) {
                return DatasetSplitter.this.values[index];
            }

            @Override
            public void setComparator(Comparator<Object> comparator) {
                DatasetSplitter.this.orientedVector.setComparator(comparator);
            }

            @Override
            public Object getProperty(Object key) {
                return DatasetSplitter.this.orientedVector.getProperty(key);
            }

            @Override
            public void removeProperty(Object key) {
                DatasetSplitter.this.orientedVector.removeProperty(key);
            }

            @Override
            public void setColumnClass(Class<?> columnClass) {
                DatasetSplitter.this.orientedVector.setColumnClass(columnClass);
            }

            @Override
            public void setProperty(Object key, Object value) {
                DatasetSplitter.this.orientedVector.setProperty(key, value);
            }

            @Override
            public void setValue(int index, Object value) {
                DatasetSplitter.this.orientedVector.setValue(index, value);
            }

            @Override
            public Collection<Object> getPropertyKeys() {
                return DatasetSplitter.this.orientedVector.getPropertyKeys();
            }
        };
    }
}

